/*-----------------------------------------------------------------------
  AUTOSTRT - copy files from one directory to another and reboot PLC
-----------------------------------------------------------------------*/

Parse Source . . filename
drive = LEFT(filename,2)
UpdateStatus = 5	/* '5' ('99' auf der 7-Segment Anzeige) Wird ausgegeben, wenn das Update funktioniert hat. (ansonsten: '4' (=98))*/

/* Waehrend des Updates blinkt die Status LED */
/* Die Funktion SETLEDSTATUS ist im RTK aktuell noch nicht vorhanden und in Salamander gibt es die Funktion erst ab Version 09.01.141. */
/* Da wir jedoch die genaue OS Version nicht ermitteln können (GetOSVersion ist nicht von Beginn an im Salamander OS vorhanden) und somit nicht wissen, */
/* ob die Funktion vom aktuellen OS unterstützt wird, führen wir das Kommando für Salamander in jedem Fall aus. */
/* Dies führt jedoch bei Versionen < 09.01.141 zu "Bad Command" Fehlern, der Code wird jedoch entsprechend ausgeführt, somit können diese Meldungen ignoriert werden. */

IsSalamander = IsSalamanderOS()
If IsSalamander = 1 Then Do
	cmd = 'SETLEDSTATUS STATUS FLASH'
	Address System cmd
	/*DEVSW-1067 schdan3*/
	/*Die LED 2 Sekunden blinken lassen um bei kurzen Updates, den Updatevorgang besser zu signalisieren*/
	rc = MILLISLEEP(2000)
End

If (stream(drive'\PROG','C','QUERY EXISTS') <> '') Then Do
  Call update_sps
End
If (stream(drive'\VISU','C','QUERY EXISTS') <> '') Then Do
  Call update_visu
End
If (stream(drive'\FILES','C','QUERY EXISTS') <> '') Then Do
  Call update_files
End
/* OS-Department says : first Update Packages, then Install OS */
If (stream(drive'\OS','C','QUERY EXISTS') <> '') & (stream(drive'\OSPACKAGES','C','QUERY EXISTS') <> '') Then Do
 Call update_os_packages
End
If (stream(drive'\OS','C','QUERY EXISTS') <> '') Then Do
 Call update_os
End
If (stream(drive'\BOOT','C','QUERY EXISTS') <> '') Then Do
  Call update_boot
End
If (stream(drive'\LSLDATA\Stations.txt','C','QUERY EXISTS') <> '') Then Do
  Call update_Stations_txt
End 


/* ------------------- Begin: Auswerten der Datei AUTOSTRT_Options.txt ---------------- */
RebootCPU = 0
DelConnFile = 0
OPCUA_file = ''
LVDRuntime = 0
found = 1
input = drive'\AUTOSTRT_Options.txt'  /* Name of the input file       */
Do While (lines(input) > 0)
  input_line = LINEIN(input)
  found = COMPARE(input_line, 'RebootCPU:')/*Checkbox ("Reboot CPU after removing update stick" deaktiviert oder aktiviert ?!*/
  If (found > 1) Then Do
    RebootCPU = SUBSTR(input_line, found)
  End
  Else Do 
    found = COMPARE(input_line, 'OPCUA:')/*OPCUA File kopieren?*/
    If (found > 1) Then Do
      OPCUA_file = SUBSTR(input_line, found)
    End
	Else Do 
		found = COMPARE(input_line, 'DelConnFile:')/*Checkbox ("Delete connection files" deaktiviert oder aktiviert ?*/
		If (found > 1) Then Do
			DelConnFile = SUBSTR(input_line, found)
		End
		Else Do 
			found = COMPARE(input_line, 'LVDRuntime:') /*Checkbox "Runtime" by LVD project: deaktiviert oder aktiviert ?*/
			If (found > 1) Then Do
				LVDRuntime = SUBSTR(input_line, found)
			End
		End
    End
  End
End

/* ----- DEVSW-0623 first parse DelConnFile from AUTOSTRT_Options.txt, then call Delete / Update (overwrite) prjcfg.lcf ----- */
If (stream(drive'\LSLDATA\prjcfg.lcf','C','QUERY EXISTS') <> '') Then Do
  Call update_prjcfg
End
Else Do
  Call delete_prjcfg
End

If (OPCUA_file <> '') Then Do
  Call copy_OPCUAFile OPCUA_file
End
If (stream(drive'\VISULVD','C','QUERY EXISTS') <> '') Then Do
  Call update_visu_LVD
End

/* ------------------- End: Auswerten der Datei AUTOSTRT_Options.txt ---------------- */

/* ------------------- Zahl 99 (Update funktioniert) bzw 98 (Update fehlsgeschlagen) in der 7-Segment Anzeige ausgeben ---------------- */

    cmd = 'setusercpustatus 'UpdateStatus
    Address System cmd

Say ' '
Say 'Update finished!'	

Call SetErrorAndStatusLed
 
/* ---------- "Reboot CPU after removing Update Stick" (falls die Checkbox aktiviert ist) ---------- */
If (RebootCPU == 1) Then Do
  
	/* set CPU in reset to show that update is finished */
	/* Reset notwendig, denn ohne bekommt man in der unteren Schleife nicht mit, dass
	der Stick entfernt wurde. Da es sich hier um asynchronene Ablaeufe handelt,
	und sich die Abläufe somit evt überschneiden, warten wir nun kurz (rc = MILLISLEEP(1000))
	bevor wir dann den UpdateStatus auf der CPU anzeigen.  */
	cmd = 'reset'
	Address System cmd

	rc = MILLISLEEP(1000)

	cmd = 'setusercpustatus 'UpdateStatus
	Address System cmd

	Say ' '
	Say ' Please remove USB media (Terminal will restart after)'
	Say ' '

	cmd = 'echo off'
	Address System cmd

	StickAvailable = 1
	Do While (StickAvailable == 1)
		rc = MILLISLEEP(1000)
		rc = ExistsDrive(filename)
		If rc \= 0 Then Do
			StickAvailable = 0
		End
	End

	cmd = 'echo on'
	Address System cmd

	Say ' USB Media has been removed'

	rc = MILLISLEEP(1000)
	Say ' '
	Say ' System is now rebooting...'

	rc = MILLISLEEP(1000)

	cmd = 'echo off'
	Address System cmd

	cmd = 'Reboot'
	Address System cmd
	
	
	
	exit
End
Else Do

  Call SetErrorAndStatusLed
  
  Say 'Please press Enter to continue or remove stick & reboot'
  input_CR = Linein() 
End
 
 
Exit

ExistsDrive: Procedure
	Parse arg fn
	thisRC = 0
	check=stream(fn,'c','query exists')
	if check='' then thisRC=-1
return thisRC


SetErrorAndStatusLed: Procedure Expose UpdateStatus	

	/* Die Funktion SETLEDSTATUS ist im RTK aktuell noch nicht vorhanden und in Salamander gibt es die Funktion erst ab Version 09.01.141. */
	/* Da wir jedoch die genaue OS Version nicht ermitteln können (GetOSVersion ist nicht von Beginn an im Salamander OS vorhanden) und somit nicht wissen, */
	/* ob die Funktion vom aktuellen OS unterstützt wird, führen wir das Kommando für Salamander in jedem Fall aus. */
	/* Dies führt jedoch bei Versionen < 09.01.141 zu "Bad Command" Fehlern, der Code wird jedoch entsprechend ausgeführt, somit können diese Meldungen ignoriert werden. */

	IsSalamander = IsSalamanderOS()
	If IsSalamander = 1 Then Do
	
		If UpdateStatus = 4 Then Do
			cmd = 'SETLEDSTATUS ERROR ON'
			Address System cmd
		End
		Else Do
			cmd = 'SETLEDSTATUS ERROR OFF'
			Address System cmd
		End

		/* Wenn wir mit dem Update fertig sind, wird die Status LED eingeschalten */
		cmd = 'SETLEDSTATUS STATUS ON'
		Address System cmd
		
	End

return

/*------------Update SPS--------------------------*/

update_sps: Procedure Expose UpdateStatus

  Parse Source . . filename
  drive = LEFT(filename,2)
  source_dir = drive'\PROG'
  dest_dir   = 'C:\LSLWORK'
  
  /************************ BEGIN: DS 4788, SA 31719: Create Bootdisk für all/ARM/x86 Platforms ************************/
  
  ret1 = hwinfo(hi)
  strCompare = 'hi.TARGET'
	
  /* Ist die Funktion hwinfo noch nicht in der verwendeten Rexx.dll vorhanden, so hängt sich das Script jedoch nicht auf, */	
  /* sondern in der Variablen "ret" befindet sich der String "hwinfo(hi)". Um Folgefehler zu vermeiden wird hier auf diesen String geprüft: */
  
  /* COMPARE(string1, string2, pad) */
  /* Returns zero or the position of the first non-match. For differing length strings "pad" is */
  /* compared to the remaining part of the longer string. The default for "pad" is space. */
	  
  strTarget = hi.TARGET
  pos1 = COMPARE(strTarget, strCompare)
  posPlatformType = 123
     
  /* Wenn pos1 = 0 wäre, würden "strTarget" und "strCompare" übereinstimmen. - Darf jedoch nicht sein (siehe Beschreibung oben) */
  If pos1 \= 0 Then Do

	  /* hi.target liefert je nach Platform folgenden Teilstring: */
	  strX86 = 'X86'
	  strARM = 'ARM'
	  
	  IsX86Platform = 0
	  IsARMPlatform = 0
	  	   
	  /* POS(find_this, target_string, start_position) */
	  /* Searches target_string for find_this and returns either the located position or zero if find_this is not found. */
	  
	  posPlatformType = POS(strX86, strTarget)
	  
	  /* Auf X86 Platform pruefen: */
	  If (posPlatformType \= 0) Then Do
		
		IsX86Platform = 1
		source_dir_Platform = source_dir'\x86'
		If (stream(source_dir_Platform, 'C', 'QUERY EXISTS') \= '') Then Do
			source_dir = source_dir_Platform
		End
		
      End
	  Else Do
	  
		/* Handelt sich nicht um X86, dann auf ARM pruefen: */
		
		posPlatformType = POS(strARM, strTarget)
		
		If (posPlatformType \= 0) Then Do
			IsARMPlatform = 1
			source_dir_Platform = source_dir'\arm'
			If (stream(source_dir_Platform, 'C', 'QUERY EXISTS') \= '') Then Do
				source_dir = source_dir_Platform
			End
		End
	  End
    End

	/* pos1 != 1 .. Es gibt die Fkt hwinfo noch nicht (gibts erst ab Rexx.dll 01.01.018) */
	/* posPlatformType = 0 .. Platform Type konnte einfach ermittelt werden (Das Element "target" gibts in hwinfo erst seit Rexx.dll 01.01.020) */	
	If (pos1 \= 1) | (posPlatformType = 0) Then Do
		Say 'Could not determine platform type.'
		
		/* Nur, wenn weder ARM noch Intel Folder existieren, dann fürs Update einfach Standardpfad nehmen: */
		If (stream(source_dir'\arm', 'C', 'QUERY EXISTS') = '') & (stream(source_dir'\x86', 'C', 'QUERY EXISTS') = '') Then Do
			Say 'Try to update from following path: 'source_dir
		End
		Else Do
			UpdateStatus = 4
			Call fatal_error
		End
	End
	
    /************************ END: DS 4788, SA 31719: Create Bootdisk für all/ARM/x86 Platforms ************************/

  If (stream(dest_dir,'C','QUERY EXISTS') = '') Then Do
    cmd = 'MKDIR 'dest_dir
    Address System cmd
    If rc \= 0 Then Do
      Say cmd' failed, rc='rc
      UpdateStatus = 4
      Call fatal_error
    End
  End
  Else Do
    Call DirList dest_dir'\*', listOSFiles
    If (listOSFiles.0 >= 3 ) Then Do
       Say 'Delete old LSLWORK Files'
       cmd = 'DEL 'dest_dir'\*'
       Address System cmd
    End
  End

  Say 'Update LSLWORK ...'  
  
  cmd = 'XCOPY 'source_dir'\* 'dest_dir
  Address System cmd
  If rc \= 0 Then Do
    Say cmd' failed, rc='rc
    UpdateStatus = 4
    Call fatal_error
  End
  
  return




/*------------Update VISU--------------------------*/

update_visu: Procedure Expose UpdateStatus

  Parse Source . . filename
  drive = LEFT(filename,2)
  source_dir = drive'\VISU'
  source_dir_img = drive'\VISU\IMAGE'
  dest_dir_img = 'C:\MPC\IMAGE'
  dest_dir   = 'C:\MPC'

  If (stream(dest_dir,'C','QUERY EXISTS') = '') Then Do
    cmd = 'MKDIR 'dest_dir
    Address System cmd
    If rc \= 0 Then Do
      Say cmd' failed, rc='rc
      UpdateStatus = 4
      Call fatal_error
    End
  End  
  Else DO
    Call DirList dest_dir'\*', listOSFiles
    If (listOSFiles.0 >= 3 ) Then Do
       Say 'Delete old MPC Files'
       cmd = 'DEL 'dest_dir'\*'
       Address System cmd
    End
  End

  Say 'Update Visu ...'
  cmd = 'XCOPY 'source_dir'\* 'dest_dir
  Address System cmd
  If rc \= 0 Then Do
    Say cmd' failed, rc='rc
    UpdateStatus = 4
    /*Call fatal_error*/
  End

  cmd = 'XCOPY 'source_dir'\ipc.ini C:\'
  Address System cmd
  If rc \= 0 Then Do
    Say cmd' failed, rc='rc
    UpdateStatus = 4
    Call fatal_error
  End

  /* DS 4288: Prüfen, ob überhaupt ein Image Folder am Stick existiert. Kann natürlich nur dann auf die Steuerung kopiert werden. */
  If (stream(source_dir_img,'C','QUERY EXISTS') <> '') Then Do
	  
	  /* Sofern die Directory noch nicht existiert, muss sie erzeugt werden. Ansonsten gleich XCOPY ausführen. */
	  If (stream(dest_dir_img,'C','QUERY EXISTS') = '') Then Do

		  cmd = 'MKDIR 'dest_dir'\image'
		  Address System cmd
		  If rc \= 0 Then do
			Say cmd' failed, rc='rc
			UpdateStatus = 4
			Call fatal_error
		  End
      End
	  Else DO
		Call DirList dest_dir_img'\*', listImageFiles
		If (listImageFiles.0 > 0 ) Then Do
		   Say 'Delete old Image Files'
		   cmd = 'DEL 'dest_dir_img'\*'
		   Address System cmd
		End
      End

	  Say 'Update Images ...'
	  cmd = 'XCOPY 'source_dir_img'\* 'dest_dir_img
	  Address System cmd
	  If rc \= 0 Then Do
		Say cmd' failed, rc='rc
		UpdateStatus = 4
		Call fatal_error
	  End
  End

  return


/*------------Update VISU LVD --------------------------*/

update_visu_LVD: Procedure Expose UpdateStatus LVDRuntime
	Parse Source . . filename
	drive = LEFT(filename,2)
	source_dir = drive'\VISULVD'
	dest_dir   = 'C:\LSLVISU'
	dest_dir_webroot = 'C:\LSLVISU\WEBROOT'
	dest_dir_runtime = dest_dir_webroot'\RT'
	dest_file_runtime_version = 'version.json'
	tmp_dir_runtime = 'C:\LSLVISU_RT_TMP'
	tmp_dir_runtime_version = 'C:\LSLVISU_RT_TMPV'
	
	Say 'Update Visu LVD ...'
	
	/* exists Runtime-directory on PLC? */
	bExistRuntimeDir_PLC = (stream(dest_dir_runtime,'C','QUERY EXISTS') \= '')
	/* exists Runtime-Version-file on PLC? */
	bExistRuntimeVersionFile_PLC = (stream(dest_dir_webroot'\'dest_file_runtime_version,'C','QUERY EXISTS') \= '')
	
	/* keep old Runtime? save to to tmp-directory */
	If (LVDRuntime == 0) Then Do
	
		Say 'Save LVD Runtime'
		If (bExistRuntimeDir_PLC == 1) Then Do
			/* empty tmp-dir */
			If (stream(tmp_dir_runtime,'C','QUERY EXISTS') = '') Then Do
				cmd = 'MKDIR 'tmp_dir_runtime
				Address System cmd
				If rc \= 0 Then Do
				  Say cmd' failed, rc='rc
				  UpdateStatus = 4
				  Call fatal_error
				End
			End
			Else Do
				Call DirList tmp_dir_runtime'\*', listOSFiles
				If (listOSFiles.0 >= 3 ) Then Do
				   Call delete_directory_recursive tmp_dir_runtime, 0
				End
			End
			
			/* move content of Runtime-directory to tmp-dir. Directory must exist */
			/* CLI-help : [/R] = copy subdirectories (recursiv) */
			cmd = 'XCOPY ' dest_dir_runtime tmp_dir_runtime '/R'
			Address System cmd
			If rc \= 0 Then Do
				Say cmd' failed, rc='rc
				UpdateStatus = 4
				Call fatal_error
			End
		End
		
		If (bExistRuntimeVersionFile_PLC == 1) Then Do
			/* empty tmp-dir */
			If (stream(tmp_dir_runtime_version,'C','QUERY EXISTS') = '') Then Do
				cmd = 'MKDIR 'tmp_dir_runtime_version
				Address System cmd
				If rc \= 0 Then Do
				  Say cmd' failed, rc='rc
				  UpdateStatus = 4
				  Call fatal_error
				End
			End
			Else Do
				Call DirList tmp_dir_runtime_version'\*', listOSFiles
				If (listOSFiles.0 >= 3 ) Then Do
					cmd = 'DEL 'tmp_dir_runtime_version'\*'
					Address System cmd
					If rc \= 0 Then Do
					  Say cmd' failed, rc='rc
					  UpdateStatus = 4
					  Call fatal_error
					End
				End
			End
			
			/* move version.json to tmp-dir */
			/* file must exist */
			If (bExistRuntimeVersionFile_PLC == 1) Then Do
				cmd = 'XCOPY 'dest_dir_webroot'\'dest_file_runtime_version tmp_dir_runtime_version'\'dest_file_runtime_version
				Address System cmd
				If rc \= 0 Then Do
				  Say cmd' failed, rc='rc
				  UpdateStatus = 4
				  Call fatal_error
				End
			End
		End
	End
	
	/* empty target directory */
	If (stream(dest_dir,'C','QUERY EXISTS') = '') Then Do
		cmd = 'MKDIR 'dest_dir
		Address System cmd
		If rc \= 0 Then Do
		  Say cmd' failed, rc='rc
		  UpdateStatus = 4
		  Call fatal_error
		End
	End
	Else DO
		Call DirList dest_dir'\*', listOSFiles
		If (listOSFiles.0 >= 3 ) Then Do
		   Say 'Delete old LVD files'
		   Call delete_directory_recursive dest_dir, 0
		End
	End
		
	/* copy LVD-project files to target directory */
	Say 'Copy files of LVD project'
	cmd = 'XCOPY ' source_dir dest_dir '/R'
	Address System cmd
	If rc \= 0 Then Do
		Say cmd' failed, rc='rc
		UpdateStatus = 4
		Call fatal_error
	End

	/* update Runtime */
	If (LVDRuntime == 0) Then Do
		Say 'Restore LVD Runtime'

		/* restore content of runtime dir */
		If (bExistRuntimeDir_PLC == 1) Then Do
			/* create runtime dir */
			cmd = 'MKDIR 'dest_dir_runtime
			Address System cmd
			If rc \= 0 Then Do
				Say cmd' failed, rc='rc
				UpdateStatus = 4
				Call fatal_error
			End
			
			/* restore content of runtime dir */
			cmd = 'XCOPY ' tmp_dir_runtime dest_dir_runtime '/R'
			Address System cmd
			If rc \= 0 Then Do
				Say cmd' failed, rc='rc
				UpdateStatus = 4
				Call fatal_error
			End
		End

		/* restore version.json */
		If (bExistRuntimeVersionFile_PLC == 1) Then Do
			cmd = 'XCOPY 'tmp_dir_runtime_version'\'dest_file_runtime_version dest_dir_webroot'\'dest_file_runtime_version
			Address System cmd
			If rc \= 0 Then Do
				Say cmd' failed, rc='rc
				UpdateStatus = 4
				Call fatal_error
			End
		End

		/* Clean tmp-dir */
		Say 'Delete tmp files'
		If (bExistRuntimeDir_PLC == 1) Then Do
			Call delete_directory_recursive tmp_dir_runtime, 1
		End
		If (bExistRuntimeVersionFile_PLC == 1) Then Do
			Call delete_directory_recursive tmp_dir_runtime_version, 1
		End
	End
	return

	
/*------------ deleting non-empty directory --------------------------*/
delete_directory_recursive: Procedure
	ARG dir_name, bDelRoot
	
	retCode = 1

	/* delete all files in directoty */
	cmd = 'DEL 'dir_name'\*'
	Address System cmd
	If rc \= 0 Then Do
	  Say cmd' failed, rc='rc
	  UpdateStatus = 4
	End

	/* clean subdirectories */
	Call DirList dir_name'\*', listFilesOfDir
	i = 1
	Do While (i <= listFilesOfDir.0 & retcode \= 0) 
		If listFilesOfDir.i.A_SUBDIR & (listFilesOfDir.i.Name \= '.') &  (listFilesOfDir.i.Name \= '..') Then Do
			sub_dir = dir_name'\'listFilesOfDir.i.Name
			Call delete_directory_recursive sub_dir, 1
		End
		i = i+1
	End
	
	/* all files are deleted - we can remove the empty directory, if parameter "bDelRoot" says to do it */
	If (bDelRoot == 1) Then Do
		cmd = 'RMDIR 'dir_name
		Address System cmd
		If rc \= 0 Then Do
			Say 'Deliting of directory 'dir_name' failed, rc='rc
			UpdateStatus = 4
			retCode = 0
		End
	End
	return retCode
	

 /*------------Update Autoexec.lsl--------------------------*/

update_boot: Procedure Expose UpdateStatus

  Parse Source . . filename
  drive = LEFT(filename,2)
  source_dir    = drive'\BOOT'
  dest_dir      = 'C:\\'
  dest_temp_dir = 'C:\BOOT_TMP'

  If (stream(dest_temp_dir,'C','QUERY EXISTS') = '') Then Do
    cmd = 'MKDIR 'dest_temp_dir
    Address System cmd
    If rc \= 0 Then Do
      Say cmd' failed, rc='rc
      UpdateStatus = 4
      Call fatal_error
    End
  End  
  Else DO
    Call DirList dest_temp_dir'\*', listOSFiles
    If (listOSFiles.0 >= 3 ) Then Do
       Say 'Delete old temporary BOOT files'
       cmd = 'DEL 'dest_temp_dir'\*'
       Address System cmd
    End
  End

  Say 'Update Autoexec.lsl ...'
  
  /* copy files into a temporary directory to be able to overwrite the */
  /* file autoexec.lsl after unplugging the USB stick */
  cmd = 'XCOPY 'source_dir'\* 'dest_temp_dir
  Address System cmd
  If rc \= 0 Then Do
    Say cmd' failed, rc='rc
    UpdateStatus = 4
    Call fatal_error
  End
  
  cmd = 'QUCMD XCOPY 'dest_temp_dir'\* 'dest_dir
  Address System cmd
  If rc \= 0 Then Do
    Say cmd' failed, rc='rc
    UpdateStatus = 4
    Call fatal_error
  End

  Call DirList dest_temp_dir'\*', listOSFiles
  If (listOSFiles.0 >= 3 ) Then Do
     Say 'Delete temporary BOOT files'
     cmd = 'QUCMD DEL 'dest_temp_dir'\*'
     Address System cmd
  End
  
  cmd = 'QUCMD RMDIR 'dest_temp_dir
  Address System cmd
  
  return

/*------------Begin: delete_prjcfg--------------------------*/
delete_prjcfg: Procedure Expose DelConnFile

  If (DelConnFile == 1) Then Do
	file = 'C:\LSLDATA\prjcfg.lcf'
	
	If (stream(file,'C','QUERY EXISTS') \= '') Then Do
		cmd = 'DEL 'file
		Address System cmd
	End
  End
  return
/*------------End: delete_prjcfg--------------------------*/


/*------------Begin: update_prjcfg--------------------------*/

update_prjcfg: Procedure Expose UpdateStatus

  Say 'Update connection file (prjcfg.lcf) ...'
  
  retCode = 1
  
  Parse Source . . filename
  drive = LEFT(filename,2)
  dest_dir   = 'C:\LSLDATA'
  source_dir_file = drive'\LSLDATA\prjcfg.lcf'
  
  /* Sollte das LSLDATA Verzeichnis auf der CPU noch nicht existieren, dann erzeugen: */
  If (stream(dest_dir,'C','QUERY EXISTS') = '') Then Do
	cmd = 'MKDIR 'dest_dir
	Address System cmd
	If rc \= 0 Then Do
	  Say cmd' failed, rc='rc
	  UpdateStatus = 4
	  retCode = 0
	End
  End
  
  /* Nun das prjcfg.lcf File auf die Steuerung kopieren: */
  If retCode = 1 Then Do
	cmd = 'XCOPY 'source_dir_file dest_dir
	Address System cmd
	
	If rc \= 0 Then Do
      Say cmd' failed, rc='rc
      UpdateStatus = 4
      Call fatal_error
    End
    Else Do
      Say cmd 'OK!'
    End
  End
  
  return
  
/*------------End: update_prjcfg--------------------------*/
  
/*------------IsDriveInfoAvailable------------------------*/

IsDriveInfoAvailable: Procedure
	
	IsAvailable = 0
	
	bIsSalamaner = IsSalamanderOS()
	
	ret1 = hwinfo(hi)

	parse var hi.osversion MajorMajor "." Major "." Minor
	
	if bIsSalamaner <> 0 then do
		if MajorMajor == 09 then do
			if Major == 02 & Minor >= 020 then do
				IsAvailable = 1
			end
			else if Major == 03 & Minor >= 079 then do
				IsAvailable = 1
			end
			/* für die Zukunft */
			else if Major > 3 then do
				IsAvailable = 1
			end
		end
	end
	else do		/*--------RTK OS--------*/
		if MajorMajor >= 01 & Major >= 03 & Minor >= 109 then do
			parse version interpreterVersion dllVersion rest
			parse var dllVersion strMajorMajor "." strMajor "." strMinor	
			if strMinor >= 024 then do
				IsAvailable = 1
			end
		end
	end
	
	return IsAvailable
  
/*------------End: IsDriveInfoAvailable--------------------------*/
  
/*------------Update OS--------------------------*/
update_os: Procedure Expose UpdateStatus
  Parse Source . . filename
  drive = LEFT(filename,2)
  source_dir = drive'\OS\'
  dest_temp_dir = 'C:\OS_TMP'
  
  isDriveInfoAvailable = IsDriveInfoAvailable()
  
  If isDriveInfoAvailable <> 0 Then Do
	retcode = DRIVEINFO('LOCAL', 'N/A', 'C', stem)
	FileSize = 0
  
    Call DirList source_dir'*', listOSFiles
  
	i = 1
	Do While (i <= listOSFiles.0) 
	  FileSize = FileSize + listOSFiles.i.SIZE
	  i = i+1
	End
	  
	If FileSize > stem.FREE_BYTES Then Do
	  Say '******************Not enough free space******************'
	  Say 'Free Space: ' stem.FREE_BYTES
	  Say 'OS Size: ' FileSize
	  return
	End
  End
  
  /* DS 4385: Anhand der OS Version (genauergesagt anhand der vorderen Versionsnummer) wird nun ermittelt, ob es sich um RTK oder Salamander handelt. */
  IsSalamander = IsSalamanderOS()

  /* Handelt es sich um RTK OS, dann muss weiterhin eine TempDir erstellt werden: */
  If IsSalamander <> 1 Then Do
	  If (stream(dest_temp_dir,'C','QUERY EXISTS') = '') Then Do
		cmd = 'MKDIR 'dest_temp_dir
		Address System cmd
		If rc \= 0 Then Do
		  Say cmd' failed, rc='rc
		  UpdateStatus = 4
		  Call fatal_error
		End
	  End  
	  Else DO
		Call DirList dest_temp_dir'\*', listOSFiles
		If (listOSFiles.0 >= 3 ) Then Do
		   Say 'Delete old temporary OS files'
		   cmd = 'DEL 'dest_temp_dir'\*'
		   Address System cmd
		End
	  End
  End
  
  Call DirList source_dir'*', listOSFiles
  i = 1
  Do While ( (i <= listOSFiles.0) & listOSFiles.i.A_SUBDIR ) 
    i = i+1
  End
  
  If (listOSFiles.0 >= i ) Then Do
    Say 'Update OS ...('source_dir''listOSFiles.i.Name')'  
  
    /* copy file into a temporary directory to be able to update the */
    /* operating system after unplugging the USB stick */
  
    /* Handelt es sich um RTK OS, dann muss weiterhin eine TempDir erstellt werden: */
    If IsSalamander <> 1 Then Do
		cmd = 'XCOPY 'source_dir''listOSFiles.i.Name' 'dest_temp_dir
		Address System cmd
		If rc \= 0 Then Do
		  Say cmd' failed, rc='rc
		  UpdateStatus = 4
		  Call fatal_error
		End
		
		cmd = 'Boot 'dest_temp_dir'\'listOSFiles.i.Name
		Address System cmd
    End
	Else Do
	
		/* In Salamander OS Version 122 wurde ein Fehler beim XCOPY behoben. */
		/* Damit dieser Fehler auch bei älteren Versionen nicht mehr auftritt, */
		/* muss das .lbi File auf C:\\ gelöscht werden, bevor der Boot-Befehl ausgefuehrt wird. */
		
		file = 'C:\sigmatek-os-image.lbi'
		
		If (stream(file,'C','QUERY EXISTS') \= '') Then Do			
			cmd = 'DEL 'file
		    Address System cmd
		End
		
		cmd = 'Boot 'source_dir''listOSFiles.i.Name
		Address System cmd
	End
  
    /* Handelt es sich um RTK OS, dann muss die zuvor erstellte TempDir hier wieder gelöscht werden: */
    If IsSalamander <> 1 Then Do
		Say 'Delete temporary OS files'
		cmd = 'QUCMD DEL 'dest_temp_dir'\*'
		Address System cmd
	  
		cmd = 'QUCMD RMDIR 'dest_temp_dir
		Address System cmd
	End
  End
  
  return
  
/*------------ Update OS Packages --------------------------*/
update_os_packages: Procedure Expose UpdateStatus
  Parse Source . . filename
  drive = LEFT(filename,2)
  source_dir = drive'\OSPACKAGES\'
  dest_dir = 'C:\LSLSYS\PACKAGES\'
  
  /* clean target directory */
	If (stream(dest_dir,'C','QUERY EXISTS') = '') Then Do
		cmd = 'MKDIR 'dest_dir
		Address System cmd
		If rc \= 0 Then Do
		  Say cmd' failed, rc='rc
		  UpdateStatus = 4
		  Call fatal_error
		End
	End  
	Else DO
		Call DirList dest_dir'\*', listOSPackages
		If (listOSPackages.0 >= 3 ) Then Do
		   Say 'Clean directory OSPackages'
		   cmd = 'DEL 'dest_dir'*'
		   Address System cmd
		End
	End
  
  
  /* get all package-files from bootdisk */
  
  Call DirList source_dir'*', listOSPackages
  
  If (listOSPackages.0 >= 3 ) Then Do
    Say 'Update OS packages ...'  
	
	i = 1
	Do While (i <= listOSPackages.0) 
	
		If (listOSPackages.i.Name \= '.') & (listOSPackages.i.Name \= '..') Then Do
		
			PackageName = SUBSTR(listOSPackages.i.Name, 1, LENGTH(listOSPackages.i.Name)-4)
			Say 'Installing package: ' PackageName
		
			/* copy file into a target directory */
			cmd = 'XCOPY 'source_dir''listOSPackages.i.Name' 'dest_dir
			Address System cmd
			If rc \= 0 Then Do
			  Say cmd' failed, rc='rc
			  UpdateStatus = 4
			End
			
			/* Unzip file in target directory */
			Else Do
				/* As we don't know, which OS version they installing, */
				/* we can't know if we must unzip the package, or use zip-file. */
				/* To be sure, make both. */
				cmd = 'UNZIP 'dest_dir''listOSPackages.i.Name' 'dest_dir
				Address System cmd
				If rc \= 0 Then Do
				  Say cmd' failed, rc='rc
				  UpdateStatus = 4
				End
				
				/* Get package name from file name - without ".zip"*/
				Else Do
					
					/* Uninstall package */
					cmd = 'PACKAGE UNINSTALL 'PackageName
					Address System cmd
					If rc \= 0 Then Do
					  Say cmd' failed, rc='rc
					End

					/* Install package */
					cmd = 'PACKAGE INSTALL 'PackageName
					Address System cmd
					If rc \= 0 Then Do
					  Say cmd' failed, rc='rc
					  UpdateStatus = 4
					End
					
					/* do not clean target directory. otherwise he can't install packages correct after reboot */
				End
			End
		End
		
		i = i + 1
		
	End
  End	
  return
  
 /*------------Update FILES--------------------------*/

update_files: Procedure Expose UpdateStatus

  Parse Source . . filename
  drive = LEFT(filename,2)
  source_dir = drive'\FILES'
  dest_dir   = 'C:\'

  Say 'Update Files ...'
  Call copy_directory_recursive source_dir, dest_dir
  If RESULT \= 1 Then Do
    Say 'Updating Files failed'
    UpdateStatus = 4
  End
 
  return
  
copy_directory_recursive: Procedure
	ARG dir_name, dest_dir
	retCode = 1
    
	If (stream(dest_dir,'C','QUERY EXISTS') = '') Then Do
		cmd = 'MKDIR "'dest_dir'"'
		Address System cmd
		If rc \= 0 Then Do
			Say cmd' failed, rc='rc
			UpdateStatus = 4
			retCode = 0
		End
	End 
  
	If retCode = 1 Then Do
    
		Call DirList dir_name'\*', listFilesOfDir
  
		copyFiledone = 0
		i = 1
	
		Do While (i <= listFilesOfDir.0 & retcode \= 0) 
			If listFilesOfDir.i.A_SUBDIR & (listFilesOfDir.i.Name \= '.') &  (listFilesOfDir.i.Name \= '..') Then Do
			
				sub_dir = dir_name'\'listFilesOfDir.i.Name
			
				/* Check if other directory than c: */
				isOtherDrive = abbrev(listFilesOfDir.i.Name, 'Drive(') 	
				If isOtherDrive = 1 Then Do
					drive = Substr(listFilesOfDir.i.Name, 7, 1) 
					drive_dir = drive':\'				
					Call copy_directory_recursive sub_dir, drive_dir
				End
				Else Do
					sub_dest_dir = dest_dir'\'listFilesOfDir.i.Name
					Call copy_directory_recursive sub_dir, sub_dest_dir	
				End
			
				If RESULT \= 1 Then Do
					Say 'Recursive copying of directory 'sub_dir' to directory 'sub_dest_dir' failed, rc='rc
					UpdateStatus = 4
					retCode = 0
				End
			End
			Else If (listFilesOfDir.i.Name \= '.') & (listFilesOfDir.i.Name \= '..') Then Do
				/* [DS4972] Kopiere alle Dateien in diesem Verzeichnis */
				If retCode = 1 & copyFiledone = 0 Then Do
					cmd = 'XCOPY "'dir_name'\*" "'dest_dir'"'
					Address System cmd
					If rc \= 0 Then Do
						Say cmd' failed, rc='rc
						UpdateStatus = 4
						retCode = 0
					End
					copyFiledone = 1
				End
			End
			i = i+1
		End
	End
  
return retCode
  
/*------------Begin: IsSalamander--------------------------*/

/* DS 4604 / DS 4385(Fehlerbehebung von DS 4604) */
/* Ermittlung, ob es sich um RTK oder Salamander handelt. */
/* Keine schöne Lösung, aber eine andere Möglichkeit zur Ermittlung der .dll- bzw der OS-Version (Salamander/RTK) gibt es aktuell nicht. */
/* Mittels der Funktion GetOSVersion2 würde man zwar die OS Version bekommen, da diese Fkt aber erst ab der Rexx.dll Version 01.01.011 drin ist, */
/* bräuchte man sowieso wieder die .dll-Version - welche jedoch im Salamander aktuell noch nicht entsprechend angegeben wird. */
IsSalamanderOS: Procedure
	
	IsSalamander = 0

	/* DS 4604 / DS 4385(Fehlerbehebung von DS 4604) */
	/* Rexx.dll-Version ermitteln: */
	/* RTK liefert als Rexx-Interpreter-Level die Version der Rexx.dll zurück (zB 01.01.016) */
	/* Salamander liefert als Rexx-Interpreter-Level zB die Version 5.0 zurück. */
	/* Ist die Minor-Version also leer, so können wir davon ausgehen, dass es sich um ein Salamander OS handelt */
	/* Für die Zukunft (Anweisung von Gangl): Falls Salamander irgendwann auch die "richtige" Rexx.dll Version liefert, */
	/* so soll die Major-Major-Version von ihnen auf >= 9 gesetzt werden, um Salamander/RTK auch in diesem Fall unterscheiden zu können. */
	parse version interpreterVersion dllVersion rest
	
	/* Major-/Minor-Versionen aus Rexx.dll-Version ermitteln: */
	parse var dllVersion strMajorMajor "." strMajor "." strMinor

	/* Salamander: strMinor ist leer */
	If ( (length(strMajorMajor) > 0) & (length(strMajor) > 0) ) Then Do
		If (length(strMinor) == 0) Then Do
			IsSalamander = 1
		End
		Else Do
			tempOS = abs(strMajorMajor)
			If tempOS >= 9 Then Do
				IsSalamander = 1
			End
		End
	End
	
	return IsSalamander
	
/*------------End: IsSalamander--------------------------*/


/*------------Begin: copyOPCUAFile--------------------------*/
copy_OPCUAFile: Procedure expose OPCUA_file
  Parse Source . . filename
  retCode = 1
  drive = LEFT(filename,2)
  OPCUASource = drive'\OPCUA\OPC_UA.xml'
  /*Directory fuer das OPCUA File anlegen*/
  posBackslash = Lastpos('\', OPCUA_file)
  OPCUA_dir = Left(OPCUA_file, posBackslash)
  posBackslash = pos('\', OPCUA_dir, 4)
  DO WHILE (posBackslash > 0)
    PartOfOPCDir = Left(OPCUA_dir, posBackslash-1)
    If (stream(PartOfOPCDir,'C','QUERY EXISTS') = '') Then Do
      cmd = 'MKDIR "'PartOfOPCDir'"'
      Address System cmd
      If rc \= 0 Then Do
        Say cmd' failed, rc='rc
        UpdateStatus = 4
        retCode = 0
      End
    End 
    posBackslash = pos('\', OPCUA_dir, posBackslash+1)
  END
  /*OPCUA File kopieren*/
  If retCode = 1 Then Do
    cmd = 'COPY "'OPCUASource'" "'OPCUA_file'"'
    Address System cmd
    If rc \= 0 Then Do
      Say cmd' failed, rc='rc
      UpdateStatus = 4
      Call fatal_error
    End
    Else Do
      say cmd 'OK!'
    End
  End
  Address System cmd
Return retCode
/*------------End: copyOPCUAFile--------------------------*/

/*------------Begin: update_Stations_txt--------------------------*/

update_Stations_txt: Procedure Expose UpdateStatus

  Say 'Update MultiMaster Stations.txt file ...'
  
  retCode = 1
  
  Parse Source . . filename
  drive = LEFT(filename,2)
  dest_dir   = 'C:\LSLDATA'
  source_dir_file = drive'\LSLDATA\Stations.txt'
  
  /* Sollte das LSLDATA Verzeichnis auf der CPU noch nicht existieren, dann erzeugen: */
  If (stream(dest_dir,'C','QUERY EXISTS') = '') Then Do
	cmd = 'MKDIR 'dest_dir
	Address System cmd
	If rc \= 0 Then Do
	  Say cmd' failed, rc='rc
	  UpdateStatus = 4
	  retCode = 0
	End
  End
  
  /* Nun das Stations.txt File auf die Steuerung kopieren: */
  If retCode = 1 Then Do
	cmd = 'XCOPY 'source_dir_file dest_dir
	Address System cmd
	
	If rc \= 0 Then Do
      Say cmd' failed, rc='rc
      UpdateStatus = 4
      Call fatal_error
    End
    Else Do
      Say cmd 'OK!'
    End
  End
  
  return
  
/*------------End: update_Stations_txt--------------------------*/

/*------------Fehlermeldung ausgeben---------------*/
fatal_error: Procedure Expose UpdateStatus
	
  UpdateStatus = 4

  Parse Source . . filename
  Say
  Say
  Say 'Fatal error while executing 'filename
  Say ' ************************************************'
  Say ' ***                                          ***'
  Say ' ***              System halted               ***'
  Say ' ***                                          ***'
  Say ' ************************************************'
  Say
  Say
  Return

Exit