//variabile che conterrà il nome della pagina su cui si opera
var pagina = '';

//variabile che conterrà le tabelle che recupero di default
var tabelle = null;

$(document).ready(function(){
	
	pagina = $('html').attr('data-pagina');
	
	//codice comune a tutte le sezioni
	tools();
	
	// NAVIGAZIONE
	$('#icon-menu a').click(function() {

        var menuLaterale = $('.page');
        var slide = '';

        if ( menuLaterale.hasClass('close-menu') ) {
            slide = '0%';
            menuLaterale.addClass('open-menu');
            menuLaterale.removeClass('close-menu');
        } else {

            var larghezzaBrowser = $(window).width();

            if ( larghezzaBrowser < 480 ) {
                slide = '+100%';
            } else {
                slide = '+30%';
            }

            menuLaterale.addClass('close-menu');
            menuLaterale.removeClass('open-menu');
        }

        $('.page').animate({
            left: slide
        });

    });

	$('.treeview').click(function() {
        $(this).find('ul.treeview-menu').slideToggle(200);
    });

    // LOGOUT
    $('.utente').click(function() {
        $('#user-info').slideToggle();
    });
	
	//azioni da fare per una specifica pagina
	switch ( pagina ) {
		
		case 'index':{
			
			//LOGIN
			
			break;
		}
		
		case 'dashboard':{}
		
		case 'accessori-associa':{
			
			$('.tondo').click(function() {

		        var tondo = $(this);
		        var collezioni = $('#collezioni');
		
		        if ( tondo.hasClass('tondo-active') ) {
		            tondo.removeClass('tondo-active');
		        } else {
		            tondo.addClass('tondo-active');
		            collezioni.show();
		        }
		
		        $('#elenco > .row-footer').show();
		
		    });

		    $('.collezione').click(function() {
		
		        var collezioni = $('#collezioni');
		        var collezione = $(this);
		        var famiglie = $('#famiglie');
		
		        if ( collezione.hasClass('collezione-active') ) {
		            collezione.removeClass('collezione-active');
		        } else {
		            collezione.addClass('collezione-active');
		            famiglie.show();
		        }
		
		        collezioni.hide();
		
		    });
		
		    $('.famiglia').click(function() {
		
		        var famiglia = $(this);
		        var prodotti = $('#prodotti');
		
		        if ( famiglia.hasClass('famiglia-active') ) {
		            famiglia.removeClass('famiglia-active');
		        } else {
		            famiglia.addClass('famiglia-active');
		            prodotti.show();
		        }
		
		    });
		
		    $('.prodotto').click(function() {
		
		        var prodotto = $(this);
		        var prodotti = $('#prodotti');
		
		        if ( prodotto.hasClass('prodotto-active') ) {
		            prodotto.removeClass('prodotto-active');
		        } else {
		            prodotto.addClass('prodotto-active');
		        }
		
		        $('#bottone-associa').show();
		
		    });
			
			break;
		}
		
		case 'disponibilita-list':{
			
			$('.eliminaDisponibilita').click(function(){
				
				var messaggio = 'Verrà eliminato <strong class="colorPrimary">l\'intero documento</strong> e l\'operazione è <strong class="colorPrimary">irreversibile</strong><br>Sicuro di voler continuare?';
				
				bootbox.dialog({
				  message: messaggio,
				  buttons: {
				    main: {
				      label: "Annulla",
				    },
				    danger: {
				      label: "Elimina disponibilità",
				      className: "btn-primaryColor",
				      callback: function() {
				        
				      }
				    }
				  }
				});
				
			});
			
			break;
		}
		
		case 'disponibilita-new':{
			
			function azioniDisponibilita(){
				
				var rimuoviDisponibilita = $('.rimuoviDisponibilita');
				rimuoviDisponibilita.unbind('click');
				rimuoviDisponibilita.click(function(){
					
					var messaggio = 'Sicuro di voler rimuovere questa disponibilità?';
					var li = $(this).parents('li');
					
					bootbox.dialog({
					  message: messaggio,
					  buttons: {
					    main: {
					      label: "Annulla",
					    },
					    danger: {
					      label: "Rimuovi",
					      className: "btn-primaryColor",
					      callback: function() {
					        
					        li.fadeOut( function(){ li.remove() } );
					        
					      }
					    }
					  }
					});
					
				});
				
			}
			
			datepickerTool( 'it', 'dd/mm' );
			
			var done = function( response ){
					
				if ( !response.success ) {
					notifica( "Si è verificato un errore. Riprovare più tardi.", "danger" );
					return;
				}
				  
	            console.log( response.articoli );
		        
		        /*
				// init select 2
				$('#articolo').select2({
					
				    data: response.articoli,
				    // init selected from elements value
				    initSelection: function (element, callback) {
				      var initialData = [];
				      $(element.val().split(",")).each(function () {
				        initialData.push({
				          id  : this,
				          text: this
				        });
				      });
				      callback(initialData);
				    },
				
				    // configure as multiple select
				    multiple: false,
				
				    // query with pagination
				    query: function (q) {
				      var 	pageSize,
				        	results;
				      pageSize = 20; // or whatever pagesize
				      results  = [];
				      if (q.term && q.term !== "") {
				        results = $.grep(this.data, function (elemento) {
					        try{
						        var valido = elemento.toUpperCase().indexOf(q.term.toUpperCase()) >= 0;
						    }catch(e){
							    var valido = false;
						    }
						    console.log(valido);
				          return valido;
				        });
				      } else if (q.term === "") {
				        results = this.data;
				      }
				      q.callback({
				        results: results.slice((q.page - 1) * pageSize, q.page * pageSize),
				        more   : results.length >= q.page * pageSize
				      });
				    }
				    
				  });
				*/
				
			}
			
			eseguiAzione( 'listaArticoli', null, done );
			
			var inserisciValori = function(){
				
				//recupero gli elementi da inserire
				var valori = recuperaElementi( ['date','articolo','colore','book','cartella','quality','remark','remarkDate'] );
				
				var elementoInserito = $('#listaDisponibilita').children().last();
				
				elementoInserito.find('.date').html( valori['date'] );
				elementoInserito.find('.articolo').html( valori['articolo'] );
				elementoInserito.find('.colore').html( valori['colore'] );
				elementoInserito.find('.book').html( valori['book'] );
				elementoInserito.find('.cartella').html( valori['cartella'] );
				elementoInserito.find('.quality').html( valori['quality'] );
				
				var remark = elementoInserito.find('.remark');
				var valueRemark = valori['remark'];
				remark.addClass( valueRemark );
				
				valueRemark += (valori['remarkDate'] != '' && valueRemark == 'in production' ? ' ('+valori['remarkDate']+')' : '');
				remark.html( valueRemark );
				
				azioniDisponibilita();
				
			}
			
			campiMultipli( $('#aggiungiDisponibilita'), $('#creaElemento .template'), $('#listaDisponibilita'), inserisciValori );
			
			$('#listaDisponibilita').sortable();
			
			$('#generaPDF').click(function(e){
				
				e.preventDefault();
				
				$('.rimuoviDisponibilita').hide();
				 
				html2canvas( $('#listaContainer'), {
					onrendered: function(canvas) {
						var dataUrl = canvas.toDataURL("image/jpeg", 1.0);
						var pdf = new jsPDF();
						
						var numeroPagine = canvas.height / 1120;
						
						if ( numeroPagine < 1 )
							numeroPagine = 1
						else{
							numeroPagine = Math.round(numeroPagine+0.5);
						}
						
						for ( var i = 0; i < numeroPagine; i++ ) {
							if ( i != 0 ) {
								pdf.addPage();
							}
							pdf.addImage(dataUrl, 'JPEG', 0, -1120 * i );
						}
						
						pdf.save("catalogo_disponibilita.pdf");							
						
						
						/*
						doc.addImage(dataUrl,0,0,canvas.width,canvas.height);
						if(canvas.height > 365){ // I noticed 365 was the height of my page but for your landscape page it must be lower depending on your unit (pt, or mm or cm etc)
						  doc.addPage();
						  doc.addImage(dataUrl,0,-365,canvas.width,canvas.height);
						}
						*/
						
					}
				});
					
			});
			
			$('#collezione').change(function(){
				
				var collezione = $(this).val();
				
				var image = '';
				if ( collezione == 'albini' ) {
					image = 'banner_disponibilita.jpg';
				}else{
					image = 'header_disp_albini.jpg';
				}
				
				$('#bannerDisponbilita').attr( 'src', '../assets/img/'+image );
				
			});
			
			break;
		}
		
		case 'faq-list':{
		
			$('.eliminaFAQ').click(function(){
				
				var messaggio = '<strong class="colorPrimary">la FAQ</strong> verrà eliminata<br>Sicuro di voler continuare?';
				
				bootbox.dialog({
				  message: messaggio,
				  buttons: {
				    main: {
				      label: "Annulla",
				    },
				    danger: {
				      label: "Elimina FAQ",
				      className: "btn-primaryColor",
				      callback: function() {
				        
				      }
				    }
				  }
				});
				
			});
			
			$('tbody').sortable();
		
			break;
		}
		
		//************************************************************************************************
		//CLIENTE
		case 'cliente':{
			
			function azioniCliente(){

				var eliminaContatto = $('.eliminaContatto');
				eliminaContatto.unbind('click');
				eliminaContatto.click(function(){
					
					//recupero il parent
					var parent = $(this).parents('.contattoContainer');
					
					bootbox.confirm( "Sei sicuro di voler eliminare questo contatto?", function(conferma){
						
						if ( !conferma ) {
							return;	
						}else{
							parent.fadeOut( function(){ parent.remove() } );
						}
					
					});
					
				});
				
				var eliminaStrumento = $('.eliminaStrumento');
				eliminaStrumento.unbind('click');
				eliminaStrumento.click(function(){
					
					//recupero il parent
					var parent = $(this).parents('.strumentoContainer');
					
					bootbox.confirm( 'Sei sicuro di voler eliminare questo strumento?', function(conferma){
					
						if ( !conferma ) {
							return;	
						}else{
							parent.fadeOut( function(){ parent.remove() } );		
						}
					
					});
					
				});
				
				var eliminaScaglione = $('.eliminaScaglione');
				eliminaScaglione.unbind('click');
				eliminaScaglione.click(function(){
					
					//recupero il parent
					var parent = $(this).parents('.scaglione');
					
					bootbox.confirm( 'Sei sicuro di voler eliminare questo prezzo?', function(conferma){
					
						if ( !conferma ) {
							return;	
						}else{
							parent.fadeOut( function(){ parent.remove() } );	
						}
					
					});
					
				});
				
			}
			
			campiMultipli( $('#aggiungiContatto'), $('#contatti .template'), $('#contatti .values'), azioniCliente );
			campiMultipli( $('#aggiungiStrumento'), $('#strumenti .template'), $('#strumenti .values'), azioniCliente );
			campiMultipli( $('#aggiungiScaglionePrezzo'), $('#prezzi .template'), '#contenutiPrezzi', azioniCliente );
			
			//selectCitta( 'citta', 'citta', true, $('#contentCitta') );
			
			$('#citta').change(function(){
				cittaDinamiche( $(this).val(), $('#cap'), $('#provincia'), $('#regione'), $('#nazione') );
			});
			
			$('#inviaCliente').click(function(e){
				
				e.preventDefault()
				
				//recupero gli elementi easy del form
				var elementi = recuperaElementi([	
													'nominativo','ragioneSociale','partitaIVA','codiceFiscale','riferimentoBanca','modalitaPagamento','costoMetroQuadro','IDCollaboratore',
													'percentualeRicarico','indirizzo','citta','sosteOra','facchinaggio','orariTassativi','recapitoContrassegno','provvigioneServizioContrassegnoPercentuale','provvigioneServizioContrassegnoCifra'
												]);
				
				if ( elementi === false ) {
					scrollTo( $('#formCliente') );
					notifica( "I campi in rosso sono obbligatori", "warning" );
					return;
				}
				
				//se tutti i campi obbligatori sono stati inseriti proseguo con gli elementi tosti
				//contatti
				elementi['contatti'] = valoreCampiMultipliKeyValue( $('#contatti .values .contattoContainer'), '.campo', '.valore' );
				//strumenti
				elementi['strumenti'] = valoreCampiMultipli( $('#strumenti .values .strumentoContainer'), ['.campo','.valore'], ['strumento','cifra'] );
				//prezzi
				//recupero le tab
				elementi['prezzi'] = {};
				var tabPrezzi = $('#contenutiPrezzi .tab-pane');
				tabPrezzi.each(function(){
					//recupero l'id del pannello
					var idTab = $(this).attr('id');
					elementi['prezzi'][idTab] = valoreCampiMultipli( $(this).find('.scaglione'), ['.KG','.M3','.euro'], ['KG','M3','euro'] );
				});
				
				//per la provvigione devo creare un oggetino
				elementi['provvigioneServizioContrassegno'] = { 
																'percentuale': 	elementi['provvigioneServizioContrassegnoPercentuale'],
																'cifra': 		elementi['provvigioneServizioContrassegnoCifra']
															}
				
				//recupero l'id dal form
				elementi['id'] = $('#formCliente').attr('data-IDCliente') || 0;
				
				var done = function( response ){
					
					spinner().modal('hide');
						
					if ( !response.success ) {
						notifica( "Si è verificato un errore nel caricamento del cliente!", "danger" );
						return;
					}
					
					notifica( "Il cliente è stato correttamente caricato", "success" );
					
					$('#formCliente').attr( 'data-IDCliente', response.id );
					
				}
				
				spinner("Caricamento delle informazioni del cliente").modal('show');
				
				eseguiAzione( 'aggiornaCliente', elementi, done );
				
			});
			
			$('#tabellaPrezzi a').click(function (e) {
				e.preventDefault();
				$(this).tab('show');
			})
			
			azioniCliente();
			
			break;
		}
		
		case 'elenco_clienti':{
			
			function azioniElencoClienti(){
				
				var elimina = $('.eliminaCliente');
				elimina.unbind('click');
				elimina.click(function(){
					
					var row = $(this).parents('tr');
						
					bootbox.confirm('Sicuro di voler eliminare il cliente e tutte le informazioni correlate?<br>(es. prospetti, listini, prezzi)', function(conferma) {
						
						if ( !conferma ) {
							return;
						}else{
							
							var IDCliente = row.attr('data-id');
							
							var elementi = {
								'id': IDCliente
							}
							
							var done = function( response ){
								
								if ( !response.success ) {
									notifica( "Si è verificato un errore durante la cancellazione del cliente", 'danger' );
									return;
								}
								
								//rimuovo la row
								row.fadeOut( function(){ row.remove() } );
								
								//notifico
								notifica( "Il cliente è stato correttamente eliminato", "success" );
							
							}
							
							eseguiAzione( 'eliminaCliente', elementi, done );
							
						}
						
					});
					
				});
				
			}
			
			azioniElencoClienti();
			
			break;
		}
		
		case 'statistiche_cliente':{
			
			var annoStatistica = null;
			
			function statisticheCliente( anno ){
				
				var IDCliente = gup( 'id' );
				
				var elementi = {
					'IDCliente': IDCliente,
					'anno': anno
				}
				
				var done = function( response ){
						
					if ( !response.success ) {
						notifica( "Si è verificato un errore nella compilazione delle statistiche", "danger" );
						return;
					}
					
					annoStatistica = response.annoDiRiferimento;
					
					var anni = Object.keys( response.dati );
					var colonne = [];
					
					$(anni).each(function(){
						
						var anno = parseInt(this);
						
						if ( response.dati[anno] != 0 ) {
							
							var mesi = [];
							//scorro i mesi di quest'anno e ricavo il totale
							for ( i = 1; i < 12+1; i++ ) {
								var key = pad(i, 2);
								var value = response.dati[anno][key];
								if ( value === undefined ) {
									value = 0;
								}
								mesi.push( value );
							}
							
							var serie = {
								type: 'column',
								name: anno,
								data: mesi
							}
							
							colonne.push( serie );
							
						}
						
					});
					
					$('#chart').highcharts({
				        title: {
				            text: 'Statistiche '+response.ragioneSociale
				        },
				        xAxis: {
				            categories: ['gennaio','febbraio','marzo','aprile','maggio','giugno','luglio','agosto','settembre','ottobre','novembre','dicembre']
				        },
						yAxis: {
							title: {
								text: 'Fatturato'
							}
						},
				        labels: {
				        },
				        series: colonne/*[{
				            type: 'column',
				            name: '2014',
				            data: [3, 2, 1, 3, 4, 5, 6, 8, 2, 3, 5, 1]
				        }, {
				            type: 'column',
				            name: '2015',
				            data: [2, 3, 5, 7, 6, 5, 6, 8, 2, 3, 5, 100]
				        }, {
				            type: 'column',
				            name: '2016',
				            data: [4, 3, 3, 9, 1, 5, 6, 8, 2, 3, 5, 1]
				        }, {
				            type: 'spline',
				            name: 'Media',
				            data: [3, 2.67, 3, 6.33, 3.33, 5, 5, 5, 5, 5, 5, 30],
				            marker: {
				                lineWidth: 2,
				                lineColor: Highcharts.getOptions().colors[3],
				                fillColor: 'white'
				            }
				        }]*/
				    });
				    
				    $('#chart svg text').last().hide();
					
				}
				
				eseguiAzione( 'statisticheCliente', elementi, done );
				
			}
			
			statisticheCliente( annoStatistica );
			
			$('#anniIndietro').click(function(){
				annoStatistica--;
				statisticheCliente( annoStatistica );
			});
			
			$('#anniAvanti').click(function(){
				annoStatistica++;
				statisticheCliente( annoStatistica );
			});
			
			break;
		}
		
		case 'listino_cliente':{
			
			function azioniElencoProspetti(){
				
			}
			
			//modifica
			var modifica = $('.modificaProspetto');
			modifica.unbind('click');
			modifica.click(function(){
				
				var button = $(this);
				var row = button.parents('tr');
				
				//recupero l'id della row
				var IDProspetto = row.attr('data-id');
				
				window.location.href = 'prospetto.php?id='+IDProspetto;
				
			});
			
			//visualizza prospetto PDF
			var visualizzaProspetto = $('.visualizzaProspetto');
			visualizzaProspetto.unbind('click');
			visualizzaProspetto.click(function(){
				
				var button = $(this);
				var row = button.parents('tr');
				
				//recupero l'id della row
				var IDProspetto = row.attr('data-id');
				
			});
			
			//visualizza segnacolli PDF
			var rimuoviDalListino = $('.rimuoviDalListino');
			rimuoviDalListino.unbind('click');
			rimuoviDalListino.click(function(){
				
				var button = $(this);
				
				bootbox.confirm( 'Sei sicuro di voler rimuovere il prospetto dal listino del cliente?', function(conferma){
				
					if ( !conferma ) {
						return;	
					}else{
						
						var row = button.parents('tr');
				
						//recupero l'id della row
						var IDProspetto = row.attr('data-id');
						
						var elementi = {
							'IDProspetto': IDProspetto
						}
						
						var done = function( response ){
								
							if ( !response.success ) {
								notifica( "Si è verificato un errore nella rimozione del prospetto dal listino cliente", "danger" );
								return;
							}
							
							var row = button.parents('tr');
							
							tabellaProspetti.fnDeleteRow( row[0] );
							
							notifica( "Il prospetto è stato correttamente rimosso dal listino cliente", "success" );
							
						}
						
						eseguiAzione( 'rimuoviDalListino', elementi, done );
								
					}
				
				});
				
			});
			
			var elimina = $('.eliminaProspetto');
			elimina.unbind('click');
			elimina.click(function(){
				
				var button = $(this);
				
				bootbox.confirm( 'Sei sicuro di voler eliminare questo prospetto?', function(conferma){
				
					if ( !conferma ) {
						return;	
					}else{
						
						var row = button.parents('tr');
						
						//recupero l'id della row
						var IDProspetto = row.attr('data-id');
						
						var elementi = {
							'IDProspetto': IDProspetto
						}
												
						var done = function( response ){
							if ( !response.success ) {
								notifica( "Si è verificato un errore durante l'eliminazione del prospetto.", "danger" );
								return;
							}
							
							row.fadeOut(function(){
								row.remove();
							});
							
							notifica( "Il prospetto è stato corretamente eliminato", "success" );
							
						}
						
						eseguiAzione( 'eliminaProspetto', elementi, done );
								
					}
				
				});
				
			});
			
			azioniElencoProspetti();
			
			//miciomiao - dare un nome alla tabella dei prospetti altrimenti sbotta
			
			break;
		}
		
		//************************************************************************************************
		//FORNITORE
		case 'fornitore':{
			
			function azioniFornitore(){
				
				var eliminaContatto = $('.eliminaContatto');
				eliminaContatto.unbind('click');
				eliminaContatto.click(function(){
					
					//recupero il parent
					var parent = $(this).parents('.contattoContainer');
					
					bootbox.confirm( 'Sei sicuro di voler eliminare questo contatto?', function(conferma){
					
						if ( !conferma ) {
							return;	
						}else{
							parent.fadeOut( function(){ parent.remove() } );
						}
					
					});
					
				});
				
				var eliminaStrumento = $('.eliminaStrumento');
				eliminaStrumento.unbind('click');
				eliminaStrumento.click(function(){
					
					//recupero il parent
					var parent = $(this).parents('.strumentoContainer');
					
					bootbox.confirm( "Sei sicuro di voler eliminare questo strumento?", function(conferma){
					
						if ( !conferma ) {
							return;	
						}else{
							parent.fadeOut( function(){ parent.remove() } );
						}
					
					});
					
				});
				
				var eliminaScaglione = $('.eliminaScaglione');
				eliminaScaglione.unbind('click');
				eliminaScaglione.click(function(){
					
					//recupero il parent
					var parent = $(this).parents('.scaglione');
					
					bootbox.confirm( "Sei sicuro di voler eliminare questo prezzo?", function(conferma){
					
						if ( !conferma ) {
							return;	
						}else{
							parent.fadeOut( function(){ parent.remove() } );
						}
					
					});
					
				});
				
			}
			
			campiMultipli( $('#aggiungiContatto'), $('#contatti .template'), $('#contatti .values'), azioniFornitore );
			campiMultipli( $('#aggiungiStrumento'), $('#strumenti .template'), $('#strumenti .values'), azioniFornitore );
			campiMultipli( $('#aggiungiScaglionePrezzo'), $('#prezzi .template'), '#contenutiPrezzi .tab-pane.active', azioniFornitore );
			
			$('#citta').change(function(){
				cittaDinamiche( $(this).val(), $('#cap'), $('#provincia'), $('#regione'), $('#nazione') );
			});
			
			$('#inviaFornitore').click(function(e){
				
				e.preventDefault()
				
				//recupero gli elementi easy del form
				var elementi = recuperaElementi([	
													'nominativo','ragioneSociale','partitaIVA','codiceFiscale','riferimentoBanca','modalitaPagamento', 'indirizzo','citta','sosteOra','facchinaggio','fissoGiornaliero'
												]);
				
				if ( elementi === false ) {
					scrollTo( $('#formFornitore') );
					notifica( "I campi in rosso sono obbligatori", "warning" );
					return;
				}
				
				//se tutti i campi obbligatori sono stati inseriti proseguo con gli elementi tosti
				//contatti
				elementi['contatti'] = elementi['contatti'] = valoreCampiMultipliKeyValue( $('#contatti .values .contattoContainer'), '.campo', '.valore' );
				//strumenti
				elementi['strumenti'] = valoreCampiMultipli( $('#strumenti .values .strumentoContainer'), ['.campo','.valore'], ['strumento','cifra'] );
				
				//prezzi
				//recupero le tab
				elementi['prezzi'] = {};
				var tabPrezzi = $('#contenutiPrezzi .tab-pane');
				tabPrezzi.each(function(){
					
					//recupero l'id del pannello
					var idTab = $(this).attr('data-regione');
					var prezzi = valoreCampiMultipli( $(this).find('.scaglione'), ['.KG','.M3','.euro'], ['KG','M3','euro'] );

					if ( prezzi.length > 0 ) {
						elementi['prezzi'][idTab] = prezzi;					
					}
					
				});
				
				//recupero l'id dal form
				elementi['id'] = $('#formFornitore').attr('data-IDFornitore') || 0;
				
				var done = function( response ){
					
					spinner().modal('hide');
						
					if ( !response.success ) {
						notifica( "Si è verificato un errore nel caricamento del fornitore!", "danger" );
						return;
					}
					
					notifica( "Il fornitore è stato correttamente caricato", "success" );
					
					$('#formFornitore').attr( 'data-IDFornitore', response.id );
					
				}
				
				spinner("Caricamento dei dati del fornitore").modal('show');
				
				eseguiAzione( 'aggiornaFornitore', elementi, done );
				
			});
			
			$('#tabellaPrezzi a').click(function (e) {
				e.preventDefault();
				$(this).tab('show');
			})
			
			azioniFornitore();
			
			break;
		}
		
		case 'elenco_fornitori':{
			
			function azioniElencoFornitori(){
				
				var elimina = $('.eliminaFornitore');
				elimina.unbind('click');
				elimina.click(function(){
					
					var row = $(this).parents('tr');
					
					bootbox.confirm( 'Sicuro di voler eliminare il fornitore e tutte le informazioni correlate? (es. prospetti, listini, ordini, prezzi)', function(conferma){
					
						if ( !conferma ) {
							return;	
						}else{
							
							var IDFornitore = row.attr('data-id');
							
							var elementi = {
								'id': IDFornitore
							}
							
							var done = function( response ){
								
								if ( !response.success ) {
									notifica( "Si è verificato un errore durante la cancellazione del fornitore", 'danger' );
									return;
								}
								
								//rimuovo la row
								row.fadeOut( function(){ row.remove() } );
								
								//notifico
								notifica( "Il fornitore è stato correttamente eliminato", "success" );
							
							}
							
							eseguiAzione( 'eliminaFornitore', elementi, done );
							
						}
					
					});
					
				});
				
			}
			
			azioniElencoFornitori();
			
			break;
		}
		
		//************************************************************************************************
		//valido per tutti i tipi di proseptto
		case 'nuovo_prospetto':{
			
			$('#importaTrasporto').click(function(){
				
				alert('importa');
				
			});
		
			break;
		}
		
		case 'prospetto':{
			
			function azioniProspetti(){
				
				
				
			}
			
			$('#annoAlternativo').keyup(function(){
				var campoAlternativo = $(this);
				//quando inserisce un nuovo anno faccio una chiamata ajax per prendere il codice incrementale di quest'anno
				var annoInserito = campoAlternativo.val();
				
				if ( annoInserito.length == 4 || annoInserito.length == 0 ) {
					
					var elementi = {
						'anno': annoInserito
					}
					
					var done = function( response ){
						
						if ( !response.success ) {
							notifica( "Si è verificato un errore nel calcolo del codice prospetto!", 'danger' );
							return;
						}
						
						//se tutto va bene, cambio il valore nel prospetto
						$('#codice').val( response.codice );
					
					}
					
					eseguiAzione( 'codiceProspetto', elementi, done );
						
				}
				
			});
			
			$('#IDCliente').change(function(){
				$('#codiceCliente').val( $(this).val() );
			});
			
			function recuperaElementiProspettoZoccolo(){
				
				var vars = recuperaElementi( ['codice','data','IDCliente', 'numeroOrdine'], false );
				return vars;
				
			}
			
			//recupero la tipologia del trasporto per sapere quali azioni eseguire
			var elementi = {
				'IDProspetto': $('#formProspetto').attr('data-IDProspetto')
			}
									
			var done = function( response ){
				
				var tipoDaGET = gup('type');

				if ( response.success ) {
					if ( tipoDaGET == null && response.tipo == null ) {
						notifica( "Si è verificato un errore nel recupero del tipo di prospetto", "danger" );
						return;	
					}else{
						if ( tipoDaGET != null ) {
							response.tipo = tipoDaGET;
						}
					}
				}else{
					notifica( "Si è verificato un errore nel recupero del tipo di prospetto", "danger" );
				}
				
				//**************************************************************************************************
				//azioni divise per tipo di prospetto
				switch ( response.tipo ) {
					
					case 'trasporto':{
						
						//recupero i div dove carico i form
						var containerForm = $('#containerForm');
						//zoccolo comune a tutti i prospetti
						var zoccolo = $('#containerZoccolo');
						//salvo la tabella dei prospetti per quando dovrò aggiungere i prospetti
						var tabellaTrasporti = $('#tabellaTrasporti').dataTable({
					        "oLanguage":{
							    "sEmptyTable":     "Nessun dato presente nella tabella",
							    "sInfo":           "Vista da _START_ a _END_ di _TOTAL_ elementi",
							    "sInfoEmpty":      "Vista da 0 a 0 di 0 elementi",
							    "sInfoFiltered":   "(filtrati da _MAX_ elementi totali)",
							    "sInfoPostFix":    "",
							    "sInfoThousands":  ",",
							    "sLengthMenu":     "Visualizza _MENU_ elementi",
							    "sLoadingRecords": "Caricamento...",
							    "sProcessing":     "Elaborazione...",
							    "sSearch":         "Cerca:",
							    "sZeroRecords":    "La ricerca non ha portato alcun risultato.",
							    "oPaginate": {
							        "sFirst":      "Inizio",
							        "sPrevious":   "Precedente",
							        "sNext":       "Successivo",
							        "sLast":       "Fine"
							    }
							}
					    });
						
						//azioni comuni per la tabella
						function azioniTrasporto(){
							
							//modifica
							var modificaTrasporto = $('.modificaProspettoTrasporto');
							modificaTrasporto.unbind('click');
							modificaTrasporto.click(function(){
								
								var button = $(this);
								var row = button.parents('tr');
								
								$('.trasportoInModifica').removeClass('trasportoInModifica');
								row.addClass('trasportoInModifica');
								
								spinner("Caricamento del form di trasporto").modal('show');
								
								//posiziono a destra invisibile pronto ad entrare
								var posizione = posizionaContentForm();
								
								//carico il contenuto del form
								contenutoProspettoTrasporto( row.attr('data-id'), 0, function(){
									
									spinner().modal('hide');
									
									//una volta caricato il contenuto mostro il form
									containerForm.animate({
										'left': posizione.left,
										'opacity': 1
									}, function(){
										//finito di animare nascondo l'altro form e questo lo metto relative, così il footer non svalvola
										zoccolo.hide();
										containerForm.css({
											top: 0,
											left: 0,
											position: 'relative'
										});
									});
									
									//attivo i pulsanti e gli elementi
									azioniFormTrasporto();
									
								});
								
							});
							
							//elimina
							var eliminaTrasporto = $('.eliminaProspettoTrasporto');
							eliminaTrasporto.unbind('click');
							eliminaTrasporto.click(function(){
								
								var button = $(this);
								
								bootbox.confirm( 'Sei sicuro di voler eliminare questo trasporto?', function(conferma){
								
									if ( !conferma ) {
										return;	
									}else{
										
										var row = button.parents('tr');
										
										var elementi = {
											'IDTrasporto': row.attr('data-id')
										}
																
										var done = function( response ){
											if ( !response.success ) {
												notifica( "Si è verificato un errore durante l'eliminazione del trasporto", "danger" );
												return;
											}
											
											row.fadeOut(function(){
												row.remove();
											});
											
											notifica( "Il trasporto è stato correttamente eliminato", "success" );
										}
										
										eseguiAzione( 'eliminaTrasporto', elementi, done );
										
									}
								
								});
								
							});
							
						}
						
						//azioni per quando viene caricato il form del trasporto
						function azioniFormTrasporto(){
							
							//funzione per recuperare i dati del form per il salvataggio o gli aggiornamenti degli elementi (tipo i totali)
							function recuperaElementiProspettoTrasporto(){
								
								//recupero gli elementi easy
								var elementi = recuperaElementi( ['IDProspettoTrasporto','numeroImballaggi','bolla','descrizione','da','a','IDMezzo','imballo','numeroPolizza','totaleSpeseAccessorie','totaleProspetto','iva','totaleConIVA','prezzo','prezzoConcordato'] );
								
								//ci aggiungo gli altri elementi
								//ACCESSORI
								{
									//recupero i valori degli strumenti checkkati
									var strumenti = [];
									$('.strumento:checked').each(function(){
										strumenti.push( $(this).val() );
									});
									
									var facchinaggio = $('#facchinaggio').is(':checked');
									var orarioTassativo = $('#orarioTassativo').is(':checked');
									var sosteOra = $('#sosteOra').val();
									var servizioContrassegno = $('#servizioContrassegno').is(':checked');
									
									elementi['accessori'] = {
										'strumenti': strumenti,
										'facchinaggio': facchinaggio,
										'orarioTassativo': orarioTassativo,
										'sosteOra': sosteOra,
										'servizioContrassegno': servizioContrassegno
									}
								}
								
								//PESO - DIMENSIONI
								{
									//recupero semplicemente gli elementi
									var elementiDimensioni = recuperaElementi( ['peso','base','altezza','profondita', 'da'] );
									elementi['dimensioni'] = elementiDimensioni;
								}
								
								var assicurazione = $('#assicurazione').is(':checked');
								elementi['assicurazione'] = assicurazione;
								
								//recupero l'id de prospetto, lo zoccolo
								var IDProspetto = $('#formProspetto').attr('data-IDProspetto');
								elementi['IDProspetto'] = IDProspetto;
								
								//recupero le informazioni dello zoccolo
								elementi['zoccolo'] = recuperaElementiProspettoZoccolo();
								
								return elementi;
								
							}
							
							//funzione che imposta l'evento e le operazioni per aggiornare i totali
							function aggiornaTotali(){
								
								$('.strumento, #assicurazione, #facchinaggio, #a, #orarioTassativo, #sosteOra, #servizioContrassegno, #peso, #base, #altezza, #profondita, #prezzoConcordato, #iva').on('change keyup click',function(){
									
									/*
										
										ovvero:
											
											quando modifico una spesa accessoria, devo riprendere tutte le spese accessorie
											
											quando modifico peso o dimensioni, si modifica il prezzo
											quando modifico il prezzo concordato devo verificare quale tra i 2 sia maggiore e modificare il totale
												in ogni caso, qualunque modifica sui prezzi modifica il prezzo+iva
												
											quando modifico l'iva
											
									*/
									
									var elementi = recuperaElementiProspettoTrasporto()
									
									var done = function( response ){
										
										if ( !response.success ) {
											notifica( "Si è verificato un errore nel calcolo del prezzo totale", "danger" );
											return;
										}
										
										//se tutto va bene, aggiorno i campi dei prezzi
										//aggiorno le spese accessorie
										$('#totaleSpeseAccessorie').val( response.totaleSpeseAccessorie );
										//aggiorno il prezzo dato dalle dimensioni e dal peso
										$('#prezzo').val( response.totalePrezzoDimensioni );
										//aggiorno il totale prospetto
										$('#totaleProspetto').val( response.totaleProspetto + response.costoAssicurazione );
										//aggiorno il prospetto più iva
										$('#totaleConIVA').val( response.totaleProspettoConIVA );
										
										//Gli ID dei fornitori li JSONizzo e li metto come data-
										$('#elencoFornitoriDisponibili').attr( 'data-IDFornitori', JSON.stringify( response.IDFornitori ) );
										$('#elencoFornitoriDisponibili').attr( 'data-ragioniSociali', response.ragioniSociali );
										//attivo la scritta che avrà il popover
										if ( response.IDFornitori.length > 0 ) {
											$('#elencoFornitoriDisponibili').show();
										}else{
											$('#elencoFornitoriDisponibili').hide();
										}
										
									}
									
									eseguiAzione( 'calcolaTotaliProspettoTrasporto', elementi, done );
								
								});
								
							}
							
							//locazioni
							$('#da').change(function(){
								cittaDinamiche( $(this).val(), null, $('#provinciaDA'), null, null );
							});
							
							$('#a').change(function(){
								cittaDinamiche( $(this).val(), null, $('#provinciaA'), null, null );
							});
							
							$('#aggiornaProspetto').click(function(e){
								
								e.preventDefault();
								
								//recupero i dati
								var elementi = recuperaElementiProspettoTrasporto();
								
								var done = function( response ){
									
									if ( !response.success ) {
										notifica( "Si è verificato un errore nell'aggiornamento del prospetto", "danger" );
										return;
									}
									
									$('#IDProspettoTrasporto').val( response.IDProspettoTrasporto );
									$('#formProspetto').attr( 'data-IDProspetto', response.IDProspetto );
									
									notifica( "Il prospetto di trasporto è stato salvato correttamente", "success" );
									
									//se è un nuovo trasporto allora aggiungo la row
									if ( elementi['IDProspettoTrasporto'] == 0 ) {
										
										//aggiungo la row alla tabella principale
										var addIndex = tabellaTrasporti.fnAddData([
								            response.Da,
								            response.A,
								            response.speseAccessorie,
								            response.importo,
								            response.pulsantiAzioni
								        ]);
								        
								        var tr = $('#tabellaTrasporti tr td:last-child').filter(function(){
									        if ( !$(this).hasClass('azioniProspetto') ) return true;
									        return false;
								        }).parents('tr');
								        
								        //recupero la tr inserita per assegnarle dei valori
								        tr.attr( 'data-id', response.IDProspettoTrasporto );
								        tr.find('td').last().addClass('azioniProspetto');
											
									}else{
										
										//mi spiace non usare le funzioni di datatables, ma credo che mantenga gli indici nonostante l'ordinamento, e va a finire che non si capisce un cazzo
										//già trovare la documentazione è difficile, perché sul sito uffuciale c'è quella vecchia -.-" ..
										
										var rowDaModificare = $('#tabellaTrasporti tr.trasportoInModifica');
										var td = rowDaModificare.find('td');
										
										//altrimenti modifico quella già esistente
										$(td[0]).html( response.Da );
										$(td[1]).html( response.A );
										$(td[2]).html( response.speseAccessorie );
										$(td[3]).html( response.importo );
										
									}
									
									azioniTrasporto();
									
								}
								
								eseguiAzione( 'aggiornaProspettoTrasporto', elementi, done );
								
								
							});
							
							$('#annullaProspetto').click(function(e){
								
								e.preventDefault();
								
								//rendo visibile lo zoccolo
								zoccolo.show();
								
								//annulla il prospetto, animo l'uscita
								
								//riassegno l'absolute con la posizione attuale
								var top = zoccolo[0].offsetTop;
								var left = zoccolo[0].offsetLeft;
								var width = zoccolo.width();
								
								containerForm.css({
									'position': 'absolute',
									'top': top,
									'left': left
								});
								
								//animo la scomparsa del form
								containerForm.animate({
									'left': 0,
									'opacity': 0
								}, function(){
									containerForm.html('');
								});
								
							});
							
							//per abilitare la scritta sul prezzo
							$('#assicurazione').click(function(){
								
								$('#conAssicurazione').toggle();
								
							});
							
							//quando clicco sulla dicitura faccio apparire il popover con la lista dei fornitori disponibili
							$('#elencoFornitoriDisponibili').popover({
								'html' : true,
								'container' : 'body',
								'title': 'Fornitori disponibili',
								'trigger': 'focus',
								'content': function(){
									
									var ragioni = $(this).attr('data-ragioniSociali');
									ragioni = JSON.parse( ragioni );
									
									var stringa = '<ul class="list-group">';
									
									$(ragioni).each(function(){
										var ragione = String(this);
										stringa += '<li class="list-group-item">'+ragione+'</li>';
									});
									
									stringa += '</ul>';
									
									return stringa;
									
								}
							});
							
							$('#elencoFornitoriDisponibili').click(function(){
								$(this).popover('toggle');
							});
							
							/*
							$('#elencoFornitoriDisponibili').click(function(){
								
								//recupero gli id dei fornitori disponibili
								var rawData = $(this).attr('data-IDFornitori');
								var IDFornitori = JSON.parse( rawData );
								
								
								
							});
							*/
							
							//funzione che imposta l'evento e le operazioni per aggiornare i totali
							aggiornaTotali();
							
							//attivo i tools
							tools();
							
						}
						
						//funzione che carica il trasporto
						function contenutoProspettoTrasporto( IDProspetto, IDCliente, func ){
							
							//ora che ho impostato le dimensioni riempio il form
							var elementi = {
								'IDProspettoTrasporto': IDProspetto,
								'IDCliente': IDCliente
							}
							
							var done = function( response ){
								
								if ( !response.success ) {
									notifica( "Si è verificato un errore nel caricamento del prospetto", "danger" );
									return;
								}
								
								containerForm.html( response.form );
								
								func();
							
							}
							
							eseguiAzione( 'formProspettoTrasporto', elementi, done );
							
						}
						
						//funzione per posizionare il form che entrarà in dissolvenza
						function posizionaContentForm(){
							
							var top = zoccolo[0].offsetTop;
							var left = zoccolo[0].offsetLeft;
							var widthForm = zoccolo.width();
							
							var posizione = {
								'top': top,
								'left': left + widthForm,
								'width': widthForm,
								'position': 'absolute'
							};
							
							containerForm.css( posizione );
							
							
							return posizione;
							
						}
						
						//tasto per aggiungere un nuovo trasporto al prospetto
						$('#aggiungiTrasporto').click(function(){
							
							var IDCliente = $('#IDCliente').val();
							
							if ( IDCliente == 0 ) {
								notifica( "Prima di aggiungere un nuovo trasporto devi selezionare un cliente", "warning" );
								return;
							}
							
							spinner("Caricamento del di trasporto").modal('show');
							
							//posiziono a destra invisibile pronto ad entrare
							var posizione = posizionaContentForm();
							
							//carico il contenuto del form
							contenutoProspettoTrasporto( 0, IDCliente, function(){
								
								spinner().modal('hide');
								
								//una volta caricato il contenuto mostro il form
								containerForm.animate({
									'left': posizione.left,
									'opacity': 1
								}, function(){
									//finito di animare nascondo l'altro form e questo lo metto relative, così il footer non svalvola
									zoccolo.hide();
									containerForm.css({
										top: 0,
										left: 0,
										position: 'relative'
									});
								});
								
								//attivo i pulsanti e gli elementi
								azioniFormTrasporto();
								
							});
							
						});
						
						//tasto per salvare la parte dello zoccolo
						$('#inviaProspetto').click(function(e){
							
							e.preventDefault();
							
							var IDProspetto = $('#formProspetto').attr('data-IDProspetto');
							
							//in questo caso invio solo lo zoccolo
							var elementi = {
								'IDProspetto': IDProspetto,
								'zoccolo': recuperaElementiProspettoZoccolo()
							}
							
							var done = function( response ){
									
								if ( !response.success ) {
									notifica( "Si è verificato un errore durante l'aggiornamento del prospetto", "danger" );
									return;
								}
								
								$('#formProspetto').attr('data-IDProspetto', response.IDProspetto );
								notifica( "Il prospetto è stato correttamente salvato", "success" );
								
							}
							
							eseguiAzione( 'aggiornaZoccolo', elementi, done );
							
						})
						
						azioniTrasporto();
						
						break;
					}
					
					case 'magazzino':{
						
						function calcolaTotali(){
							
							//quando cambia uno di questi parametri cambiano i totali
							var elementi = {
								'metri': $('#metri').val(),
								'giorni': $('#giorni').val(),
								'iva': $('#iva').val(),
								'costoMetroQuadro': $('#costoMetroQuadro').val(),
								'prezzoConcordato': $('#prezzoConcordato').val()
							}
							
							var done = function( response ){
								
								if ( !response.success ) {
									notifica( "Si è verificato un errore nel calcolo dei totali", "danger" );
									return;
								}
								
								//se tutto va bene assegno i totali
								$('#totaleProspetto').val( response.totale );
								$('#totaleConIVA').val( response.totaleConIva );
								
							}
							
							eseguiAzione( 'calcolaTotaliProspettoMagazzino', elementi, done );
							
						}
						
						$('#IDCliente').change(function(){
							
							//quando cambia il cliente devo recuperare il costo al metro quadro che ho fatto a questo cliente
							var elementi = {
								'IDCliente': $(this).val()
							}
							
							var done = function( response ){
								
								if ( !response.success ) {
									notifica( "Si è verificato un errore nel recupero del costo al metro quadro", "danger" );
									return;
								}
								
								//se tutto va bene, imposto il valore all'input
								$('#costoMetroQuadro').val( response.costoMetroQuadro );
								calcolaTotali()
								
							}
							
							eseguiAzione( 'costoMetroQuadroCliente', elementi, done );
							
						});
						
						$('#metri, #giorni, #iva, #prezzoConcordato').on( 'change click keyup',function(){
							calcolaTotali()
						});
						
						$('#inviaProspetto').click(function(e){
							
							e.preventDefault();
							
							//sono tutti elementi easy, li recupero in un attimo
							var elementi = recuperaElementi( ['IDProspettoMagazzino','descrizione','metri','giorni','note','costoMetroQuadro','iva','totaleProspetto','prezzoConcordato'] );
							
							//recupero le informazioni dello zoccolo
							elementi['zoccolo'] = recuperaElementiProspettoZoccolo();
							
							//recupero l'id del prospetto
							var IDProspetto = $('#formProspetto').attr('data-IDProspetto');
							elementi['IDProspetto'] = IDProspetto;
							
							var done = function( response ){
								
								if ( !response.success ) {
									notifica( "Si è verificato un errore nell'aggiornamento del prospetto.", "danger" )
									return;
								}
								
								notifica( "Il prospetto è stato correttamente aggiornato", "success" );
								
								$('#formProspetto').attr('data-IDProspetto', response.IDProspetto );
								$('#IDProspettoMagazzino').val( response.IDProspettoMagazzino );
								
							}
							
							eseguiAzione( 'aggiornaProspettoMagazzino', elementi, done );
							
						});
						
						break;
					}
					
					case 'noleggio':{
						
						$('#prezzoConcordato, #prezzo, #IDMezzo, #km, #KMDiRientro, #giorni').on('change keyup',function(){
							
							var elementi = recuperaElementi([ 'prezzoConcordato', 'IDMezzo', 'km', 'KMDiRientro', 'giorni', 'prezzo' ]);
							elementi['KMIllimitati'] = $('#KMIllimitati').is(':checked');
							
							var done = function( response ){
									
								if ( !response.success ) {
									notifica( "Si è verificato un errore nel cacolo dei totali", "danger" );
									return;
								}
								
								$('#totaleProspetto').val( response.totale );
								$('#totaleConIVA').val( response.totaleConIva );
								$('#KMDisponibili').val( response.KMTotali );
								
								$('#costoFisso').val( response.costoFisso );
								$('#KMCostoFisso').val( response.KMCostoFisso );
								
							}
							
							eseguiAzione( 'totaliProspettoNoleggio', elementi, done );
							
						});
						
						//funzione per l'invio del prospetto
						$('#inviaProspetto').click(function(e){
							
							e.preventDefault()
							
							var elementi = recuperaElementi(['descrizione','IDMezzo','km','giorni','prezzo','prezzoConcordato','assicurazione','numeroPolizza','dichiarazioni','note','iva','totaleProspetto','IDProspettoNoleggio','KMDiRientro']);
							
							elementi['KMIllimitati'] = $('#KMIllimitati').is(':checked');
							
							if ( elementi['KMIllimitati'] && ( elementi['prezzoConcordato'] == '' || parseFloat(elementi['prezzoConcordato']) == 0 ) ) {
								notifica( "Se hai impostato il chilometraggio illimitato devi mettere un prezzo concordato", "danger" );
								return false;
							}
							
							//recupero le informazioni dello zoccolo
							elementi['zoccolo'] = recuperaElementiProspettoZoccolo();
							
							var IDProspetto = $('#formProspetto').attr('data-IDProspetto');
							elementi['IDProspetto'] = IDProspetto;
							
							var done = function( response ){
									
								if ( !response.success ) {
									notifica( "Si è verificato un errore nel salvataggio del prospetto", "danger" );
									return;
								}
								
								notifica( "Il prospetto è stato correttamente salvato", "success" );
								
								$('#formProspetto').attr( 'data-IDProspetto', response.IDProspetto );
								$('#IDProspettoNoleggio').val( response.IDProspettoNoleggio );
								
							}
							
							eseguiAzione( 'aggiornaProspettoNoleggio', elementi, done );
						
						});
						
						$('#KMIllimitati').click(function(){
							
							var check = $(this);
							
							if ( check.is(':checked') ) {
								notifica( "Ricorda di mettere il prezzo concordato", "warning" );
							}
							
						});
						
						break;
					}
					
				}
				//**************************************************************************************************
					
				}
			
			eseguiAzione( 'tipologiaProspetto', elementi, done );
			
			azioniProspetti();
			
			break;
		}
		
		case 'elenco_prospetti':{
			
			var IDClienteFattura = 0;
			
			function azioniElencoProspetti(){
				
			}
			
			//modifica
			var modifica = $('.modificaProspetto');
			modifica.unbind('click');
			modifica.click(function(){
				
				var button = $(this);
				var row = button.parents('tr');
				
				//recupero l'id della row
				var IDProspetto = row.attr('data-id');
				
				window.location.href = 'prospetto.php?id='+IDProspetto;
				
			});
			
			//visualizza prospetto PDF
			var visualizzaProspetto = $('.visualizzaProspetto');
			visualizzaProspetto.unbind('click');
			visualizzaProspetto.click(function(){
				
				var button = $(this);
				var row = button.parents('tr');
				
				//recupero l'id della row
				var IDProspetto = row.attr('data-id');
				
			});
			
			//visualizza segnacolli
			var visualizzaSegnacolli = $('.visualizzaSegnacolli');
			visualizzaSegnacolli.unbind('click');
			visualizzaSegnacolli.click(function(){
				
				var button = $(this);
				var row = button.parents('tr');
				
				//recupero l'id della row
				var IDProspetto = row.attr('data-id');
				
				//compilo le informazioni necessarie al segnacollo
				
				// ... miciomiao
				
				//mostro la finestra
				$('#finestraSegnacollo').modal('show');
				
			});
			
			//visualizza segnacolli PDF
			var inserisciNelListino = $('.inserisciNelListino');
			inserisciNelListino.unbind('click');
			inserisciNelListino.click(function(){
				
				var button = $(this);
				
				bootbox.confirm( 'Sei sicuro di voler spostare il prospetto nel listino cliente?', function(conferma){
				
					if ( !conferma ) {
						return;	
					}else{
						
						var row = button.parents('tr');
				
						//recupero l'id della row
						var IDProspetto = row.attr('data-id');
						
						var elementi = {
							'IDProspetto': IDProspetto
						}
						
						var done = function( response ){
								
							if ( !response.success ) {
								notifica( "Si è verificato un errore nell'inserimento del prospetto nel listino cliente", "danger" );
								return;
							}else if ( response.warning ) {
								notifica( "Per questo prospetto non è stato inserito alcun trasporto", "warning" );
								return;
							}
							
							var row = button.parents('tr');
							
							tabellaProspetti.fnDeleteRow( row[0] );
							
							notifica( "Il prospetto è stato correttamente inserito nel listino cliente", "success" );
							
						}
						
						eseguiAzione( 'inserisciInListino', elementi, done );
								
					}
				
				});
				
			});
			
			var elimina = $('.eliminaProspetto');
			elimina.unbind('click');
			elimina.click(function(){
				
				var button = $(this);
				
				bootbox.confirm( 'Sei sicuro di voler eliminare questo prospetto?', function(conferma){
				
					if ( !conferma ) {
						return;	
					}else{
						
						var row = button.parents('tr');
						
						//recupero l'id della row
						var IDProspetto = row.attr('data-id');
						
						var elementi = {
							'IDProspetto': IDProspetto
						}
												
						var done = function( response ){
							if ( !response.success ) {
								notifica( "Si è verificato un errore durante l'eliminazione del prospetto.", "danger" );
								return;
							}
							
							row.fadeOut(function(){
								row.remove();
							});
							
							notifica( "Il prospetto è stato corretamente eliminato", "success" );
							
						}
						
						eseguiAzione( 'eliminaProspetto', elementi, done );
								
					}
				
				});
				
			});
			
			//quando clicco sulla dicitura faccio apparire il popover con la lista dei fornitori disponibili
			$('#filtraTipologiaProspetto').popover({
				'html' : true,
				'container' : 'body',
				'trigger': 'focus',
				'content': function(){
					
					var stringa = '<div id="filtriElenco">';
					
					stringa += '<i class="fa fa-truck" data-filtro="trasporto"></i>';
					stringa += '<i class="fa fa-dropbox" data-filtro="magazzino"></i>';
					stringa += '<i class="fa fa-exchange" data-filtro="noleggio"></i>';
					stringa += '<i class="all" data-filtro=""><i class="fa fa-truck" data-filtro="trasporto"></i><i class="fa fa-dropbox" data-filtro="magazzino"></i><i class="fa fa-exchange" data-filtro="noleggio"></i></i>';
					
					stringa += '</div>'

					return stringa;
					
				}
			});
			
			$('#filtraTipologiaProspetto').click(function(){
				$(this).popover('toggle');
				$('#filtriElenco i').click(function(){
					var filtro = $(this).attr('data-filtro');
					tabellaProspetti.fnFilter( filtro, 4 );
				});
			});
			
			var tabellaProspetti = $('#tabellaProspetti').dataTable({
		        "oLanguage":{
				    "sEmptyTable":     "Nessun dato presente nella tabella",
				    "sInfo":           "Vista da _START_ a _END_ di _TOTAL_ elementi",
				    "sInfoEmpty":      "Vista da 0 a 0 di 0 elementi",
				    "sInfoFiltered":   "(filtrati da _MAX_ elementi totali)",
				    "sInfoPostFix":    "",
				    "sInfoThousands":  ",",
				    "sLengthMenu":     "Visualizza _MENU_ elementi",
				    "sLoadingRecords": "Caricamento...",
				    "sProcessing":     "Elaborazione...",
				    "sSearch":         "Cerca:",
				    "sZeroRecords":    "La ricerca non ha portato alcun risultato.",
				    "oPaginate": {
				        "sFirst":      "Inizio",
				        "sPrevious":   "Precedente",
				        "sNext":       "Successivo",
				        "sLast":       "Fine"
				    }
				},
		        "aoColumnDefs": [
					{ 'bSortable': false, 'aTargets': [ 4 ] },
					{ "sWidth": "180px", "aTargets": [ 4 ] }
				]
		    });
			
			$('.selezionaProspetto').click(function(){
				checkProspetti( $(this) );
			});
			
			function checkProspetti( checkCliccata ){
				
				var numeroCheck = $('.selezionaProspetto:checked').length;
				var IDClienteCliccato = checkCliccata.parents('tr').attr('data-IDCliente');
				
				//controllo per non farli selezionare clienti diversi
				if ( numeroCheck == 0 ) {
					IDClienteFattura = 0;
				}else if ( numeroCheck == 1 ) {
					IDClienteFattura = IDClienteCliccato;
				}else{
					//controllo che il cliente appena selezionato non sia diverso da quello già scelto
					if ( IDClienteFattura != IDClienteCliccato ) {
						//dececco la check appena ceccata (WTF???)
						checkCliccata.prop( 'checked', false );
						//notifico
						notifica( "Non puoi selezionare preventivi di clienti diversi", "warning" );
						return;
					}
				}
				
				var esistonoProspettiCheckkati = numeroCheck > 0;
				
				$('#generaFattura').prop( 'disabled', !esistonoProspettiCheckkati );
				
			}
			
			$('#generaFattura').click(function(){
				
				//recupero gli id dei prospetti da fatturare
				var IDProspetti = [];
				var IDCliente = 0;
				$('.selezionaProspetto:checked').each(function(){
					
					var tr = $(this).parents('tr');
					
					var IDProspetto = tr.attr('data-id');
					IDProspetti.push( IDProspetto );
					
					IDCliente = tr.attr('data-IDCliente');
					
				});
				
				//recupero i valori e creo la fattura in AJAX
				var elementi = {
					'IDProspetti': IDProspetti,
					'IDCliente': IDCliente
				}
				
				var done = function( response ){
						
					if ( !response.success ) {
						notifica( "Si è verificato un errore nella creazione della fattura", "danger" );
						return;
					}
					
					window.location.href = 'fattura.php?id='+response.IDFattura;
					
				}
				
				eseguiAzione( 'creaFattura', elementi, done );
				
			});
			
			azioniElencoProspetti();
			
			break;
		}
		
		//************************************************************************************************
		//BORDERÒ
		case 'bordero':{
			
			//tabelle
			$('#tabellaTratte, .tableTratta').each(function(){
				
				var tabella = $(this).dataTable({
		        "bPaginate": false,
		        "oLanguage":{
				    "sEmptyTable":     "Nessun dato presente nella tabella",
				    "sInfo":           "Vista da _START_ a _END_ di _TOTAL_ elementi",
				    "sInfoEmpty":      "Vista da 0 a 0 di 0 elementi",
				    "sInfoFiltered":   "(filtrati da _MAX_ elementi totali)",
				    "sInfoPostFix":    "",
				    "sInfoThousands":  ",",
				    "sLengthMenu":     "Visualizza _MENU_ elementi",
				    "sLoadingRecords": "Caricamento...",
				    "sProcessing":     "Elaborazione...",
				    "sSearch":         "Cerca:",
				    "sZeroRecords":    "La ricerca non ha portato alcun risultato.",
				    "oPaginate": {
				        "sFirst":      "Inizio",
				        "sPrevious":   "Precedente",
				        "sNext":       "Successivo",
				        "sLast":       "Fine"
				    }
				}
		    });	
				tabelle.push( tabella );
				
			});
			
		    var tabellaTratte = $('#tabellaTratte').parents('.dataTables_wrapper');
			var tabellaAperta = null;
			var tornaAlleTratte = $('#tornaAlleTratte');
			var buttonBordero = $('#generaBordero');
		    
		    $('.tableTratta').parents('.dataTables_wrapper').hide();
		    
		    //azione per visualizzare una tratta specifica
		    $('.dettaglioTratta').click(function(){
			    
			    //recupero l'id della tratta
			    var IDTratta = $(this).attr('data-id');
			    
			    tabellaTratte.hide();
			    
			    tornaAlleTratte.show();
			    
			    tabellaAperta = $('#'+IDTratta).parents('.dataTables_wrapper');
			    tabellaAperta.show();
			    
		    });
		    
		    //pulsante per tornare alla lista delle tratte
		    tornaAlleTratte.click(function(){
			    
			    tornaAlleTratte.hide();
			    tabellaAperta.hide();
			    tabellaTratte.show();
			    
		    });
		    
		    //funzione per selezionare tutti i trasporti di questa tratta
		    $('.selezionaTratta').click(function(){
			    
			    var check = $(this);
			    var row = check.parents('tr');
			    
			    //recupero l'id della tratta
			    var IDTratta = row.attr('data-tratta');
			    
			    //recupero la tabella su cui agire
			    var tabellaTrasporti = $('#tratta'+IDTratta);
			    //recupero le check su cui agire
			    var checkTrasporti = tabellaTrasporti.find('.selezionaTrattaSingola');
			    
			    //se questo è checked, recupero i checkbox di questa tratta e li cecco tutti, altrimenti li dececco
			    var toCheck = check.is(':checked');
			    checkTrasporti.prop( 'checked', toCheck );
			    
			    controllaCheck();
			    
		    });
		    
		    $('.selezionaTrattaSingola').click(function(){
			    controllaCheck();
		    });
		    
		    //funzione che controlla se ci sono check attive. nel caso, attiva il tasto dei borderò
		    //controlla anche se ci sono check per ogni tratta, così aggiunge o toglie la classe selected
		    function controllaCheck(){
			    
			    //button borderò
			    var visibile = !$('.selezionaTrattaSingola:checked').length > 0;
			    buttonBordero.prop( 'disabled', visibile );
			    
			    //selected
			    //per ogni tratta
			    $('#tabellaTratte tr').each(function(){
				    
				    //tr padre
				    var row = $(this);
				    var checkPadre = row.find('.selezionaTratta');
				    
				    //per ogni tr, recupero l'id e controllo se ci sono check sotto di me
				    var IDTratta = row.attr('data-tratta');
				    
				    //tabella sotto di me
				    var tabellaTrasporti = $('#tratta'+IDTratta);
				    
				    //controllo se ci sono row checckate
				    var numeroCheck = tabellaTrasporti.find('.selezionaTrattaSingola:checked').length;
				    var totaleTrasporti = tabellaTrasporti.find('.selezionaTrattaSingola').length;
				    
				    //se le check sono uguali, la check padre deve avere il check
				    if ( numeroCheck == 0 || numeroCheck < totaleTrasporti ) {
					    checkPadre.prop('checked', false);
				    }else if ( numeroCheck == totaleTrasporti ) {
					    checkPadre.prop('checked', true);
				    }
				    
				    var ciSonoCheck = numeroCheck > 0;
				    
				    //se ci sono check allora devo aggiungere la classe selected
				    if ( ciSonoCheck ) {
					    row.addClass('selected');
				    }else{
					    row.removeClass('selected');
				    }
				    
				    //controllo anche se ci sono row sotto di me, se non ci sono allora rimuovo proprio la check
				    if ( tabellaTrasporti.find('.rowTrasporto').length == 0 ) {
					    checkPadre.remove();
					    row.find('.dettaglioTratta').remove();
				    }
				    
			    });
			    
			    //per ogni trasporto
			    $('.selezionaTrattaSingola').each(function(){
				    
				    var check = $(this);
				    var row = check.parents('tr');
				    
				    if ( check.is(':checked') ) {
					    row.addClass('selected');
				    }else{
					    row.removeClass('selected');
				    }
				    
			    });
			    
			    var modalitaPrezzo_concordato = $('#modalitaPrezzo_concordato').parents('label');
			    modalitaPrezzo_concordato.unbind('click');
			    modalitaPrezzo_concordato.click(function(){
				    
				    setTimeout(function(){
					    $('.bootbox-input-text').addClass('inputDecimal');
					    inputDecimal();
				    }, 1000);
				    
				    bootbox.prompt("Inserisci il prezzo concordato", function(result) {                
						
						if (result === null) {
							return;
						}
						
						$('#prezzoConcordato').val( result );
						
						$('#valorePrezzoConcordato').html( result );
						
					});
					
			    });
			    
			    var modalitaPrezzo_giornata = $('#modalitaPrezzo_giornata').parents('label');
			    modalitaPrezzo_giornata.unbind('click');
			    modalitaPrezzo_giornata.click(function(){
					
				});
				
				var IDFornitore = $('#IDFornitore');
				IDFornitore.unbind('change');
				IDFornitore.change(function(){
					
					var IDFornitore = $(this).val();
					
					if ( IDFornitore == 0 ) return;
					
					//chiamatina rapida rapida per sapere il prezzo a giornata di questo fornitore
					var elementi = {
						'IDFornitore': IDFornitore
					}
					
					var done = function( response ){
							
						if ( !response.success ) {
							notifica( "Si è verificato un errore nel recuperare il prezzo a giornata del fornitore", "danger" );
							return;
						}
						
						$('#valorePrezzoGiornata').html( response.prezzoGiornata );
						
					}
					
					eseguiAzione( 'prezzoGiornataFornitore', elementi, done );
					
				});
			    
		    }
		    
		    //funzione per il form modale il borderò
		    buttonBordero.click(function(){
			    
			    //apro la finestra modale per richiedere il fornitore e se vuole il prezzo concordato o a pagamento
			    //impostazione per la finestra modale			
				$('#generaBorderoForm').modal({
					backdrop: 'static',
					keyboard: false
				});
				
		    });
		    
		    //funzione per la chiamata che genera il borderò
		    $('#confermaBordero').click(function(){
			    
			    $('#generaBorderoForm').modal('hide');
			    
			    //spinner("Sto creando il borderò ...").modal('show');
			    
			    //recupero i trasporti selezionati
			    var idTrasporti = trasportiSelezionati();
			    
			    //recupero il fornitore
			    var IDFornitore = $('#IDFornitore').val();
			    
			    //recupero la modalità di pagamento
			    var modalita = $('.modalitaPrezzo:checked').val();
			    
			    var elementi = {
			    	'IDBordero': 0,
			    	'IDTrasporti': idTrasporti,
			    	'IDFornitore': IDFornitore,
			    	'modalita': modalita,
			    	'prezzoGiornata': $('#valorePrezzoGiornata').html(),
			    	'prezzoConcordato': $('#valorePrezzoConcordato').html()
			    }
			    						
			    var done = function( response ){
			    	
			    	//spinner().modal( 'hide' );
			    	
			    	if ( !response.success ) {
			    		notifica( "Si è verificato un errore durante il salvataggio del borderò", "danger" );
			    		return;	
			    	}
			    	
			    	notifica( "Il borderò è stato correttamente salvato", "success" );
			    	
			    	//elimino le row che non servono più nelle tabelle dei trasporti
			    	//prima però le scorro e sottraggo i valori al totale nella tabella principale
			    	$('tr.rowTrasporto.selected').each(function(){
				    	
				    	var tr = $(this);
				    	var td = tr.find('td');
				    	
				    	//recupero i valori peso - volume
				    	var peso = parseFloat( td.filter('.TDPeso').html() );
				    	var volume = parseFloat( td.filter('.TDVolume').html() );
				    	
				    	//recupero il data-tratta della tabella così da recuperare la row nella tabella principale
				    	var IDTratta = tr.parents('table').attr('data-tratta');
				    	
				    	//recupero la row principale
				    	var TRPadre = $('#tabellaTratte tr[data-tratta='+IDTratta+']');
				    	
				    	//recupero i valori che ci sono adesso nella tabella principale
				    	var TDPeso = TRPadre.find('.TDPPeso');
				    	var TDVolume = TRPadre.find('.TDPVolume');
				    	var TDConsegne = TRPadre.find('.TDPConsegne');
				    	
				    	var pesoAttuale = parseFloat( TDPeso.html() );
				    	var volumeAttuale = parseFloat( TDVolume.html() );
				    	var consegneAttuali = parseFloat( TDConsegne.html() );
				    	
				    	TDPeso.html( pesoAttuale - peso );
				    	TDVolume.html( volumeAttuale - volume );
				    	TDConsegne.html( consegneAttuali - 1 );
				    	
				    	tr.remove();
				    	
			    	});
			    	
			    	//rimuovo la calsse selected e rimuovo la spunta dalle checkbox
			    	$('tr.selected').removeClass('selected');
			    	$('input[type="checkbox"]').prop( 'checked', false );
			    	
			    	controllaCheck();
			    	
			    }
			    
			    eseguiAzione( 'aggiornaBordero', elementi, done );
			    
		    });
		    
		    function trasportiSelezionati(){
			    
			    var idTrasporti = [];
			    
			    //recupero tutti gli id di ciò che è checckato
			    $('.selezionaTrattaSingola:checked').each(function(){
				    
				    var check = $(this);
					var row = check.parents('tr');
				    
					//recupero l'id del trasporto
					var idTrasporto = row.attr('data-trasporto');
				    
					idTrasporti.push( idTrasporto );				    
				    
			    });
			    
			    return idTrasporti;
			    
		    }
		    
			break;
		}
		
		//************************************************************************************************
		//MEZZI
		case 'mezzo':{
			
			function azioniMezzo(){
				
				var eliminaScaglione = $('.eliminaScaglione');
				eliminaScaglione.unbind('click');
				eliminaScaglione.click(function(){
					
					//recupero il parent
					var parent = $(this).parents('.scaglione');
					
					bootbox.confirm( 'Sei sicuro di voler eliminare questo prezzo?', function(conferma){
					
						if ( !conferma ) {
							return;	
						}else{
							parent.fadeOut( function(){ parent.remove() } );	
						}
					
					});
					
				});
				
			}
			
			campiMultipli( $('#aggiungiScaglionePrezzo'), $('#prezzi .template'), '#contenutiPrezzi', azioniMezzo );
			
			$('#inviaMezzo').click(function(e){
				
				e.preventDefault()
				
				//recupero gli elementi easy del form
				//KMCostoFisso per il futuro...
				var elementi = recuperaElementi(['costoAssicurazione','costoBollo','costoFisso','dataAssicurazione','dataBollo','nome','targa','tipologia','costoKM','KMCostoFisso']);
				
				if ( elementi === false ) {
					scrollTo( $('#formMezzo') );
					notifica( "I campi in rosso sono obbligatori", "warning" );
					return;
				}
				
				//recupero l'id dal form
				elementi['id'] = $('#formMezzo').attr('data-IDMezzo') || 0;
				
				//recupero i prezzi
				elementi['prezzi'] = valoreCampiMultipli( $('#contenutiPrezzi .scaglione'), ['.KM','.euro'], ['KM','euro'] );
				
				var done = function( response ){
					
					spinner().modal('hide');
						
					if ( !response.success ) {
						notifica( "Si è verificato un errore nel caricamento del mezzo!", "danger" );
						return;
					}
					
					notifica( "Il mezzo è stato correttamente caricato", "success" );
					
					$('#formMezzo').attr( 'data-IDMezzo', response.id );
					
				}
				
				spinner("Caricamento delle informazioni del mezzo").modal('show');
				
				eseguiAzione( 'aggiornaMezzo', elementi, done );
				
			});
			
			azioniMezzo();
			
			break;
		}
		
		case 'elenco_mezzi':{
			
			function azioniElencoMezzi(){
				
				var elimina = $('.eliminaMezzo');
				elimina.unbind('click');
				elimina.click(function(){
					
					var row = $(this).parents('tr');
						
					bootbox.confirm('Sicuro di voler eliminare il mezzo?', function(conferma) {
						
						if ( !conferma ) {
							return;
						}else{
							
							var IDMezzo = row.attr('data-id');
							
							var elementi = {
								'id': IDMezzo
							}
							
							var done = function( response ){
								
								if ( !response.success ) {
									notifica( "Si è verificato un errore durante la cancellazione del mezzo", 'danger' );
									return;
								}
								
								//rimuovo la row
								row.fadeOut( function(){ row.remove() } );
								
								//notifico
								notifica( "Il mezzo è stato correttamente eliminato", "success" );
							
							}
							
							eseguiAzione( 'eliminaMezzo', elementi, done );
							
						}
						
					});
					
				});
				
			}
			
			azioniElencoMezzi();
			
			break;
		}
		
		//************************************************************************************************
		//TRATTE
		case 'tratte':{

			function resettaCittaSelezionate(){
				
				var selettori = ['#addCitta','#addCittaNuovaTratta'];
				
				$(selettori).each(function(){
					var selettore = $(String(this));
					selettore.val('');
					selettore.select2()
				});
				
			}
			
			//tabelle
			$('#tabellaTratte').each(function(){
				
				var tabella = $(this).dataTable({
			        "bPaginate": false,
			        "oLanguage":{
					    "sEmptyTable":     "Nessun dato presente nella tabella",
					    "sInfo":           "Vista da _START_ a _END_ di _TOTAL_ elementi",
					    "sInfoEmpty":      "Vista da 0 a 0 di 0 elementi",
					    "sInfoFiltered":   "(filtrati da _MAX_ elementi totali)",
					    "sInfoPostFix":    "",
					    "sInfoThousands":  ",",
					    "sLengthMenu":     "Visualizza _MENU_ elementi",
					    "sLoadingRecords": "Caricamento...",
					    "sProcessing":     "Elaborazione...",
					    "sSearch":         "Cerca:",
					    "sZeroRecords":    "La ricerca non ha portato alcun risultato.",
					    "oPaginate": {
					        "sFirst":      "Inizio",
					        "sPrevious":   "Precedente",
					        "sNext":       "Successivo",
					        "sLast":       "Fine"
					    }
					}
			    });	
			    
				tabelle.push( tabella );
				
			});
			$('.tableTratta').each(function(){
				
				var tabella = $(this).dataTable({
			        "oLanguage":{
					    "sEmptyTable":     "Nessun dato presente nella tabella",
					    "sInfo":           "Vista da _START_ a _END_ di _TOTAL_ elementi",
					    "sInfoEmpty":      "Vista da 0 a 0 di 0 elementi",
					    "sInfoFiltered":   "(filtrati da _MAX_ elementi totali)",
					    "sInfoPostFix":    "",
					    "sInfoThousands":  ",",
					    "sLengthMenu":     "Visualizza _MENU_ elementi",
					    "sLoadingRecords": "Caricamento...",
					    "sProcessing":     "Elaborazione...",
					    "sSearch":         "Cerca:",
					    "sZeroRecords":    "La ricerca non ha portato alcun risultato.",
					    "oPaginate": {
					        "sFirst":      "Inizio",
					        "sPrevious":   "Precedente",
					        "sNext":       "Successivo",
					        "sLast":       "Fine"
					    }
					}
			    });	
			    
				tabelle.push( tabella );
				
			});
			
		    var tabellaTratte = $('#tabellaTratte').parents('.dataTables_wrapper');
			var tabellaAperta = null;
			var tornaAlleTratte = $('#tornaAlleTratte');
			var formAggiungiCitta = $('#formAggiungiCitta');
		    
		    $('.tableTratta').parents('.dataTables_wrapper').hide();
		    
		    //azione per visualizzare una tratta specifica
		    $('.dettaglioTratta').click(function(){
			    
			    //recupero l'id della tratta
			    var IDTratta = $(this).attr('data-id');
			    
			    tabellaTratte.hide();
			    $('#creaNuovaTratta').hide();
			    
			    tornaAlleTratte.show();
			    formAggiungiCitta.show();
			    
			    tabellaAperta = $('#'+IDTratta).parents('.dataTables_wrapper');
			    tabellaAperta.show();
			    
		    });
		    
		    //pulsante per tornare alla lista delle tratte
		    tornaAlleTratte.click(function(){
			    
			    tornaAlleTratte.hide();
			    formAggiungiCitta.hide();
			    tabellaAperta.hide();
			    tabellaTratte.show();
			    $('#creaNuovaTratta').show();
			    
			    resettaCittaSelezionate();
			    
		    });
		    
		    //funzione per selezionare tutti i trasporti di questa tratta
		    $('.selezionaTratta').click(function(){
			    
			    var check = $(this);
			    var row = check.parents('tr');
			    
			    //recupero l'id della tratta
			    var IDTratta = row.attr('data-tratta');
			    
			    //recupero la tabella su cui agire
			    var tabellaTrasporti = $('#tratta'+IDTratta);
			    //recupero le check su cui agire
			    var checkTrasporti = tabellaTrasporti.find('.selezionaTrattaSingola');
			    
			    //se questo è checked, recupero i checkbox di questa tratta e li cecco tutti, altrimenti li dececco
			    var toCheck = check.is(':checked');
			    checkTrasporti.prop( 'checked', toCheck );
			    
			    controllaCheckTratte();
			    
		    });
		    
		    $('.selezionaTrattaSingola').click(function(){
			    controllaCheckTratte();
		    });
		    
		    //funzione che controlla se ci sono check attive. nel caso, attiva il tasto dei borderò
		    //controlla anche se ci sono check per ogni tratta, così aggiunge o toglie la classe selected
		    function controllaCheckTratte(){
			    
			    //button borderò
			    var visibile = !$('.selezionaTrattaSingola:checked').length > 0;
			    
			    //selected
			    //per ogni tratta
			    $('#tabellaTratte tr').each(function(){
				    
				    //tr padre
				    var row = $(this);
				    var checkPadre = row.find('.selezionaTratta');
				    
				    //per ogni tr, recupero l'id e controllo se ci sono check sotto di me
				    var IDTratta = row.attr('data-tratta');
				    
				    //tabella sotto di me
				    var tabellaTrasporti = $('#tratta'+IDTratta);
				    
				    //controllo se ci sono row checckate
				    var numeroCheck = tabellaTrasporti.find('.selezionaTrattaSingola:checked').length;
				    var totaleTrasporti = tabellaTrasporti.find('.selezionaTrattaSingola').length;
				    
				    //se le check sono uguali, la check padre deve avere il check
				    if ( numeroCheck == 0 || numeroCheck < totaleTrasporti ) {
					    checkPadre.prop('checked', false);
				    }else if ( numeroCheck == totaleTrasporti ) {
					    checkPadre.prop('checked', true);
				    }
				    
				    var ciSonoCheck = numeroCheck > 0;
				    
				    //se ci sono check allora devo aggiungere la classe selected
				    if ( ciSonoCheck ) {
					    row.addClass('selected');
				    }else{
					    row.removeClass('selected');
				    }
				    
				    //controllo anche se ci sono row sotto di me, se non ci sono allora rimuovo proprio la check
				    if ( tabellaTrasporti.find('.rowTrasporto').length == 0 ) {
					    checkPadre.remove();
					    row.find('.dettaglioTratta').remove();
				    }
				    
			    });
			    
			    //per ogni trasporto
			    $('.selezionaTrattaSingola').each(function(){
				    
				    var check = $(this);
				    var row = check.parents('tr');
				    
				    if ( check.is(':checked') ) {
					    row.addClass('selected');
				    }else{
					    row.removeClass('selected');
				    }
				    
			    });
			    
			    var modalitaPrezzo_concordato = $('#modalitaPrezzo_concordato').parents('label');
			    modalitaPrezzo_concordato.unbind('click');
			    modalitaPrezzo_concordato.click(function(){
				    
				    setTimeout(function(){
					    $('.bootbox-input-text').addClass('inputDecimal');
					    inputDecimal();
				    }, 1000);
				    
				    bootbox.prompt("Inserisci il prezzo concordato", function(result) {                
						
						if (result === null) {
							return;
						}
						
						$('#prezzoConcordato').val( result );
						
						$('#valorePrezzoConcordato').html( result );
						
					});
					
			    });
			    
			    var modalitaPrezzo_giornata = $('#modalitaPrezzo_giornata').parents('label');
			    modalitaPrezzo_giornata.unbind('click');
			    modalitaPrezzo_giornata.click(function(){
					
				});
				
				var IDFornitore = $('#IDFornitore');
				IDFornitore.unbind('change');
				IDFornitore.change(function(){
					
					var IDFornitore = $(this).val();
					
					if ( IDFornitore == 0 ) return;
					
					//chiamatina rapida rapida per sapere il prezzo a giornata di questo fornitore
					var elementi = {
						'IDFornitore': IDFornitore
					}
					
					var done = function( response ){
							
						if ( !response.success ) {
							notifica( "Si è verificato un errore nel recuperare il prezzo a giornata del fornitore", "danger" );
							return;
						}
						
						$('#valorePrezzoGiornata').html( response.prezzoGiornata );
						
					}
					
					eseguiAzione( 'prezzoGiornataFornitore', elementi, done );
					
				});
			    
		    }
		    
		    function cittaSelezionate(){
			    
			    var idCittas = [];
			    
			    //recupero tutti gli id di ciò che è checckato
			    $('.selezionaCitta:checked').each(function(){
				    
				    var check = $(this);
					var row = check.parents('tr');
				    
					//recupero l'id del trasporto
					var idCitta = row.attr('data-citta');
				    
					idCittas.push( idCitta );				    
				    
			    });
			    
			    return idCittas;
			    
		    }
		    
		    $('#inserisciCitta').click(function(){
			    
			    bootbox.confirm( "Sei sicuro di voler inserire le città in questa tratta?<br>Se le città sono assegnate ad un'altra tratta, verranno riassegnate a questa.", function(conferma){
						
					if ( !conferma ) {
						return;	
					}else{
						//recupero i valori delle citta
						var IDCitta = $('#addCitta').val();
						
						var tabellaTratta = $('.dataTables_wrapper:visible').find('table');
						
						if ( IDCitta == null ) {
							notifica( "Seleziona almeno una città", "warning" );
							return;
						}
						
						//recupero la tratta selezionata
						var IDTratta = tabellaTratta.attr('data-tratta');
						
						var elementi = {
							'IDCitta': IDCitta,
							'IDTratta': IDTratta
						}
						
						var done = function( response ){
								
							if ( !response.success ) {
								notifica( "Si è verificato un errore nell'assegnamento delle citta a questa tratta", "danger" );
								return;
							}
							
							notifica( "Le città sono state correttamente assegnate a questa tratta", "success" );
							resettaCittaSelezionate();
							
							//aggiungo la nuova città alla tabella
							$(response.citta).each(function(){
								
								var cittaSingola = String( this );
								
								tabelle[response.IDTratta].fnAddData([cittaSingola])
									
							});
							
							//aggiorno i totali delle citta
							$(response.tratte).each(function(){
								
								var info = this;
								
								$('#tabellaTratte').find('tr[data-tratta="'+info.tratta+'"] td.TDNumeroCitta').html( info.totale );
								
							});
							
						}
						
						eseguiAzione( 'aggiungiCittaAllaTratta', elementi, done );
						
					}
				
				});
			    
		    });
		    
		    //Funzione per inserire una nuova tratta .. apro il form in modale e gli faccio inserire almeno una città per crearla
		    $('#creaNuovaTratta').click(function(e){
		    	
		    	e.preventDefault()
		    	
		    	//apro il form
		    	$('#formCreazioneTratta').modal('show');
		    
		    });
		    
		    //funzione per creare definitivamente una nuova tratta - recupero il numero della tratta e le città che vuole inserire
		    $('#creaTratta').click(function(e){
		    	
		    	e.preventDefault()
		    	
		    	bootbox.confirm( "Sei sicuro di voler inserire le città in questa nuova tratta?<br>Se le città sono assegnate ad un'altra tratta, verranno riassegnate a questa.", function(conferma){
						
					if ( !conferma ) {
						return;	
					}else{
						//recupero i valori delle citta
						var IDCitta = $('#addCittaNuovaTratta').val();
						
						if ( IDCitta == null ) {
							notifica( "Seleziona almeno una città", "warning" );
							return;
						}
						
						//recupero la tratta selezionata
						var IDTratta = $('#numeroNuovaTratta').val();
						
						var elementi = {
							'IDCitta': IDCitta,
							'IDTratta': IDTratta
						}
						
						var done = function( response ){
								
							if ( !response.success ) {
								notifica( "Si è verificato un errore nella creazione di una nuova tratta", "danger" );
								return;
							}
							
							$('#formCreazioneTratta').modal('hide');
							notifica( "La tratta è stata creata ", "success" );
							resettaCittaSelezionate();
							
						}
						
						eseguiAzione( 'aggiungiCittaAllaTratta', elementi, done );
						
					}
				
				});
		    
		    });
		    
			break;
		}
		
		//************************************************************************************************
		//COLLABORATORI
		case 'collaboratore':{
			
			function azioniCollaboratore(){

				var eliminaContatto = $('.eliminaContatto');
				eliminaContatto.unbind('click');
				eliminaContatto.click(function(){
					
					//recupero il parent
					var parent = $(this).parents('.contattoContainer');
					
					bootbox.confirm( "Sei sicuro di voler eliminare questo contatto?", function(conferma){
						
						if ( !conferma ) {
							return;	
						}else{
							parent.fadeOut( function(){ parent.remove() } );
						}
					
					});
					
				});
				
			}
			
			campiMultipli( $('#aggiungiContatto'), $('#contatti .template'), $('#contatti .values'), azioniCollaboratore );
			
			$('#inviaCollaboratore').click(function(e){
				
				e.preventDefault()
				
				//recupero gli elementi easy del form
				var elementi = recuperaElementi(['nominativo','impiego','costoOrario','percentualeProvvigione']);
				
				if ( elementi === false ) {
					scrollTo( $('#formCollaboratore') );
					notifica( "I campi in rosso sono obbligatori", "warning" );
					return;
				}
				
				//se tutti i campi obbligatori sono stati inseriti proseguo con gli elementi tosti
				//contatti
				elementi['contatti'] = valoreCampiMultipliKeyValue( $('#contatti .values .contattoContainer'), '.campo', '.valore' );
				
				//recupero l'id dal form
				elementi['id'] = $('#formCollaboratore').attr('data-IDCollaboratore') || 0;
				
				var done = function( response ){
					
					spinner().modal('hide');
						
					if ( !response.success ) {
						notifica( "Si è verificato un errore nel caricamento del collaboratore!", "danger" );
						return;
					}
					
					notifica( "Il collaboratore è stato correttamente caricato", "success" );
					
					$('#formCollaboratore').attr( 'data-IDCollaboratore', response.id );
					
				}
				
				spinner("Caricamento delle informazioni del collaboratore").modal('show');
				
				eseguiAzione( 'aggiornaCollaboratore', elementi, done );
				
			});
			
			azioniCollaboratore();
			
			break;
		}
		
		case 'elenco_collaboratori':{
			
			function azioniElencoCollaboratori(){
				
				var elimina = $('.eliminaCollaboratore');
				elimina.unbind('click');
				elimina.click(function(){
					
					var row = $(this).parents('tr');
						
					bootbox.confirm('Sicuro di voler eliminare il collaboratore?', function(conferma) {
						
						if ( !conferma ) {
							return;
						}else{
							
							var IDCollaboratore = row.attr('data-id');
							
							var elementi = {
								'id': IDCollaboratore
							}
							
							var done = function( response ){
								
								if ( !response.success ) {
									notifica( "Si è verificato un errore durante la cancellazione del collaboratore", 'danger' );
									return;
								}
								
								//rimuovo la row
								row.fadeOut( function(){ row.remove() } );
								
								//notifico
								notifica( "Il collaboratore è stato correttamente eliminato", "success" );
							
							}
							
							eseguiAzione( 'eliminaCollaboratore', elementi, done );
							
						}
						
					});
					
				});
				
			}
			
			azioniElencoCollaboratori();
			
			break;
		}
		
		case 'ore_collaboratori':{
			
			var calendario = null;
			
			function azioniGiornata(){
				
			}
			
			function loadEvents( eventi ){
				
				var giornate = [];
				
				$(eventi).each(function(){
					var evento = this;
					
					//creo l'evento in background
					var giornataBG = {
						overlap: false,
						rendering: 'background',
						color: '#07F',
						start: evento.data
					};
					giornate.push( giornataBG );
					
					//creo l'evento per metterci il testo
					var giornataTXT = {
						id: evento.id,
						start: evento.data,
						backgroundColor: 'transparent',
						borderColor: 'transparent',
						title: 'ore: '+evento.ore+'\n'+'straordinari: '+evento.straordinari+'\n'+evento.descrizione,
						textColor: '#454545'
					}
					giornate.push( giornataTXT );
					
				})
				
				calendario.fullCalendar( 'removeEvents' );
				calendario.fullCalendar( 'addEventSource', giornate );
				calendario.fullCalendar( 'refetchEvents' );
				
			}
			
			function giornateCollaboratore( IDCollaboratore ){
				
				var elementi = {
					'IDCollaboratore': IDCollaboratore
				}
				
				var done = function( response ){
						
					if ( !response.success ) {
						notifica( "Si è verificato un errore nel recupero delle giornate del collaboratore", "danger" );
						return;
					}
					
					loadEvents( response.giornate )
					$('#nominativoCollaboratore').html( response.nominativo );
					
				}
				
				eseguiAzione( 'giornateCollaboratore', elementi, done );
				
			}
			
			function ajaxGiornata( IDGiornata ){
				
				var elementi = {
					'IDGiornata': IDGiornata
				}
				
				var done = function( response ){
						
					if ( !response.success ) {
						notifica( "Si è verificato un errore nel recuperare le informazioni sulla giornata.", "danger" );
						return;
					}
					
					$('#formGiornata').html( response.formGiornata );
					$('#aggiungiGiornataForm').fadeIn();
					
					datepickerTool();
					inputDecimal();
					
					azioniGiornata();
					
				}
				
				eseguiAzione( 'formGiornata', elementi, done );
				
			}
			
			$('#aggiungiGiornata').click(function(){
				ajaxGiornata( 0 );
			});
			
			$('#aggiornaGiornata').click(function(){
				
				//recupero gli elementi
				var elementi = recuperaElementi(['data','descrizione','ore','straordinari', 'IDGiornata','IDCollaboratore']);
				
				var done = function( response ){
						
					if ( !response.success ) {
						notifica( "Si è verificato un errore nell'aggiornamento della giornata.", "danger" );
						return;
					}
					
					notifica( "La giornata è stata correttamente salvata", "success" );
					
					loadEvents( response.giornate );
					
					$('#annullaGiornata').click();
					
				}
				
				eseguiAzione( 'aggiornaGiornata', elementi, done );
				
			});
			
			$('#annullaGiornata').click(function(){
				
				$('#formGiornata').html('');
				$('#aggiungiGiornataForm').hide();
				
			});
			
			calendario = $('#calendar').fullCalendar({
				allDayDefault: true,
				eventClick: function ( infoEvento ) {
					ajaxGiornata( infoEvento.id );
				}
			});
			
			//richiamo l'ajax che prende gli eventi
			giornateCollaboratore( $('#IDCollaboratore').val() );
			
			$('#IDCollaboratore').change(function(){
				giornateCollaboratore( $('#IDCollaboratore').val() );
			});
			
			//codice per l'esportazione
			$('#esportaGiornate').click(function(){
				$('#esportaGiornateForm').slideToggle();
			});
			
			$('#annullaEsportaGiornate').click(function(){
				$('#esportaGiornateForm').slideUp();
			});
			
			$('#confermaEsportaGiornate').click(function(){
				
				var elementi = recuperaElementi(['esportaDA','esportaA','IDCollaboratore']);
				
				var done = function( response ){
						
					if ( !response.success ) {
						notifica( "Si è verificato un errore con l'esportazione delle giornate del collaboratore", "danger" );
						return;
					}
					
					window.open( response.filename, '_blank' );
					
				}
				
				eseguiAzione( 'esportaOreCollaboratore', elementi, done );
				
			});
			
			azioniGiornata();
			
			break;
		}
		
		case 'provvigioni_collaboratori':{
			
			function provvigioniCollaboratore( IDCollaboratore ){
				
				var elementi = {
					'IDCollaboratore': IDCollaboratore,
					'annoFatturazione': $('#annoFatturazione').val()
				}
				
				var done = function( response ){
						
					if ( !response.success ) {
						notifica( "Si è verificato un errore nel recupero delle provvigioni del collaboratore", "danger" );
						return;
					}
					
					$('#nominativoCollaboratore').html( response.nominativoCollaboratore );
					
					//svuoto la tabella e aggiungo le informazioni appena ricevute
					tabelleDefault.fnClearTable();
					
					$( response.provvigioni ).each(function(){
						
						var provvigione = this;
						
						tabelleDefault.fnAddData([ 	provvigione.ragioneSocialeCliente,
													provvigione.fatturatoTotaleAnnuo,
													provvigione.percentuale,
													provvigione.provvigioneAnnua 
						], true );
						
					});
					
					
				}
				
				eseguiAzione( 'provvigioniCollaboratore', elementi, done );
				
			}
			
			//richiamo l'ajax che prende gli eventi
			provvigioniCollaboratore( $('#IDCollaboratore').val() );
			
			$('#IDCollaboratore').change(function(){
				
				provvigioniCollaboratore( $(this).val() );
				
			});
			
			$('#annoFatturazione').keyup(function(){
				
				var field = $(this);
				var value = field.val();
				
				if ( value.length == 4 ) {
					provvigioniCollaboratore( $('#IDCollaboratore').val() );
				}
				
			});
			
			break;
		}
		
		//************************************************************************************************
		//FATTURA
		case 'fattura':{
			
			function aggiungiGiorni( giorni ){

				var oggi = new Date().toISOString().slice(0, 10);
				var scadenza = addDays( oggi, giorni ).toISOString().slice(0, 10);
				
				scadenza = dataDaUSA( scadenza );
				
				$('#scadenza').val( scadenza );
				$('#giorniScadenza').html( ' ' + giorni );
				
			}
			
			function elementiFattura(){
				return recuperaElementi([	'prezzo','numeroDocumento','data','tipologia','modalitaPagamento','imponibile','iva','speseEsentiIVA',
											'speseExtra','speseIncasso','importoSconto','percentualeSconto','bolli','varie','acconto','scadenza']);
			}
			
			$('#annoAlternativo').keyup(function(){
				var campoAlternativo = $(this);
				//quando inserisce un nuovo anno faccio una chiamata ajax per prendere il codice incrementale di quest'anno
				var annoInserito = campoAlternativo.val();
				
				if ( annoInserito.length == 4 || annoInserito.length == 0 ) {
					
					var elementi = {
						'anno': annoInserito
					}
					
					var done = function( response ){
						
						if ( !response.success ) {
							notifica( "Si è verificato un errore nel calcolo del codice prospetto!", 'danger' );
							return;
						}
						
						//se tutto va bene, cambio il valore nel prospetto
						$('#numeroDocumento').val( response.codice );
					
					}
					
					eseguiAzione( 'codiceFattura', elementi, done );
						
				}
				
			});
			
			$('#prospettiFattura').collapse();
			
			$('#inviaFattura').click(function(e){
				
				e.preventDefault();
				
				var elementi = elementiFattura();
				
				var IDFattura = $('#formFattura').attr('data-IDFattura');
				elementi['IDFattura'] = IDFattura;
				
				var done = function( response ){
						
					if ( !response.success ) {
						notifica( "Si è verificato un errore nell'aggiornamento della fattura", "danger" );
						return;
					}
					
					notifica( "La fattura è stata correttamente aggiornata", "success" );
					
				}
				
				eseguiAzione( 'aggiornaFattura', elementi, done );
				
			});
			
			$('#prezzo, #speseEsentiIVA, #speseExtra, #speseIncasso, #bolli, #varie, #importoSconto, #percentualeSconto, #iva').on( 'change keyup', function(){
				
				var elementi = elementiFattura();
				
				var done = function( response ){
						
					if ( !response.success ) {
						notifica( "Si è verificato un errore nel calcolo dei totali della fattura", "danger" );
						return;
					}
					
					$('#imponibile').val( response.imponibile );
					$('#totaleConIVA').val( response.totaleConIVA );
					$('#totale').val( response.totale );
					
				}
				
				eseguiAzione( 'calcolaTotaliFattura', elementi, done );
				
			});
			
			$('#modalitaPagamento').change(function(){
				
				var elementi = {
					'modalitaPagamento': $(this).val()
				}
				
				var done = function( response ){
						
					if ( !response.success ) {
						notifica( "Si è verificato un errore nel calcolo dei giorni relativi alla modalità di pagamento", "danger" );
						return;
					}
					
					//alla data di scadenza assegno oggi + il numero di giorni
					if ( response.giorni !== false ) {
						aggiungiGiorni( response.giorni )
					}
					
				}
				
				eseguiAzione( 'giorniModalitaPagamento', elementi, done );
				
			});
			
			$('#giorniScadenza').popover({
				'html' : true,
				'container' : 'body',
				'placement': 'top',
				'content': function(){
					
					var stringa = '<div id="giorniDaAggiungere">';
					
					stringa += '<i class="fa fa-plus" data-giorni="30"> 30</i>';
					stringa += '<i class="fa fa-plus" data-giorni="60"> 60</i>';
					stringa += '<i class="fa fa-plus" data-giorni="90"> 90</i>';
					stringa += '<i class="fa fa-plus" data-giorni="120"> 120</i>';
					
					stringa += '</div>';

					return stringa;
					
				}
			});
			
			$('#giorniScadenza').click(function(){
				//$(this).popover('toggle');
				$('#giorniDaAggiungere i').click(function(){
					var giorni = $(this).attr('data-giorni');
					aggiungiGiorni( giorni );
				});
			});
			
			$('#scadenza').datepickerTool({
				onSelect: function() {
					$('#giorniScadenza').html('');
				}
			});
						
			break;
		}
		
		case 'elenco_fatture':{
			
			//modifica
			var modifica = $('.modificaFattura');
			modifica.unbind('click');
			modifica.click(function(){
				
				var button = $(this);
				var row = button.parents('tr');
				
				//recupero l'id della row
				var IDFattura = row.attr('data-id');
				
				window.location.href = 'fattura.php?id='+IDFattura;
				
			});
			
			var elimina = $('.eliminaFattura');
			elimina.unbind('click');
			elimina.click(function(){
				
				var button = $(this);
				
				bootbox.confirm( 'Sei sicuro di voler eliminare questo fattura?', function(conferma){
				
					if ( !conferma ) {
						return;	
					}else{
						
						var row = button.parents('tr');
						
						//recupero l'id della row
						var IDFattura = row.attr('data-id');
						
						var elementi = {
							'IDFattura': IDFattura
						}
												
						var done = function( response ){
							if ( !response.success ) {
								notifica( "Si è verificato un errore durante l'eliminazione della fattura.", "danger" );
								return;
							}
							
							row.fadeOut(function(){
								row.remove();
							});
							
							notifica( "La fattura è stato corretamente eliminata", "success" );
							
						}
						
						eseguiAzione( 'eliminaFattura', elementi, done );
								
					}
				
				});
				
			});
			
			var confermaPagamento = $('.confermaPagamento');
			confermaPagamento.unbind('click');
			confermaPagamento.click(function(){
				
				var button = $(this);
				
				bootbox.confirm( 'Confermi che questa fattura è stata saldata?', function(conferma){
				
					if ( !conferma ) {
						return;	
					}else{
						
						var row = button.parents('tr');
						
						//recupero l'id della row
						var IDFattura = row.attr('data-id');
						
						var elementi = {
							'IDFattura': IDFattura
						}
												
						var done = function( response ){
							if ( !response.success ) {
								notifica( "Si è verificato un errore durante la conferma di pagamento della fattura.", "danger" );
								return;
							}
							
							notifica( "La conferma di pagamento è stata effettuata correttamente", "success" );
							row.removeClass('saldata0').addClass('saldata1');
														
						}
						
						eseguiAzione( 'saldaFattura', elementi, done );
								
					}
				
				});
				
			});
			
			//quando clicco sulla dicitura faccio apparire il popover con la lista dei fornitori disponibili
			$('#filtraTipologiaProspetto').popover({
				'html' : true,
				'container' : 'body',
				'trigger': 'focus',
				'content': function(){
					
					var stringa = '<div id="filtriElenco">';
					
					stringa += '<i class="fa fa-truck" data-filtro="trasporto"></i>';
					stringa += '<i class="fa fa-dropbox" data-filtro="magazzino"></i>';
					stringa += '<i class="fa fa-exchange" data-filtro="noleggio"></i>';
					stringa += '<i class="all" data-filtro=""><i class="fa fa-truck" data-filtro="trasporto"></i><i class="fa fa-dropbox" data-filtro="magazzino"></i><i class="fa fa-exchange" data-filtro="noleggio"></i></i>';
					
					stringa += '</div>'

					return stringa;
					
				}
			});
			
			$('#filtraTipologiaProspetto').click(function(){
				$(this).popover('toggle');
				$('#filtriElenco i').click(function(){
					var filtro = $(this).attr('data-filtro');
					tabellaProspetti.fnFilter( filtro, 4 );
				});
			});
			
			var tabellaProspetti = $('#tabellaProspetti').dataTable({
		        "oLanguage":{
				    "sEmptyTable":     "Nessun dato presente nella tabella",
				    "sInfo":           "Vista da _START_ a _END_ di _TOTAL_ elementi",
				    "sInfoEmpty":      "Vista da 0 a 0 di 0 elementi",
				    "sInfoFiltered":   "(filtrati da _MAX_ elementi totali)",
				    "sInfoPostFix":    "",
				    "sInfoThousands":  ",",
				    "sLengthMenu":     "Visualizza _MENU_ elementi",
				    "sLoadingRecords": "Caricamento...",
				    "sProcessing":     "Elaborazione...",
				    "sSearch":         "Cerca:",
				    "sZeroRecords":    "La ricerca non ha portato alcun risultato.",
				    "oPaginate": {
				        "sFirst":      "Inizio",
				        "sPrevious":   "Precedente",
				        "sNext":       "Successivo",
				        "sLast":       "Fine"
				    }
				},
		        "aoColumnDefs": [
					{ 'bSortable': false, 'aTargets': [ 4 ] },
					{ "sWidth": "180px", "aTargets": [ 4 ] }
				]
		    });
			
			$('.selezionaProspetto').click(function(){
				checkProspetti( $(this) );
			});
			
			function checkProspetti( checkCliccata ){
				
				var numeroCheck = $('.selezionaProspetto:checked').length;
				var IDClienteCliccato = checkCliccata.parents('tr').attr('data-IDCliente');
				
				//controllo per non farli selezionare clienti diversi
				if ( numeroCheck == 0 ) {
					IDClienteFattura = 0;
				}else if ( numeroCheck == 1 ) {
					IDClienteFattura = IDClienteCliccato;
				}else{
					//controllo che il cliente appena selezionato non sia diverso da quello già scelto
					if ( IDClienteFattura != IDClienteCliccato ) {
						//dececco la check appena ceccata (WTF???)
						checkCliccata.prop( 'checked', false );
						//notifico
						notifica( "Non puoi selezionare preventivi di clienti diversi", "warning" );
						return;
					}
				}
				
				var esistonoProspettiCheckkati = numeroCheck > 0;
				
				$('#generaFattura').prop( 'disabled', !esistonoProspettiCheckkati );
				
			}
			
			$('#generaFattura').click(function(){
				
				//recupero gli id dei prospetti da fatturare
				var IDProspetti = [];
				var IDCliente = 0;
				$('.selezionaProspetto:checked').each(function(){
					
					var tr = $(this).parents('tr');
					
					var IDProspetto = tr.attr('data-id');
					IDProspetti.push( IDProspetto );
					
					IDCliente = tr.attr('data-IDCliente');
					
				});
				
				//recupero i valori e creo la fattura in AJAX
				var elementi = {
					'IDProspetti': IDProspetti,
					'IDCliente': IDCliente
				}
				
				var done = function( response ){
						
					if ( !response.success ) {
						notifica( "Si è verificato un errore nella creazione della fattura", "danger" );
						return;
					}
					
					window.location.href = 'fattura.php?id='+response.IDFattura;
					
				}
				
				eseguiAzione( 'creaFattura', elementi, done );
				
			});
			
			azioniElencoProspetti();
			
			break;
		}
		
	}
	
});

$(window).resize(function(){
});

$(window).load(function(){
	
});

//funzione che recupera le variabili dall'url
function getURLParameter( name ){
	
	var parametri = {};
	
	var sPageURL = window.location.search.substring(1);
    var sURLVariables = sPageURL.split('&');
    for (var i = 0; i < sURLVariables.length; i++) 
    {
        var sParameterName = sURLVariables[i].split('=');
        parametri[sParameterName[0]] = sParameterName[1];
    }
	
	if ( name == undefined ) {
		return parametri;
	}else{
		var valore = parametri[name];
		if ( valore == undefined ) {
			throw 'parametro "'+name+'" inesistente';
		}
		return valore;
	}
	
}
	
//funzione per recuperare gli elementi di un form
function recuperaElementi( elementi, segnalaErrore ) {
	
	if ( segnalaErrore == undefined ) {
		segnalaErrore = true;
	}
	
	$('.has-error').removeClass('has-error');
	
	elementi = $(elementi);
	var obj = {};
	var miss = false;
	elementi.each(function(){
		
		var elemento = $('#'+this);
		
		if ( elemento.length == 0 ) {
			throw 'stai cercando un valore che non esiste: '+String(this);
		}
		
		var value = '';
		//controllo il tipo di elemento
		//se sono radio/check button il valore è unico e devo prendere quello
		var type = elemento.attr('type');
		if ( type == 'checkbox' || type == 'radio' ) {
			var checked = $('input[name="'+this+'"]:checked');
			if ( type == 'radio' ) {
				value = checked.val() || '';
			}else{
				value = [];
				$(checked).each(function(){
					value.push( $(this).val() );
				});				
			}
		}else{
			//per ogni elemento (do per scontato siano id) recupero il valore
			value = elemento.val();			
			//nel caso sia un percorso
			value = value.replace(/^C:\\fakepath\\/, "");
		}
		
		//ora ho recuperto il valore, ma faccio un ulteriore controllo se è una data
		var dateFormat = elemento.attr('data-format');
		if ( dateFormat != undefined ) {
			//vuol dire che è una data quindi inserisco un'informazioni in più nell'oggetto che passo a PHP
			obj[this+'_format'] = dateFormat;
		}
		
		//verifico se è un campo required
		var campoRequired = elemento.attr('required') != undefined;
		if ( value == '' && campoRequired ) {
			elemento.parents('.form-group').addClass('has-error');//classe di default di bootstrap
			miss = true;
		}
		obj[this] = value;
		
	});
	
	if ( miss && segnalaErrore ) return false;
	
	return obj;
	
}

//funzione per resettare i form
function resetForm( form ) {
	form = $(form);
    form.find('input:text, input:password, input:file, select, textarea').val('');
    form.find('select option:first').attr('selected',true);
    form.find('input:radio, input:checkbox').removeAttr('checked').removeAttr('selected');
}

//funzioni per il css visible 
jQuery.fn.visible = function( fade, callback ) {
	
	this.css('visibility', 'visible');
	if ( typeof fade !== undefined ) {
		this.hide();
		this.fadeIn( fade, function(){
			if ( typeof callback !== 'undefined' ) {
				callback();
			}
		} );
	}
	
};

jQuery.fn.invisible = function( fade, callback ) {
	
	var parent = this;
	if ( typeof fade !== undefined ) {
		this.fadeOut( fade, function(){
			parent.show();
			parent.css('visibility', 'hidden');
			if ( typeof callback !== 'undefined' ) {
				callback();
			}
		});
	}else{
		parent.css('visibility', 'hidden');
	}

};

jQuery.fn.visibilityToggle = function() {
    return this.css('visibility', function(i, visibility) {
        return (visibility == 'visible') ? 'hidden' : 'visible';
    });
};

//funzione che attiva tutti i tools che possono esserci nel gestionale
function tools(){

	tooltip();
	inputDecimal();
	inputNumber();
	datepickerTool( 'it', 'dd/mm/yy' );
	select();
	collapse();

	try{
        tabelle.destroy();
    }catch(e){
	    
    }
	
	// CHECKBOX
    $('input').iCheck({
        checkboxClass: 'icheckbox_square-red',
        radioClass: 'iradio_square'
    });
	
	tabelle = $('.table').dataTable({
        "oLanguage":{
		    "sEmptyTable":     "Nessun dato presente nella tabella",
		    "sInfo":           "Vista da _START_ a _END_ di _TOTAL_ elementi",
		    "sInfoEmpty":      "Vista da 0 a 0 di 0 elementi",
		    "sInfoFiltered":   "(filtrati da _MAX_ elementi totali)",
		    "sInfoPostFix":    "",
		    "sInfoThousands":  ",",
		    "sLengthMenu":     "Visualizza _MENU_ elementi",
		    "sLoadingRecords": "Caricamento...",
		    "sProcessing":     "Elaborazione...",
		    "sSearch":         "Cerca:",
		    "sZeroRecords":    "La ricerca non ha portato alcun risultato.",
		    "oPaginate": {
		        "sFirst":      "Inizio",
		        "sPrevious":   "Precedente",
		        "sNext":       "Successivo",
		        "sLast":       "Fine"
		    }
		}
    });
    
    bootbox.setDefaults({
	  /**
	   * @optional String
	   * @default: en
	   * which locale settings to use to translate the three
	   * standard button labels: OK, CONFIRM, CANCEL
	   */
	  locale: "it",
	  
	  /**
	   * @optional Boolean
	   * @default: true
	   * whether the dialog should be shown immediately
	   */
	  show: true,
	  
	  /**
	   * @optional Boolean
	   * @default: true
	   * whether the dialog should be have a backdrop or not
	   */
	  backdrop: true,
	  
	  /**
	   * @optional Boolean
	   * @default: true
	   * show a close button
	   */
	  closeButton: true,
	  
	  /**
	   * @optional Boolean
	   * @default: true
	   * animate the dialog in and out (not supported in < IE 10)
	   */
	  animate: true,
	  
	  /**
	   * @optional String
	   * @default: null
	   * an additional class to apply to the dialog wrapper
	   */
	  className: "my-modal"
	  
	});
    
    /*$('.calendar').fullCalendar({
	    lang: 'it'
    });*/
    
    //google.load("visualization", "1", {packages:["corechart"]});
    
}

//funzione che assegna alla input le caratteristiche per accettare il punto e i decimali
function inputDecimal( delimiter, decimali, selettore ){
	
	var valoreDelimiterStringa;
	if ( delimiter == undefined ) {
		delimiter = 190;//punto
		//delimiter = 188;//virgola
	}
	valoreDelimiterStringa = String.fromCharCode(delimiter - 144);
	
	if ( decimali == undefined ) {
		decimali = 2;
	}
	if ( selettore == undefined ) {
		selettore = '.inputDecimal';
	}
	
	var inputDecimal = $(selettore);
	inputDecimal.keydown(function (e) {
		var valoreAttuale = $(this).val();
		//faccio il controllo per non far inserire come primo valore il delimiter
		//faccio il controllo per non inserire 2 volte il delimiter
		if ( 	(valoreAttuale == '' || valoreAttuale.indexOf(valoreDelimiterStringa) !== -1 )
				&& e.keyCode == delimiter ) {
			return false;
		}
	    // Allow: backspace, delete, tab, escape, enter and .
	    if ($.inArray(e.keyCode, [46, 8, 9, 27, 13, delimiter]) !== -1 ||
	         // Allow: Ctrl+A
	        (e.keyCode == 65 && e.ctrlKey === true) || 
	         // Allow: home, end, left, right, down, up
	        (e.keyCode >= 35 && e.keyCode <= 40)) {
	             // let it happen, don't do anything
	             return;
	    }
	    // Ensure that it is a number and stop the keypress
	    if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
	        e.preventDefault();
	    }else{
		    //numero
		    var dividiValore = valoreAttuale.split( valoreDelimiterStringa );
		    if ( dividiValore.length == 2 ) {
			    //se ho 2 valori vuol dire che ho già messo il punto e controllo che il secondo valore
			    //non sia maggiore di quello che ho impostato
			    if ( dividiValore[1].length == decimali ) {
				    return false;
			    }
		    }
	    }
	});	
	
}

//funzione per inserire solo i numeri in una input
function inputNumber(){
	
	var inputNumber = $('.inputNumber');
	inputNumber.keydown(function (e) {
	    // Allow: backspace, delete, tab, escape, enter and ,
	    if ($.inArray(e.keyCode, [46, 8, 9, 27, 13]) !== -1 ||
	         // Allow: Ctrl+A
	        (e.keyCode == 65 && e.ctrlKey === true) || 
	         // Allow: home, end, left, right, down, up
	        (e.keyCode >= 35 && e.keyCode <= 40)) {
	             // let it happen, don't do anything
	             return;
	    }
	    // Ensure that it is a number and stop the keypress
	    if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
	        e.preventDefault();
	    }
	});
		
}

//funzione che converte le ipnut contrassegate in datapicker
function datepickerTool( lingua, dateFormat ){
	
	if ( lingua == undefined ) {
		lingua = $('html').attr('lang');
	}
	
	if ( dateFormat == undefined ) {
		//se il formato non è definito mi affido al picker
		//dateFormat = 'dd/mm/yy';
	}
	
	var pickers = $( ".datepicker" );
	
	if ( typeof(pickers.datepicker) == 'function' ) {
		
		pickers.datepicker('destroy');	
	
	}
	
	pickers.datepicker(
		$.datepicker.regional[lingua]
	);
	
	if ( dateFormat != undefined ) {
		pickers.datepicker( "option", "dateFormat", dateFormat );	
	}
	
	pickers.attr('data-format', pickers.datepicker( "option", "dateFormat" ) );
	
}

//plugin per i tooltips
function tooltip(){
	$('[data-toggle="tooltip"]').tooltip({
		'container':'body'
	});
}

//funzione che applica il plugin per fare le select con la ricerca
function select(){
	$('.select2').select2({ width: 'resolve' });
}

//collapse per gli elementi, vedere bootstrap
function collapse(){
	$('.collapse').collapse();
}

//funzione che richiamo lo spinner e gli inserisce il messaggio di attesa che viene passato
function spinner( msg ){
	
	if ( msg != undefined ) {
		$('.spinner').find('.modal-body').html( msg );	
	}
	
	$('.spinner').modal({
		backdrop: 'static',
		keyboard: false
	});
	
	return $('.spinner');
	
}

//funzione per fare le chiamte AJAX
function eseguiAzione( azione, vars, doneFunction ){
	//in AJAX richiamo la pagina
	var request = $.ajax({
		type: "POST",
		url: "../core/action.php",
		beforeSend:function(){
			console.log('------------------------------------------------------------------------------------------------------------');
			console.log('elementi inviati');
			console.log( vars );
		},
		data: {
				'azione': azione,
				'vars': vars
			}
	});
	request.done(function( response ) {
		console.log('elementi ricevuti');
		try{
	        response = JSON.parse(response);
		    console.log( response );
	    }catch(e){
		    console.log( response );
		    response = { "success": false, 'azione': azione }
	    }
	    console.log('------------------------------------------------------------------------------------------------------------');
		doneFunction( response );
	});
};

//funzione che prende l'html dal template
function campiMultipli( button, template, dove, done, condition ){
	
	if ( condition == undefined ) {
		condition = function(){ return true };
	}
	
	if ( done == undefined ) {
		done = function(){};
	}
	
	button.click(function(){
		
		if ( condition() ) {
			//recupero il template o l'aggiungo
			$(dove).append( template.html() );
			done();			
		}
		
	});
	
}

//funzione per recuperare i dati da campi multipli
function valoreCampiMultipli( elementi, selettori, labels ){
	
	var values = [];
	
	elementi.each(function(){
		
		var elemento = $(this);
		
		var obj = {}
		for ( i = 0; i < selettori.length; i++ ) {
			obj[labels[i]] = elemento.find( selettori[i] ).val();
		}
		
		values.push( obj );
		
	});
	
	return values;
	
}

//dato che sono spesso dati che vanno in coppia, è una funzione per prenderli velocemente
function valoreCampiMultipliKeyValue( elementi, selettoreKey, selettoreValue ){
	
	var values = {};
	
	elementi.each(function(){
		
		var elemento = $(this);
		
		var key = elemento.find( selettoreKey ).val();
		var value = elemento.find( selettoreValue ).val()
		
		values[key] = value;
		
	});
	
	return values;
	
}

//funzione che dal nome selezionato della città ricava tutte le informazioni relative
function cittaDinamiche( IDCitta, cap, provincia, regione, nazione ){
	
	var elementi = {
		'IDCitta': IDCitta
	}
	
	var done = function( response ){
		
		if ( !response.success ) {
			//Errore
			return;
		}
		
		if ( cap != null ) {
			cap.val( response.cap );	
		}
		
		if ( provincia != null ) {
			provincia.val( response.provincia );
		}
			
		if ( regione != null ) {
			regione.val( response.regione );
		}
		
		if ( nazione != null ) {
			nazione.val( response.nazione );	
		}
		
	}
	
	eseguiAzione( 'cittaDinamiche', elementi, done );
	
}

//funzione che dal cap restituisce le città associate
function CAPDinamici( cap, citta, provincia, regione, nazione ){
	
	var elementi = {
		'CAP': cap
	}
	
	var done = function( response ){
		
		if ( !response.success ) {
			//Errore, non dovrebbe nemmneno mai arrivare fin qui se c'è stato un errore
			return;
		}
		
		if ( citta != null ) {
			//ora è probabile che ci siano più citta per un singolo CAP
			//quindi ciclo response.citta che è sicuramente un array e inserisco le città nella select
			
			//da vedere bene se è sempre utile/intelligente sostituire completamente le option oppure se è meglio filtrarle da un elenco completo
			//se si sostituiscono, ottimizzare la visualizzazione, perché anche in lettura/modifica poi si deve filtrare correttamente
			//si potrebbe fare una funzione in più oppure mettere un parametro
			
			if ( response.citta.length != 0 ) {

				citta.html('');
				var elemento = null;
				$( response.citta ).each(function(){
					//creo la option
					elemento = this;
					var IDCitta = elemento.id;
					var value = elemento.citta;
					citta.append('<option value="'+IDCitta+'">'+value+'</option>');
				});
				
				if ( response.citta.length == 1 ) {
					
					//se è un solo elemento setto direttamete anche gli altri campi
					if ( provincia != null ) {
						provincia.val( elemento.provincia );
					}
						
					if ( regione != null ) {
						regione.val( elemento.regione );
					}
					
					if ( nazione != null ) {
						nazione.val( elemento.nazione );	
					}
					
				}else{
					
					//se sono più elementi svuoto i campi
					if ( provincia != null ) {
						provincia.val('');
					}
						
					if ( regione != null ) {
						regione.val('');
					}
					
					if ( nazione != null ) {
						nazione.val('');
					}
					
				}
				
				select();
				
			}
			
		}
		
	}
	
	eseguiAzione( 'CAPDinamici', elementi, done );
	
}

//funzione per scrollare dolcemente fino ad un elemento
function scrollTo( elemento ){
    $('html,body').animate({scrollTop: elemento.offset().top},'slow');
}

//funzione che fa la notifica. i tipi sono success, warning, danger
function notifica( messaggio, tipo, delayValue ){
	
	if ( delayValue == undefined ) {
		delayValue = 1000
	}
	
	$.notify({
		message: messaggio
	},{
		type: tipo,
		allow_dismiss: false,
		delay: delayValue,
		placement: {
			from: "top",
			align: "center"
		},
	});
	
}

//aggiunge giorni ad una data
function addDays(date, days) {
    var result = new Date(date);
    result.setDate(result.getDate() + parseInt(days));
    return result;
}

//converte una da dal formato americano a quello europeo
function dataDaUSA( dataUSA ){
	
	pezzi = dataUSA.split('-');
	pezzi = [ pezzi[2], pezzi[1], pezzi[0] ];
	return pezzi.join('/');
	
}

//converta una data dal formato europeo a quello USA
function dataUSA( dataEU ){
	
	var pezzi = dataEU.split('/');
	pezzi = [ pezzi[2], pezzi[1], pezzi[0] ];
	return pezzi.join('-');
	
}

//fill di valori a sinistra
function pad(n, width, z) {
  z = z || '0';
  n = n + '';
  return n.length >= width ? n : new Array(width - n.length + 1).join(z) + n;
}















































