<?

class Articolo{

	private $info; #contiene le info dell'oggetto, in pratica le row dal DB
	private $codice; #tiene l'id/codice dell'oggetto

	const DELIMITER = '/';
	
	#di default, la construct fa solo l'init dell'oggetto
	function __construct( $codice ){
		$this->init( $codice );#se false andrebbe male comunque
	}
	
	/*
	- funzione di default, recupero i valori dell'oggetto
	- l'opzione raw serve per recuperare il valore grezzo e non elaborato, per esempio. direttamente l'id di un oggetto
	- se ci sono opzioni particolari per questa classe la si mette in option che può essere qualunque cosa,
	  tendenzialemente sarà un array con chiave->valore
	*/
	public function get( $key, $option = null, $lang = null, $raw = false ) {
		
		#recupero il valore dall'oggetto
		$valore = isset( $this->info[$key] ) ? $this->info[$key] : $this->info["PR_{$key}"];
		
		#se ho richiesto il valore grezzo, lo restituisco subito
		if ( $raw ) {
			return $valore;
		}
		
		#altrimenti controllo nello switch se questo campo dev'essere elaborato
		switch ( $key ) {
			
			#elaborazione per i valori JSON
			case 'composizione':{
				
				$valore = json_decode( $valore, true );
				if ( is_null($valore) ) {
					$valore = array();
				}
				
				break;
			}
			
			#elaborazioni per le date
			case 'data':{
				
				$valore = dataDaUSA( $valore );
				if ( $valore == '01/01/1970' ) {
					$valore = '';
				}
				
				break;
			}
			
			#PR_codiceManutenzione è dato da 5 caratteri riferiti a 5 tabelle diverse
			case 'codiceManutenzione':{
				
				#in option posso avere la singola caratterisitca che voglio ottenere
				#altrimenti le restituisce tutte in un array
				
				#separo i codici: tabelle PROTEX ARKMN A/B/C/D/E
				list( $lavaggio, $candeggio, $stiro, $lavaggioASecco, $asciugatura ) = str_split($valore);
				
				#per ogni codice creo l'oggetto con le informazioni
				$valore = array(
					CodiceManutenzione::LAVAGGIO			=> new CodiceManutenzione( $lavaggio, 		CodiceManutenzione::LAVAGGIO 		 ),
					CodiceManutenzione::CANDEGGIO 			=> new CodiceManutenzione( $candeggio, 		CodiceManutenzione::CANDEGGIO 		 ),
					CodiceManutenzione::STIRO 				=> new CodiceManutenzione( $stiro, 			CodiceManutenzione::STIRO 			 ),
					CodiceManutenzione::LAVAGGIO_A_SECCO	=> new CodiceManutenzione( $lavaggioASecco, CodiceManutenzione::LAVAGGIO_A_SECCO ),
					CodiceManutenzione::ASCIUGATURA 		=> new CodiceManutenzione( $asciugatura, 	CodiceManutenzione::ASCIUGATURA 	 )
				);
				
				if ( !is_null($option) ) {
					#restituisco il singolo valore
					$valore = $valore[$option];
				}
				
				break;
			}
			
			case 'peso':
			case 'altezza':
			case 'pesoMetroQuadro':
			case 'filiBattute':{
				
				list( $inizio, $fine ) = explode( Articolo::DELIMITER, $valore );
				
				$valore = array(
					'inizio' => $inizio,
					'fine' => $fine,
				);
				
				#in option posso avere 'inizio' o 'fine'
				if ( !is_null($option) ) {
					$valore = $valore[$option];
				}
				
				break;
			}
			
		}
		
		#restituisco il valore elaborato
		return $valore;

	}
	
	/*
	#funzione per settare il valore 
	public function set( $key, $valore, $option = null ) {
			
		switch ( $key ) {
			
			#elaborazione per i valori JSON
			case 'contatti':{
				
				$valore = json_encode( $valore );
				
				break;
			}
			
			#elaborazione per le date
			case 'data':{
				
				$valore = dataUSA( $valore, $option['format'] );
				
				break;
			}
			
		}
		
		#aggiorno il valore
		$query = "
			UPDATE clienti
			SET {$key} = '{$valore}'
			WHERE id = {$this->id}
		";
		$success = mysql_query($query);
		
		#riassegno questo valore alla variabile $info
		$this->info[$key] = $valore;
		
		#IMPORTANTISSIMO!!!
		#deve sempre restituire il successo della query
		#altrimenti non si aggiorna correttamente lato action
		return $success;
		
	}
	
	#funzione di default per creare un nuovo oggetto
	static function nuovo( $returnOBJ = true ){
		
		#in questa query metto tutti i valori di defulat che mi servono per far funzionare bene l'oggetto
		$query = "
					INSERT INTO clienti( contatti )
					VALUES( '{}' )
		";
		mysql_query($query);
		
		#recupero l'id appena inserito
		$idOBJ = mysql_insert_id();
		
		#restituisco l'oggetto appena creato
		if ( $returnOBJ ) {
			return new Cliente( $idOBJ );
		}else{
			#se non vuole l'oggetto almeno restituisco l'id
			return $idOBJ;
		}
		
		#non considero l'idea che ci possano essere errori in questa funzione perché dai cazzo!!
		
	}
	
	#funzione per eliminare l'oggetto
	static function elimina( $id, $eliminazioneFisica ){
		
		$success = true;
		
		mysql_query("START TRANSACTION");
		
		#dentro la transaction elimino le row associate a questo oggetto
		#ogni delete deve salvare il successo della query per controllare alla fine se tutto è andato liscio
		#del tipo così:
		#$success = $success && mysql_query($query);
		
		#infine elimino l'oggetto
		#eliminazione fisica di un elemento
		if ( $eliminazioneFisica ) {
			
			$query = "
						DELETE FROM clienti
						WHERE id = {$id}
			";
			$success = $success && mysql_query($query);			
			
		}else{
			
			#eliminazione logica dell'elemento
			$dataEliminazione = date();
			$query = "
						INSERT INTO cestino( IDElemento, tabella, data )
						VALUES ( {$this->id}, 'clienti', '{$dataEliminazione}' )
			";
			$success = $success && mysql_query($query);
			
		}
		
		
		#se non ci sono stati problemi, committo il tutto
		if ( $success ) {
			mysql_query("COMMIT");
		}else{
			#se qualcosa è andato storto, torno indietro
			mysql_query("ROLLBACK");
		}
		
		#restituisco com'è andata
		return $success;
		
	}
	*/
	
	#funzione che inizializza un nuovo oggetto e recupera tutte le informazioni dal DB
	private function init( $codice ){
		
		#se l'id non esiste restituisco un oggetto vuoto
		#serve nei form al primo accesso, quando creo un nuovo elmento
		if ( is_null($id) ) {
			$this->info = array();
			$this->codice = null;
		}else{
			
			#recupero le informazioni di questo elemento
			$query = "
						SELECT articoli.*, infoArticoli.*, COUNT( articoli.PR_codiceArticolo ) AS counter
						FROM articoli, infoArticoli
						WHERE 	articoli.PR_codiceArticolo = {$codice} AND
								infoArticoli.codiceArticolo
			";
			$this->risorse = mysql_query($query);
			$this->info = mysql_fetch_assoc($this->risorse);
			
			if ( $this->info['counter'] == 0 ) {
				return false;#se qualcosa non è andata bene restituisco false
			}
	
			$this->codice = $codice;
				
		}
		
	}
	
	#funzione per la creazione della vista di questa tabella
	static function vista(){
		
		$ditta = '002';
		
		$query = "
			
			CREATE OR REPLACE VIEW articoli
			AS
				SELECT 
					ARKFCC.STAGIONEFCC 				AS PR_stagione,
					ARKFCC.ARTICOLOFCC 				AS PR_codiceArticolo,
					ARKFCC.VARIANTEFCC 				AS PR_codiceColore,
					ARKFAM.DESCRFAMIGLIA 			AS PR_nomeArticolo,
					ARKFAM.FAMIGLIA 				AS PR_codiceFamiglia,
					ARKTTS.NOTEGENERALI2TTS 		AS PR_titoloTrama,
					ARKFCC.LIVVARFCC				AS PR_livelloPrezzo,
					ARKLIS.CODICEMANUTENZIONELI		AS PR_codiceManutenzione, #codiceLavaggio, codiceCandeggio, codiceStiro, codiceLavaggioASecco, codiceAsciugatura
					ARKFMI.DESCRFAMIGLIAFMI			AS PR_codiceDisegno,
					ARKCAA.DESCRIZIONECAA			AS PR_armatura,
					ARKTTS.NOTEGENERALI1TTS			AS PR_titoloCatena,
					ARKVSC.STATOCOMMERCIALE_VSC		AS PR_statoCommerciale,
					ARKFCC.CARTELLAFCC				AS PR_cartella,
					
					CONCAT( ARKTTS.FILIFINITOTTS,'{Articolo::DELIMITER}',ARKTTS.FILITRAMATTS ) AS PR_filiBattute,
					CONCAT( ARKTTS.PESOCOMINIZIOTTS,'{Articolo::DELIMITER}',ARKTTS.PESOCOMFINETTS ) AS PR_pesoMetroQuadro,
					CONCAT( ARKLIS.PESOFINITOINIZIOLI, '{Articolo::DELIMITER}', ARKLIS.PESOFINITOFINELI ) 		AS PR_peso,
					CONCAT( ARKLIS.ALTEZZAFINITOINIZIOLI,'{Articolo::DELIMITER}', ARKLIS.ALTEZZAFINITOFINELI )	AS PR_altezza,
					
					CONCAT(
						'[',
							IF( ARKLIS.PERCCOMP1LI <> 0, CONCAT( ARKLIS.PERCCOMP1LI,'% ',ARKLIS.SIGLACOMP1LI,',' ), '' ),
							IF( ARKLIS.PERCCOMP2LI <> 0, CONCAT( ARKLIS.PERCCOMP2LI,'% ',ARKLIS.SIGLACOMP2LI,',' ), '' ),
							IF( ARKLIS.PERCCOMP3LI <> 0, CONCAT( ARKLIS.PERCCOMP3LI,'% ',ARKLIS.SIGLACOMP3LI,',' ), '' ),
							IF( ARKLIS.PERCCOMP4LI <> 0, CONCAT( ARKLIS.PERCCOMP4LI,'% ',ARKLIS.SIGLACOMP4LI,',' ), '' ),
							IF( ARKLIS.PERCCOMP5LI <> 0, CONCAT( ARKLIS.PERCCOMP5LI,'% ',ARKLIS.SIGLACOMP5LI,',' ), '' ),
							IF( ARKLIS.PERCCOMP6LI <> 0, CONCAT( ARKLIS.PERCCOMP6LI,'% ',ARKLIS.SIGLACOMP6LI,',' ), '' ),
						']'
					) AS PR_composizione
					
				FROM
					ARKFCC, ARKFAM, ARKLIS, ARKTTS, ARKFMI, ARKCAA, ARKVSC
		
				WHERE
					#fisso per ogni query
						ARKFCC.DITTA = '{$ditta}' AND
						ARKLIS.DITTA = '{$ditta}' AND
						ARKTTS.DITTA = '{$ditta}' AND
						ARKFAM.DITTA = '{$ditta}' AND
						ARKFMI.DITTA = '{$ditta}' AND
						ARKCAA.DITTA = '{$ditta}' AND
						ARKVSC.DITTA = '{$ditta}' AND
						
					#per recuperare PR_nomeArticolo e PR_codiceFamiglia
						ARKFCC.ARTICOLOFCC 	= ARKLIS.ARTICOLO AND
						ARKLIS.FAMIGLIA 	= ARKFAM.FAMIGLIA AND
					
					#per recuperare PR_titoloTrama
					#FINISSAGGIOTTS fisso a '00'
						ARKTTS.ARTICOLOTTS 		= ARKFCC.ARTICOLOFCC AND
						ARKTTS.FINISSAGGIOTTS 	= '00' AND
					
					#recupero PR_codiceDisegno
						ARKFCC.ARTICOLOFCC 	= ARKLIS.ARTICOLO AND
						ARKLIS.RAGMODLI 	= ARKFMI.FAMIGLIAFMI AND
						
					#recupero l'armatura PR_armatura
						ARKTTS.SCELTACAMPOTTS = ARKCAA.CARATTERISTICA AND
					
					#recupero stato commerciale
						ARKVSC.ARTICOLO_VSC	= ARKFCC.ARTICOLOFCC AND
						ARKVSC.STAGIONE_VSC	= ARKFCC.STAGIONEFCC AND
						ARKVSC.COLORE_VSC 	= ARKVSC.VARIANTEFCC
						
		";
		
		mysql_query($query);
		
	}

}












