<?

class CodiceManutenzione{

	const LAVAGGIO 			= 'lavaggio';
	const CANDEGGIO 		= 'candeggio';
	const STIRO 			= 'stiro';
	const LAVAGGIO_A_SECCO	= 'lavaggioASecco';
	const ASCIUGATURA 		= 'asciugatura';

	private $info; #contiene le info dell'oggetto, in pratica le row dal DB
	private $codice; #tiene l'id dell'oggetto

	#di default, la construct fa solo l'init dell'oggetto
	function __construct( $codice ){
		$this->init( $codice );#se false andrebbe male comunque
	}
	
	/*
	- funzione di default, recupero i valori dell'oggetto
	- l'opzione raw serve per recuperare il valore grezzo e non elaborato, per esempio. direttamente l'id di un oggetto
	- se ci sono opzioni particolari per questa classe la si mette in option che può essere qualunque cosa,
	  tendenzialemente sarà un array con chiave->valore
	*/
	public function get( $key, $lang, $option = null, $raw = false ) {
		
		#recupero il valore dall'oggetto
		$valore = isset( $this->info[$key] ) ? $this->info[$key] : $this->info["PR_{$key}"];
		
		#se ho richiesto il valore grezzo, lo restituisco subito
		if ( $raw ) {
			return $valore;
		}
		
		#altrimenti controllo nello switch se questo campo dev'essere elaborato
		switch ( $key ) {
			
			#elaborazione per i valori JSON
			case 'contatti':{
				
				$valore = json_decode( $valore, true );
				if ( is_null($valore) ) {
					$valore = array();
				}
				
				break;
			}
			
			#elaborazioni per le date
			case 'data':{
				
				$valore = dataDaUSA( $valore );
				if ( $valore == '01/01/1970' ) {
					$valore = '';
				}
				
				break;
			}
			
			#per gli ID di altri elementi recupero l'oggetto
			case 'IDCitta':{
				
				$valore = new Citta( $valore );
				
				break;
			}
			
			#PR_codiceManutenzione è dato da 5 caratteri riferiti a 5 tabelle diverse
			case 'PR_codiceManutenzione':{
				
				#in option posso avere la singola caratterisitca che voglio ottenere
				#altrimenti le restituisce tutte in un array
				
				#separo i codici: tabelle PROTEX ARKMN A/B/C/D/E
				list( $lavaggio, $candeggio, $stiro, $lavaggioASecco, $asciugatura ) = str_split($valore);
				
				if ( !is_null($option) ) {
					#restituisco il singolo valore
					
				}
				
				break;
			}
			
		}
		
		#restituisco il valore elaborato
		return $valore;

	}
	
	/*
	#funzione per settare il valore 
	public function set( $key, $valore, $option = null ) {
			
		switch ( $key ) {
			
			#elaborazione per i valori JSON
			case 'contatti':{
				
				$valore = json_encode( $valore );
				
				break;
			}
			
			#elaborazione per le date
			case 'data':{
				
				$valore = dataUSA( $valore, $option['format'] );
				
				break;
			}
			
		}
		
		#aggiorno il valore
		$query = "
			UPDATE clienti
			SET {$key} = '{$valore}'
			WHERE id = {$this->id}
		";
		$success = mysql_query($query);
		
		#riassegno questo valore alla variabile $info
		$this->info[$key] = $valore;
		
		#IMPORTANTISSIMO!!!
		#deve sempre restituire il successo della query
		#altrimenti non si aggiorna correttamente lato action
		return $success;
		
	}
	
	#funzione di default per creare un nuovo oggetto
	static function nuovo( $returnOBJ = true ){
		
		#in questa query metto tutti i valori di defulat che mi servono per far funzionare bene l'oggetto
		$query = "
					INSERT INTO clienti( contatti )
					VALUES( '{}' )
		";
		mysql_query($query);
		
		#recupero l'id appena inserito
		$idOBJ = mysql_insert_id();
		
		#restituisco l'oggetto appena creato
		if ( $returnOBJ ) {
			return new Cliente( $idOBJ );
		}else{
			#se non vuole l'oggetto almeno restituisco l'id
			return $idOBJ;
		}
		
		#non considero l'idea che ci possano essere errori in questa funzione perché dai cazzo!!
		
	}
	
	#funzione per eliminare l'oggetto
	static function elimina( $id, $eliminazioneFisica ){
		
		$success = true;
		
		mysql_query("START TRANSACTION");
		
		#dentro la transaction elimino le row associate a questo oggetto
		#ogni delete deve salvare il successo della query per controllare alla fine se tutto è andato liscio
		#del tipo così:
		#$success = $success && mysql_query($query);
		
		#infine elimino l'oggetto
		#eliminazione fisica di un elemento
		if ( $eliminazioneFisica ) {
			
			$query = "
						DELETE FROM clienti
						WHERE id = {$id}
			";
			$success = $success && mysql_query($query);			
			
		}else{
			
			#eliminazione logica dell'elemento
			$dataEliminazione = date();
			$query = "
						INSERT INTO cestino( IDElemento, tabella, data )
						VALUES ( {$this->id}, 'clienti', '{$dataEliminazione}' )
			";
			$success = $success && mysql_query($query);
			
		}
		
		
		#se non ci sono stati problemi, committo il tutto
		if ( $success ) {
			mysql_query("COMMIT");
		}else{
			#se qualcosa è andato storto, torno indietro
			mysql_query("ROLLBACK");
		}
		
		#restituisco com'è andata
		return $success;
		
	}
	*/
	
	#funzione che inizializza un nuovo oggetto e recupera tutte le informazioni dal DB
	private function init( $codice, $tipoManutenzione ){
		
		#se l'id non esiste restituisco un oggetto vuoto
		#serve nei form al primo accesso, quando creo un nuovo elmento
		if ( is_null($id) ) {
			$this->info = array();
			$this->codice = null;
		}else{
			
			#recupero le informazioni di questo elemento
			$query = "
						SELECT *, COUNT(id) AS counter
						FROM codiciManutenzione_
						WHERE PR_codice = {$codice}
			";
			$this->risorse = mysql_query($query);
			$this->info = mysql_fetch_assoc($this->risorse);
			
			if ( $this->info['counter'] == 0 ) {
				return false;#se qualcosa non è andata bene restituisco false
			}
	
			$this->codice = $codice;
				
		}
		
	}
	
	#funzione per la creazione della vista di questa tabella
	static function vista(){
		
		$ARK_MNX = array( 'MNA', 'MNB', 'MNC', 'MND', 'MNE' );
		
		$ditta = '002';
		
		foreach ( $ARK_MNX as $suffix ) {
			
			$tabella = "ARK{$suffix}";
			
			$query = "
			
				CREATE OR REPLACE VIEW codiciManutenzione_{$suffix}
				AS
					SELECT
						{$tabella}.CODICE_{$suffix} AS PR_codice,
						{$tabella}.LINGUA_{$suffix} AS PR_lingua,
						{$tabella}.DESCRIZIONE_{$suffix} AS PR_descrizione
						
					FROM
						{$tabella}
						
					WHERE
						{$tabella}.DITTA = {$ditta}
						
			";
			
			mysql_query($query);	
			
		}
		
	}
	
	function tabellaDaTipologia( $tipoManutenzione ){
		
		$tabella = 'ARKMN';
		
		$suffix = '';
		
		switch ( $tipoManutenzione ) {
			
			case CodiceManutenzione::LAVAGGIO:{
				$suffix = 'A';
				break;
			}
			
			case CodiceManutenzione::CANDEGGIO:{
				$suffix = 'B';
				break;
			}
			
			case CodiceManutenzione::STIRO:{
				$suffix = 'C';
				break;
			}
			
			case CodiceManutenzione::LAVAGGIO_A_SECCO:{
				$suffix = 'D';
				break;
			}
			
			case CodiceManutenzione::ASCIUGATURA:{
				$suffix = 'E';
				break;
			}
			
		}
		
		$tabella .= $suffix;
		
		return $tabella;
		
	}

}












