<?

class Bordero{

	private $risorse;
	private $info;
	private $id;
	
	const DELIMITER = '/';
	const ESTENSIONE_FILE = 'pdf';
	const PREFISSO = 'bordero_';
	const PATH = 'PDF/bordero/';
	
	function __construct( $id ){
		$this->init( $id );
	}

	public function get( $key, $raw = false ) {

		$valore = $this->info[$key];

		if ( $raw ) {
			return $valore;
		}

		switch ( $key ) {
			
			case 'IDTrasporti':{
				
				$ids = json_decode( $valore, true );
				if ( is_null($ids) ) {
					$ids = array();
				}
				
				$valore = array();
				foreach ( $ids as $id ) {
					$valore[] = new ProspettoTrasporto( $id );
				}
				
				break;
			}
			
			case 'IDFornitore':{
				
				$valore = new Fornitore( $valore );
				
				break;
			}
			
			case 'totaleVolume':
			case 'totalePeso':{
				
				$valore = (float)$valore;
				
				break;
			}
			
			case 'totaleConsegne':{
				
				$valore = (int)$valore;
				
				break;
			}
			
		}

		return $valore;

	}

	public function set( $key, $valore ) {
			
		switch ( $key ) {
		
			case 'IDTrasporti':{
				
				arrayIntVal( $valore );
				$valore = json_encode( $valore );
				
				break;
			}
			
		}
		
		$query = "
			UPDATE bordero
			SET {$key} = '{$valore}'
			WHERE id = {$this->get('id')}
		";
		mysql_query($query);
		
		$this->info[$key] = $valore;
		
	}
		
	static function nuovo(){
		
		$numeroDocumento = Bordero::nuovoCodice();
		
		$query = "
					INSERT INTO bordero( numeroDocumento )
					VALUES( '{$numeroDocumento}' )
		";
		mysql_query($query);
		
		return new Bordero( mysql_insert_id() );
		
	}
	
	static function elenco( $parametro = null ){
		
		$borderos = array();
		
		$delimiter = Bordero::DELIMITER;

		if ( !is_null($parametro) ) {
			
			$query = "
						SELECT id, {$parametro}
						FROM bordero
						ORDER BY {$parametro}
			";
			$resource = mysql_query($query);
			
			while ( $info = mysql_fetch_assoc($resource) ) {
				extract( $info );
				$borderos[$id] = $$parametro;
			}
			
		}else{
			
			$query = "
						SELECT id
						FROM bordero
						ORDER BY 	CONVERT( SUBSTRING_INDEX(numeroDocumento,'{$delimiter}',-1), UNSIGNED INTEGER ) DESC,
									CONVERT( SUBSTRING_INDEX(numeroDocumento,'{$delimiter}',1), UNSIGNED INTEGER ) DESC
			";
			$resource = mysql_query($query);
						
			while ( $info = mysql_fetch_assoc($resource) ) {
				$borderos[] = new Bordero( $info['id'] );
			}
				
		}
		
		return $borderos;
		
	}
	
	static function elimina( $id ){
		
		$success = true;
		
		mysql_query("START TRANSACTION");
		
		#elimino il bordero
		$query = "
					DELETE FROM bordero
					WHERE id = {$id}
		";
		$success = $success && mysql_query($query);
		
		if ( $success ) {
			mysql_query("COMMIT");
		}else{
			mysql_query("ROLLBACK");
		}
		
		return $success;
		
	}
	
	static function nuovoCodice(){
		
		$delimiter = Bordero::DELIMITER;
		
		#il codice è incrementale per anno
		$anno = date( 'Y' );
		
		#recupero dal database il numero di bordero con quest'anno
		$query = "
					SELECT MAX( CONVERT( SUBSTRING_INDEX( numeroDocumento, '{$delimiter}', 1 ), UNSIGNED INTEGER)  ) AS counter
					FROM bordero
					WHERE SUBSTRING_INDEX( numeroDocumento, '{$delimiter}', -1 ) LIKE '{$anno}'
		";

		$resource = mysql_query($query);
		$fetch = mysql_fetch_assoc($resource);
		$incrementale = $fetch['counter'] + 1;
		
		return "{$incrementale}{$delimiter}{$anno}";
		
	}
	
	public function codiceOrdinamento(){
		
		$codicePaddato = str_pad($this->get('numeroDocumento'), 10, "0", STR_PAD_LEFT);
		
		list( $numero, $anno ) = explode(Bordero::DELIMITER, $codicePaddato);
		
		$codiceDaOrdinamento = $anno.$numero;
		
		return $codiceDaOrdinamento; 
		
	}
	
	public function nomeBordero(){
		
		$estensioneFile = Bordero::ESTENSIONE_FILE;
		
		#compongo il nome del file del borderò
		$nome = '';
		
		$codice = $this->get('numeroDocumento');
		$codice = str_replace( Bordero::DELIMITER, '-', $codice );
		
		$nome .= Bordero::PREFISSO."{$codice}.{$estensioneFile}";
		
		return $nome;
		
	}
	
	public function salvaPDF(){
		
		$fornitore = new Fornitore( $this->get( 'IDFornitore', true ) );
		$trasporti = $this->get('IDTrasporti');
		$bordero = $this;
		
		include('./PDF_bordero.php');
		
	}
	
	public function numeroConsegne(){
		
		$IDTrasporto = json_decode( $this->get( 'IDTrasporti', true ) );
		
		return Bordero::totaleConsegne( $IDTrasporto );
	}
	
	public function volumeTotale(){
		
		$IDTrasporto = json_decode( $this->get( 'IDTrasporti', true ) );
		
		return Bordero::totaleVolume( $IDTrasporto );
	}
	
	public function pesoTotale(){
		
		$IDTrasporto = json_decode( $this->get( 'IDTrasporti', true ) );
		
		return Bordero::totalePeso( $IDTrasporto );
	}
	
	/*
	#prima le ho scritte poi mi sono reso conto che non servono queste 3 funzioni :)
	public function totaleConsegneBordero(){
		return Bordero::totaleConsegne( $this->get( 'IDTrasporti', true ) );
	}
	
	public function totalePesoBordero(){
		return Bordero::totalePeso( $this->get( 'IDTrasporti', true ) );
	}
	
	public function totaleVolumeBordero(){
		return Bordero::totaleVolume( $this->get( 'IDTrasporti', true ) );
	}
	*/
	
	public function totaleImballaggi(){
		
		$IDTrasporti = $this->get( 'IDTrasporti', true );
		$IDTrasporti = json_decode( $IDTrasporti );
		
		$totale = 0;
		
		foreach ( $IDTrasporti as $IDTrasporto ) {
			$prospetto = new ProspettoTrasporto( $IDTrasporto );
			$totale += $prospetto->get('numeroImballaggi');
		}
		
		return $totale;
		
	}
	
	static function totaleConsegne( $IDTrasporti = array() ){
		
		$totale = count( $IDTrasporti );
		
		return $totale;
		
	}
	
	static function totalePeso( $IDTrasporti = array() ){
		
		$totale = 0;
		
		if ( count($IDTrasporti) > 0 ) {
			foreach ( $IDTrasporti as $IDTrasporto ) {
				$prospetto = new ProspettoTrasporto( $IDTrasporto );
				$totale += $prospetto->get('peso');
			}
		}
		
		return $totale;
		
	}
	
	static function totaleVolume( $IDTrasporti = array() ){
		
		$totale = 0;
		
		if ( count($IDTrasporti) > 0 ) {
			foreach ( $IDTrasporti as $IDTrasporto ) {
				$prospetto = new ProspettoTrasporto( $IDTrasporto );
				$totale += $prospetto->volume();
			}			
		}
		
		return $totale;
		
	}
	
	public function filename(){
		return Bordero::PATH.$this->nomeBordero();
	}
	
	private function init( $id ){
		
		if ( is_null($id) || $id == 0 ) {
			$this->info = array();
			$this->id = null;
		}else{
			
			#recupero le informazioni di questa news
			$query = "
						SELECT *, COUNT(id) AS counter
						FROM bordero
						WHERE id = {$id}
			";
			$this->risorse = mysql_query($query);
			$this->info = mysql_fetch_assoc($this->risorse);
			
			if ( $this->info['counter'] == 0 ) {
				return false;
			}
			
			$this->id = $id;
				
		}
		
	}

}

/*
	
	SELECT id, cod_fiscale as codiceFiscale, CONCAT('{"tel1":"',tel1,'","tel2":"',tel2,'","fax":"',fax,'","email":"',email,'","sito":"',sito,'"}') AS contatti, 0.0 as costoMetroQuadro, 0.0 as facchinaggio, indirizzo, modalita_pagamento as modalitaPagamento, nome_cognome as nominativo, 0.0 as orariTassativi, piva as partitaIVA, percentuale_ricarico as percentualeRicarico, '' as personaProvvigione, '{}' as prezzi, '{"percentuale":0,"cifra":0}' as provvigioneServizioContrassegno, r_sociale as ragioneSociale, '' as recapitoContrassegno, banca, 0.0 as sosteOra, '[]' as strumenti, citta, persona_riferimento as riferimentoBanca FROM `scheda_cliente` ORDER BY id
	
*/










