<?

class Fattura{

	private $risorse;
	private $info;
	private $id;
	
	const DELIMITER = '/';

	function __construct( $id ){
		$this->init( $id );
	}

	public function get( $key, $raw = false ) {

		$valore = $this->info[$key];

		if ( $raw ) {
			return $valore;
		}

		switch ( $key ) {
			
			case 'scadenza':{
				
				$valore = dataDaUSA( $valore );
				if ( $valore == '01/01/1970' ) {
					$valore = '';
				}
				
				break;
			}
			
			case 'IDProspetti':{
				
				$valore = json_decode( $valore, true );
				if ( is_null($valore) ) {
					$valore = array();
				}else{
					
					$ids = $valore;
					$valore = array();
					foreach ( $ids as $id ) {
						$valore[] = new Prospetto( $id );
					}
						
				}
				
				break;
			}
			
			case 'numeroDocumento':{
				
				if ( $valore == '' || is_null($valore) ) {
					$valore = Fattura::nuovoCodice();
				}
			
				break;
			}
			
			case 'data':{
				
				if ( $valore == '' ) {
					$valore = date('d/m/Y');
				}else{
					$valore = dataDaUSA( $valore );
					if ( $valore == '01/01/1970' ) {
						$valore = '';
					}
				}
			
				break;
			}
			
			case 'IDCliente':{
				
				$valore = new Cliente( $valore );
			
				break;
			}
			
			case 'prezzo':
			case 'imponibile':{
				
				if ( is_null($valore) || $valore == 0 || $valore == '' ) {
					$valore = $this->totaleDaProspetti();
				}
			
				break;
			}
			
			case 'iva':{
				
				if ( $valore == '' ) {
					$valore = Iva::$listaIva[0];
				}
				
				break;
			}
			
		}

		return $valore;

	}

	public function set( $key, $valore ) {
			
		switch ( $key ) {
		
			case 'IDProspetti':{
				
				arrayIntVal( $valore );
				$valore = json_encode( $valore );
				
				break;
			}
			
			case 'scadenza':
			case 'data':{
				
				$valore = dataUSA( $valore );
				
				break;
			}
			
		}
		
		$query = "
			UPDATE fatture
			SET {$key} = '{$valore}'
			WHERE id = {$this->get('id')}
		";
		mysql_query($query);
		
		$this->info[$key] = $valore;
		
	}
		
	static function nuovo( $IDProspetti = array(), $IDCliente ){
		
		arrayIntVal( $IDProspetti );
		$IDProspetti = json_encode( $IDProspetti );
		
		$query = "
					INSERT INTO fatture( IDProspetti, IDCliente, saldata )
					VALUES( '{$IDProspetti}', {$IDCliente}, 0 )
		";
		mysql_query($query);
		
		$fattura = new Fattura( mysql_insert_id() );
		
		$prospetti = $fattura->get('IDProspetti');
		foreach ( $prospetti as $prospetto ) {
			$prospetto->set( 'fatturato', 1 );
		}
		
		return $fattura;
		
	}
	
	static function nuovoCodice( $anno = null ){

		$delimiter = Fattura::DELIMITER;
		
		#il codice è incrementale per anno
		if ( is_null($anno) ) {
			#se è nullo recupero l'anno di oggi
			$anno = date( 'Y' );
		}
		
		#recupero dal database il numero di prospetti con quest'anno
		$query = "
					SELECT MAX( CONVERT( SUBSTRING_INDEX( numeroDocumento, '{$delimiter}', 1 ), UNSIGNED INTEGER)  ) AS counter
					FROM fatture
					WHERE SUBSTRING_INDEX( numeroDocumento, '{$delimiter}', -1 ) LIKE '{$anno}'
		";
		$resource = mysql_query($query);
		$fetch = mysql_fetch_assoc($resource);
		$incrementale = $fetch['counter'] + 1;
		
		return "{$incrementale}{$delimiter}{$anno}";
		
	}
	
	static function elenco( $parametro = null ){
		
		$fatture = array();
		
		$delimiter = Fattura::DELIMITER;
		
		if ( !is_null($parametro) ) {
			
			$query = "
						SELECT id, {$parametro}
						FROM fatture
						ORDER BY {$parametro}
			";
			$resource = mysql_query($query);
			
			while ( $info = mysql_fetch_assoc($resource) ) {
				extract( $info );
				$fatture[$id] = $$parametro;
			}
			
		}else{
			
			$query = "
						SELECT id
						FROM fatture
						ORDER BY 	CONVERT( SUBSTRING_INDEX(numeroDocumento,'{$delimiter}',-1), UNSIGNED INTEGER ) DESC,
									CONVERT( SUBSTRING_INDEX(numeroDocumento,'{$delimiter}',1), UNSIGNED INTEGER ) DESC
			";
			$resource = mysql_query($query);
						
			while ( $info = mysql_fetch_assoc($resource) ) {
				$fatture[] = new Fattura( $info['id'] );
			}
				
		}
		
		return $fatture;
		
	}
	
	static function elimina( $id ){
		
		$fattura = new Fattura( $id );
		$prospetti = $fattura->get('IDProspetti');
		foreach ( $prospetti as $prospetto ) {
			$prospetto->set( 'fatturato', 0 );
		}
		$success = true;
		
		mysql_query("START TRANSACTION");
		
		#recupero i prospetti di questa fattura
		$prospetti = $fattura->get('IDProspetti');
		foreach ( $prospetti as $prospetto ) {
			$prospetto->set( 'fatturato', 0 );
		}
		
		#elimino la fattura
		$query = "
					DELETE FROM fatture
					WHERE id = {$id}
		";
		$success = $success && mysql_query($query);
		
		if ( $success ) {
			mysql_query("COMMIT");
		}else{
			mysql_query("ROLLBACK");
		}
		
		return $success;
		
	}
	
	public function totaleDaProspetti( $prospetti = null ){
		
		$totale = 0;
		
		if ( is_null($prospetti) ) {
			$prospetti = $this->get('IDProspetti');
		}
		
		foreach ( $prospetti as $prospetto ) {
			$totale += $prospetto->totale();
		}
		
		return $totale;
		
	}
	
	#
	public function calcolaImponibileFattura(){
		return Fattura::calcolaImponibile(
			$this->get('prezzo'),
			$this->get('speseEsentiIVA'),
			$this->get('speseExtra'),
			$this->get('speseIncasso'),
			$this->get('bolli'),
			$this->get('varie')
		);
	}
	
	public function calcolaTotaleFattura(){
		
		$calcolaTotale = Fattura::calcolaTotale(
			$this->calcolaImponibileFattura(),
			$this->get('importoSconto'),
			$this->get('percentualeSconto')
		);
		
		return $calcolaTotale;
		
	}
	
	public function calcolaTotaleFatturaConIVA(){
		
		$totaleConIVA = Fattura::calcolaTotaleConIVA(
			$this->get('imponibile'),
			$this->get('iva'),
			$this->get('speseEsentiIVA')
		);
		
		return $totaleConIVA;
		
	}
	
	public function scontoFattura(){
		return Fattura::sconto(
			$this->get('imponibile'),
			$this->get('importoSconto'),
			$this->get('percentualeSconto')
		);
	}
	
	
	static function calcolaImponibile( $prezzo, $speseEsentiIVA, $speseExtra, $speseIncasso, $bolli, $varie ){

		$imponibile = $prezzo;
		
		$imponibile += $speseEsentiIVA;
		$imponibile += $speseExtra;
		$imponibile += $speseIncasso;
		$imponibile += $bolli;
		$imponibile += $varie;
		
		return $imponibile;
		
	}
	
	static function calcolaTotale( $imponibile, $importoSconto, $percentualeSconto ){
		
		$totale = 0;
		
		$sconto = Fattura::sconto( $imponibile, $importoSconto, $percentualeSconto );
		
		$totale = $imponibile - $sconto;
		
		return $totale;
		
	}
	
	static function calcolaTotaleConIVA( $imponibile, $iva, $speseEsentiIVA ){
		
		$totale = 0;
		
		#calcolo il totale dell'iva sull'imponibile
		$totaleIVA = ( ($imponibile - $speseEsentiIVA) * $iva ) / 100;
		
		$totale = $imponibile + $totaleIVA;
		
		return $totale;
		
	}
	
	static function sconto( $importo, $importoSconto, $percentualeSconto ){
		
		$sconto = 0;
		
		#calcolo lo sconto sull'importo
		$scontoCalcolato = ( $importo * $percentualeSconto ) / 100;
		
		if ( $scontoCalcolato == 0 && $importoSconto != 0 ) {
			return $importoSconto;
		}
		if ( $scontoCalcolato != 0 && $importoSconto == 0 ) {
			return $scontoCalcolato;
		}
		
		$sconto = $scontoCalcolato > $importoSconto ? $importoSconto : $scontoCalcolato;
		
		return $sconto;
		
	}
	
	static function salvaPDF(){
		
		#salvataggio PDF miciomiao
		
	}
	
	static function annoMinoreDiFatturazione(){
		
		$delimiter = Prospetto::DELIMITER;
		
		$query = "
		
					SELECT MIN(annoDocumento) AS anno
					FROM ( 
							SELECT CONVERT( SUBSTRING_INDEX(data,'{$delimiter}',1), UNSIGNED INTEGER ) AS annoDocumento
							FROM fatture
					) AS Tabella
		
		";

		$resource = mysql_query($query);
		$fetch = mysql_fetch_assoc($resource);
		
		$anno = intval( $fetch['anno'] );
		
		return $anno;
		
	}
	
	public function annoFattura(){
		
		$data = $this->get('data');
		
		list( $giorno, $mese, $annoFatturazione ) = explode( Fattura::DELIMITER, $data );
		
		return $annoFatturazione;
		
	}
	
	private function init( $id ){
		
		if ( is_null($id) ) {
			$this->info = array();
			$this->id = null;
		}else{
			
			#recupero le informazioni di 
			$query = "
						SELECT *, COUNT(id) AS counter
						FROM fatture
						WHERE id = {$id}
			";
			$this->risorse = mysql_query($query);
			$this->info = mysql_fetch_assoc($this->risorse);
			
			if ( $this->info['counter'] == 0 ) {
				return false;
			}
	
			$this->id = $id;
				
		}
		
	}

}












