<?

class Mezzo{

	private $risorse;
	private $info;
	private $id;
	
	const KM_COSTO_FISSO = 50;

	function __construct( $id ){
		$this->init( $id );
	}

	public function get( $key, $raw = false ) {

		$valore = $this->info[$key];

		if ( $raw ) {
			return $valore;
		}

		switch ( $key ) {
			
			case 'dataBollo':
			case 'dataAssicurazione':{
				
				$valore = dataDaUSA( $valore );
				if ( $valore == '01/01/1970' ) {
					$valore = '';
				}
				
				break;
			}
			
			case 'KMCostoFisso':{
				
				if ( $valore == 0 || $valore == '' ) {
					$valore = 50;
				}
				
				break;
			}
			
			case 'costoKM':{
				
				$valore = floatval($valore);
				
				break;
			}
			
			case 'prezzi':{
				
				$valore = json_decode( $valore, true );
				
				break;
			}
			
		}

		return $valore;

	}

	public function set( $key, $valore ) {
			
		switch ( $key ) {
			
			case 'dataBollo':
			case 'dataAssicurazione':{
				
				$valore = dataUSA( $valore );
				
				break;
			}
			
			case 'prezzi':{
			
				if ( count($valore) > 0 ) {
					foreach ( $valore as &$prezzo ) {
						$prezzo['KM'] = $prezzo['KM'] == '' ? 0 : $prezzo['KM'];
					}					
				}
				
				$valore = json_encode( $valore );
				$valore = str_replace("\\'", "'", $valore);
			
				break;
			}
				
		}
		
		$query = "
			UPDATE mezzi
			SET {$key} = '{$valore}'
			WHERE id = {$this->get('id')}
		";
		mysql_query($query);
		
		$this->info[$key] = $valore;
		
	}
		
	static function nuovo(){
		
		$query = "
					INSERT INTO mezzi()
					VALUES()
		";
		mysql_query($query);
		
		return new Mezzo( mysql_insert_id() );
		
	}
	
	static function elenco( $parametro = null ){
		
		$mezzi = array();
		
		if ( !is_null($parametro) ) {
			
			$query = "
						SELECT id, {$parametro}
						FROM mezzi
						ORDER BY {$parametro}
			";
			$resource = mysql_query($query);
			
			while ( $info = mysql_fetch_assoc($resource) ) {
				extract( $info );
				$mezzi[$id] = $$parametro;
			}
			
		}else{
			
			$query = "
						SELECT id
						FROM mezzi
						ORDER BY id
			";
			$resource = mysql_query($query);
						
			while ( $info = mysql_fetch_assoc($resource) ) {
				$mezzi[] = new Mezzo( $info['id'] );
			}
				
		}
		
		return $mezzi;
		
	}
	
	static function elimina( $id ){
		
		$success = true;
		
		mysql_query("START TRANSACTION");
		
		#elimino il mezzo
		$query = "
					DELETE FROM mezzi
					WHERE id = {$id}
		";
		$success = $success && mysql_query($query);
		
		if ( $success ) {
			mysql_query("COMMIT");
		}else{
			mysql_query("ROLLBACK");
		}
		
		return $success;
		
	}
	
	static function selectTarghe( $mezzoSelezionato = 0, $scegli = false, $id = 'IDMezzo', $class = '' ){
		
		$html = '';
		
		$html .= "<select id='{$id}' class='form-control {$class}'>";
		
		if ( $scegli ) {
			$html .= "<option value='0'>Seleziona un mezzo di trasporto</option>";
		}
		
		foreach ( Mezzo::elenco( 'targa' ) as $IDMezzo => $targa ) {
			$selected = $mezzoSelezionato == $IDMezzo ? ' selected="selected" ' : '  ';
			$html .= "<option value='{$IDMezzo}' {$selected}>{$targa}</option>";	
		}
		
		$html .= '</select>';
		
		return $html;
		
	}
	
	private function init( $id ){
		
		if ( is_null($id) ) {
			$this->info = array();
			$this->id = null;
		}else{
			
			#recupero le informazioni di questa news
			$query = "
						SELECT *, COUNT(id) AS counter
						FROM mezzi
						WHERE id = {$id}
			";
			$this->risorse = mysql_query($query);
			$this->info = mysql_fetch_assoc($this->risorse);
			
			if ( $this->info['counter'] == 0 ) {
				return false;
			}
	
			$this->id = $id;
				
		}
		
	}
	
	public function scadenza(){
		
		$oggi = new DateTime( date('Y-m-d') );
		$differenzaBollo = new DateTime($this->get( 'dataBollo', true ));
		$differenzaAssicurazione = new DateTime( $this->get( 'dataAssicurazione', true )) ;
		
		$differenzaBollo = $differenzaBollo->format('U') - $oggi->format('U');
		$differenzaAssicurazione = $differenzaAssicurazione->format('U') - $oggi->format('U');
		
		$massimo = min( $differenzaBollo, $differenzaAssicurazione );
		
		$giorni = $massimo / (3600*24);

		return $giorni;
		
	}
	
	public function calcolaCostoKM( $KM ){
		
		$costoKM = $this->get('costoKM');
		
		return $KM * $costoKM;
		
	}

}












