<?

class ModalitaPagamento{

	const MODALITA_PAGAMENTO_RIBA = 'riba';
	const MODALITA_PAGAMENTO_RIBA_30 = 'riba 30 giorni';
	const MODALITA_PAGAMENTO_RIBA_60 = 'riba 60 giorni';
	const MODALITA_PAGAMENTO_RIBA_90 = 'riba 90 giorni';
	
	const MODALITA_PAGAMENTO_BONIFICO = 'bonifico bancario';
	const MODALITA_PAGAMENTO_BONIFICO_30 = 'bonifico 30 giorni';
	const MODALITA_PAGAMENTO_BONIFICO_60 = 'bonifico 60 giorni';
	const MODALITA_PAGAMENTO_BONIFICO_90 = 'bonifico 90 giorni';
	
	const MODALITA_PAGAMENTO_ASSEGNO = 'assegno';
	const MODALITA_PAGAMENTO_RIMESSA_DIRETTA = 'rimessa diretta';

	function __construct(){
	}

	static function modalitaDiPagamento(){
		
		$modalita = array(
			
			ModalitaPagamento::MODALITA_PAGAMENTO_RIBA,
			ModalitaPagamento::MODALITA_PAGAMENTO_RIBA_30,
			ModalitaPagamento::MODALITA_PAGAMENTO_RIBA_60,
			ModalitaPagamento::MODALITA_PAGAMENTO_RIBA_90,
			
			ModalitaPagamento::MODALITA_PAGAMENTO_BONIFICO,
			ModalitaPagamento::MODALITA_PAGAMENTO_BONIFICO_30,
			ModalitaPagamento::MODALITA_PAGAMENTO_BONIFICO_60,
			ModalitaPagamento::MODALITA_PAGAMENTO_BONIFICO_90,
			
			ModalitaPagamento::MODALITA_PAGAMENTO_ASSEGNO,
			ModalitaPagamento::MODALITA_PAGAMENTO_RIMESSA_DIRETTA
			
		);
		
		asort( $modalita );
		
		return $modalita;
		
	}
	
	public function giorni( $modalitaDiPagamento ){
		
		$giorni = false;
				
		switch ( $modalitaDiPagamento ) {
			
			case ModalitaPagamento::MODALITA_PAGAMENTO_BONIFICO_30:
			case ModalitaPagamento::MODALITA_PAGAMENTO_RIBA_30:{
				$giorni = 30;
				break;
			}
			
			case ModalitaPagamento::MODALITA_PAGAMENTO_BONIFICO_60:
			case ModalitaPagamento::MODALITA_PAGAMENTO_RIBA_60:{
				$giorni = 60;
				break;
			}
			
			case ModalitaPagamento::MODALITA_PAGAMENTO_BONIFICO_90:
			case ModalitaPagamento::MODALITA_PAGAMENTO_RIBA_90:{
				$giorni = 90;
				break;
			}
			
		}
		
		return $giorni;
		
	}

}












