<?

class Prospetto{

	private $risorse;
	private $info;
	private $id;
	
	private $prospettiAssociati = array();
	
	const PROSPETTO_TRASPORTO = 'trasporto';
	const PROSPETTO_NOLEGGIO = 'noleggio';
	const PROSPETTO_MAGAZZINO = 'magazzino';
	
	const PROSPETTO_TRASPORTO_SINGOLO = 'trasporto singolo';
	const PROSPETTO_TRASPORTO_MULTIPLO = 'trasporto multiplo';
	
	const DELIMITER = '/';

	function __construct( $id, $tipo = 'all' ){
		$this->init( $id, $tipo );
	}

	public function get( $key, $raw = false ) {
		
		$valore = $this->info[$key];

		if ( $raw ) {
			return $valore;
		}

		switch ( $key ) {
			
			case 'data':{
				
				$valore = dataDaUSA( $valore );
				if ( $valore == '01/01/1970' ) {
					$valore = '';
				}
				
				break;
			}
			
			case 'IDCliente':{
				
				$valore = new Cliente( $valore );
				
				break;
			}
							
			case 'codice':{

				if ( $valore == '' || is_null($valore) ) {
					$valore = Prospetto::nuovoCodice();
				}
				
				break;
			}
			
		}
		
		return $valore;

	}

	public function set( $key, $valore ) {
			
		switch ( $key ) {
			
			case 'data':{
				
				$valore = dataUSA( $valore );
				
				break;
			}
		
		}
		
		$query = "
			UPDATE prospetti
			SET {$key} = '{$valore}'
			WHERE id = {$this->get('id')}
		";
		mysql_query($query);
		
		$this->info[$key] = $valore;
		
	}
	
	static function nuovoCodice( $anno = null ){

		$delimiter = Prospetto::DELIMITER;
		
		#il codice è incrementale per anno
		if ( is_null($anno) ) {
			#se è nullo recupero l'anno di oggi
			$anno = date( 'Y' );
		}
		
		#recupero dal database il numero di prospetti con quest'anno
		$query = "
					SELECT MAX( CONVERT( SUBSTRING_INDEX( codice, '{$delimiter}', 1 ), UNSIGNED INTEGER)  ) AS counter
					FROM prospetti
					WHERE SUBSTRING_INDEX( codice, '{$delimiter}', -1 ) LIKE '{$anno}'
		";
		$resource = mysql_query($query);
		$fetch = mysql_fetch_assoc($resource);
		$incrementale = $fetch['counter'] + 1;
		
		return "{$incrementale}{$delimiter}{$anno}";
		
	}
		
	static function nuovo( $tipo ){
		
		$query = "
					INSERT INTO prospetti( tipo, fatturato )
					VALUES( '{$tipo}', 0 )
		";
		mysql_query($query);
		
		return new Prospetto( mysql_insert_id(), $tipo );
		
	}
	
	static function elenco( $listino = false, $tipoFiltro = null ){
		
		$delimiter = Prospetto::DELIMITER;
		
		$where = '';
		if ( $listino ) {
			$where = ' WHERE listino = 1 ';
		}else{
			$where = ' WHERE listino = 0 ';
		}
		
		
		$query = "
					SELECT id, tipo
					FROM prospetti
					{$where}
					ORDER BY 	CONVERT( SUBSTRING_INDEX(codice,'{$delimiter}',-1), UNSIGNED INTEGER ) DESC,
								CONVERT( SUBSTRING_INDEX(codice,'{$delimiter}',1), UNSIGNED INTEGER ) DESC
								
		";
		$resource = mysql_query($query);
		
		$prospetti = array();
		
		while ( $info = mysql_fetch_assoc($resource) ) {
			
			extract( $info );
			
			if ( !is_null($tipoFiltro) && $tipoFiltro != $tipo ) {
				continue;
			}
			
			$prospetti[] = new Prospetto( $id, $tipo );
			
		}
		
		return $prospetti;
		
	}
	
	public function totale(){
		
		$totale = 0;
		
		$prospettiAssociati = $this->prospettiAssociati();
		#per ogni prospetto associato recupero il totale
		foreach ( $prospettiAssociati as $prospettoAssociato ) {
			$totale += $prospettoAssociato->totaleProspetto();
		}
		
		return floatval( $totale );
		
	}
	
	public function aggiorna( $arrayInfo ){
		
		extract( $arrayInfo );
		
		mysql_query('START_TRANSACTION');
		$this->set( 'codice', $codice );
		$this->set( 'data', $data );
		$this->set( 'IDCliente', $IDCliente );
		$this->set( 'numeroOrdine', $numeroOrdine );
		mysql_query('COMMIT');
		
	}
	
	public function icona(){
		
		$html = '';
		
		#recupero il tipo di prospetto
		$tipo = $this->get('tipo');
		
		switch ( $tipo ) {
			
			case 'trasporto':{
				
				$numeroTrasporti = count( $this->prospettiAssociati() );
				#se sono trasporti multipli ne metto 3
				if ( $numeroTrasporti > 1 ) {
					$html .= '<i class="fa fa-truck iconaProspetto"></i><i class="fa fa-truck"></i><i class="fa fa-truck"></i><span class="numeroTrasporti">'.$numeroTrasporti.'</span>';	
				}else{
					$html .= '<i class="fa fa-truck iconaProspetto"></i>';	
				}
				
				break;
			}
			
			case 'magazzino':{
				$html .= '<i class="fa fa-dropbox iconaProspetto"></i>';
				break;
			}
			
			case 'noleggio':{
				$html .= '<i class="fa fa-exchange iconaProspetto"></i>';
				break;
			}
			
		}
		
		return $html;
		
	}
	
	public function prospettiAssociati(){
		
		return $this->prospettiAssociati;
		
	}
	
	public function tipiProspetti(){
		
		$tipi = array(
			Prospetto::PROSPETTO_TRASPORTO,
			Prospetto::PROSPETTO_NOLEGGIO,
			Prospetto::PROSPETTO_MAGAZZINO
		);
		
		asort( $tipi );
		
		return $tipi;
		
	}
	
	public function elimina(){
		
		$success = true;
		#elimino i prospetti associati
		foreach ( $this->prospettiAssociati() as $prospetto ) {
			$success = $success && $prospetto->elimina();
			
		}
		
		#se c'è stato un errore nell'eliminazione di un prospetto lo segnalo
		if ( !$success ) {
			return false;
		}
		
		#elimino me stesso
		
		mysql_query("START TRANSACTION");
		
		#elimino il prospetto
		$query = "
					DELETE FROM prospetti
					WHERE id = {$this->get('id')}
		";
		$success = $success && mysql_query($query);
		
		if ( $success ) {
			mysql_query("COMMIT");
		}else{
			mysql_query("ROLLBACK");
		}
		
		return $success;
		
	}
	
	public function prospettiAssociatiNonBorderati(){
		
		$query = "
					SELECT id
					FROM prospetti_trasporto
					WHERE 	IDProspetto = {$this->get('id')} AND
							borderato = 0
		";
		$resource = mysql_query($query);
		
		$prospettiAssociati = array();
		while ( $info = mysql_fetch_assoc($resource) ) {
			$prospettiAssociati[] = new ProspettoTrasporto( $info['id'] );
		}
		
		return $prospettiAssociati;
		
	}
	
	public function codiceOrdinamento(){
		
		$codicePaddato = str_pad($this->get('codice'), 10, "0", STR_PAD_LEFT);
		
		list( $numero, $anno ) = explode(Prospetto::DELIMITER, $codicePaddato);
		
		$codiceDaOrdinamento = $anno.$numero;
		
		return $codiceDaOrdinamento; 
		
	}
	
	private function init( $id, $tipo ){
		
		if ( is_null($id) || $id == '' ) {
			$this->info = array( "tipo" => $tipo );
			$this->id = null;
			$this->prospettiAssociati = array();
		}else{
			
			#recupero le informazioni
			$query = "
						SELECT *, COUNT(id) AS counter
						FROM prospetti
						WHERE id = {$id}
			";
			$this->risorse = mysql_query($query);
			$this->info = mysql_fetch_assoc($this->risorse);
			
			if ( $this->info['counter'] == 0 ) {
				return false;
			}
	
			$this->id = $id;
			
			#ora in base al tipo di prospetto devo creare una classe che avrà le informazioni di quel prospetto specifico ... ... WTF????
			foreach ( $this->tipiProspetti() as $tipoProspetto ) {
				
				#cerco questo ID nelle tabelle di ogni tipo
				$query = "
							SELECT id
							FROM prospetti_{$tipoProspetto}
							WHERE IDProspetto = {$this->id}
				";
				$resource = mysql_query($query);
				if ( mysql_affected_rows() > 0 ) {
					
					while ( $singoloProspetto = mysql_fetch_assoc($resource) ) {
						extract( $singoloProspetto );
						switch ( $tipoProspetto ) {
							
							case Prospetto::PROSPETTO_MAGAZZINO :{
								$this->prospettiAssociati[] = new ProspettoMagazzino( $id );
								break;
							}
							
							case Prospetto::PROSPETTO_NOLEGGIO :{
								$this->prospettiAssociati[] = new ProspettoNoleggio( $id );
								break;
							}
							
							case Prospetto::PROSPETTO_TRASPORTO :{
								$this->prospettiAssociati[] = new ProspettoTrasporto( $id );
								break;
							}
							
						}
					
					}
						
				}
				
			}
			
		}
		
	}

}












