<?

class ProspettoNoleggio{

	private $risorse;
	private $info;
	private $id;
	
	const TYPE = Prospetto::PROSPETTO_NOLEGGIO;
	const IVA = 22;

	function __construct( $id ){
		$this->init( $id );
	}

	public function get( $key, $raw = false ) {

		$valore = $this->info[$key];

		if ( $raw ) {
			return $valore;
		}

		switch ( $key ) {
			
			case 'KMIllimitati':{
				
				$valore = (Bool)$valore;
				
				break;
			}
			
			case 'IDMezzo':{
			
				$valore = new Mezzo( $valore );
			
				break;
			}
			
		}

		return $valore;

	}

	public function set( $key, $valore ) {
			
		switch ( $key ) {
			
		}
		
		$query = "
			UPDATE prospetti_noleggio
			SET {$key} = '{$valore}'
			WHERE id = {$this->get('id')}
		";
		mysql_query($query);
		
		$this->info[$key] = $valore;
		
	}
		
	static function nuovo( $IDProspetto ){
		
		$query = "
					INSERT INTO prospetti_noleggio( IDProspetto )
					VALUES( {$IDProspetto} )
		";
		mysql_query($query);
		
		return new ProspettoNoleggio( mysql_insert_id() );
		
	}
	
	public function elimina(){
		
		$success = true;
		
		mysql_query("START TRANSACTION");
		
		#elimino il prospetto
		$query = "
					DELETE FROM prospetti_noleggio
					WHERE id = {$this->get('id')}
		";
		$success = $success && mysql_query($query);
		
		if ( $success ) {
			mysql_query("COMMIT");
		}else{
			mysql_query("ROLLBACK");
		}
		
		return $success;
		
	}
	
	private function init( $id ){
		
		if ( is_null($id) ) {
			$this->info = array();
			$this->id = null;
		}else{
			
			#recupero le informazioni di questa news
			$query = "
						SELECT *, COUNT(id) AS counter
						FROM prospetti_noleggio
						WHERE id = {$id}
			";
			$this->risorse = mysql_query($query);
			$this->info = mysql_fetch_assoc($this->risorse);
			
			if ( $this->info['counter'] == 0 ) {
				return false;
			}
	
			$this->id = $id;
				
		}
		
	}
	
	public function form(){
		
		$prospettoNoleggio = $this;
		include( "./inc/form_prospetto_noleggio.php" );
		
	}
	
	public function KMDisponibili(){
		
		return ProspettoNoleggio::KMDisponibiliProspetto(
			$this->get('km'),
			$this->get('giorni')
		);
		
	}
	
	
	public function totaleProspetto(){
		
		$totale = $this->get('totaleProspetto');
		$totale = floatval($totale);
		
		return $totale;
		
	}
	
	public function totaleProspettoConIva(){
		
		$totale	= $this->get('totaleProspetto');
		$iva 	= $this->get('iva');
		
		return ProspettoNoleggio::totaleConIva( $totale, $iva );
		
	}
	
	
	
	
	static function calcolaPrezzo( $giorni, $prezzo ) {
		
		return $giorni * $prezzo;
		
	}
	
	static function prezzoReale( $prezzoCalcolato, $prezzoConcordato ) {
		
		if ( $prezzoConcordato == 0 || is_null($prezzoConcordato) ) {
			return $prezzoCalcolato;
		}
		
		return $prezzoConcordato;
		
	}
	
	static function prezzoFinale( $prezzoVero, $KMDisponibili, $KMDiRientro, $IDMezzo, $KMIllimitati ){
		
		$KMDiRientro = floatval($KMDiRientro);
		$KMIllimitati = $KMIllimitati == 'true';
		
		#faccio questo solo se non c'è l'illimitato e se $kmdirientro è diverso da 0
		$prezzoFinale = $prezzoVero; #altrimenti imposto il prezzo finale al prezzo calcolato/concordato
		
		if ( $KMDiRientro != 0 && !$KMIllimitati && ($KMDiRientro > $KMDisponibili) ) {
			
			$KMAggiuntivi = $KMDiRientro - $KMDisponibili;
			
			#per i chilometri aggiuntivi calcolo il prezzo in base al mezzo
			$mezzo = new Mezzo( $IDMezzo );
			
			$prezzoKMAggiuntivi = $mezzo->calcolaCostoKM( $KMAggiuntivi );
			
			$prezzoFinale = $prezzoVero + $prezzoKMAggiuntivi;
			
		}
		
		return $prezzoFinale;
		
	}
	
	static function totaleConIva( $totale ){
		
		$valoreIva = ( ProspettoNoleggio::IVA / 100 ) * $totale;
		
		return $totale + $valoreIva;
		
	}
	
	static function KMDisponibiliProspetto( $km, $giorni ){
		
		return $km * $giorni;
		
	}
	
}








