<?

class ProspettoTrasporto{

	private $risorse;
	private $info;
	private $id;
	
	const TYPE = Prospetto::PROSPETTO_TRASPORTO;

	function __construct( $id ){
		$this->init( $id );
	}

	public function get( $key, $raw = false ) {
		
		$valore = $this->info[$key];

		if ( $raw ) {
			return $valore;
		}

		switch ( $key ) {
			
			case 'strumenti':{
				
				$valore = json_decode( $valore, true );
				if ( is_null($valore) ) {
					$valore = array();
				}
				
				break;
			}
			
			case 'dimensioni':{
				
				$valore = json_decode( $valore, true );
				if ( is_null($valore) ) {
					$valore = array(
						"base" => 0,
						"altezza" => 0,
						"profondita" => 0,
					);
				}
				
				break;
			}
			
			case 'IDCittaDa':
			case 'IDCittaA':{
				
				$valore = new Citta( $valore );
				
				break;
			}
			
			case 'peso':
			case 'prezzo':{
				
				$valore = floatval($valore);
				
				break;
			}
			
			case 'id':{
				
				if ( is_null($valore) ) {
					$valore = 0;
				}
				
				break;
			}
			
			case 'assicurazione':{
				
				$valore = (bool)$valore;
				
				break;
			}
			
		}

		return $valore;

	}

	public function set( $key, $valore ) {
			
		switch ( $key ) {
		
			case 'strumenti':
			case 'dimensioni':{
				
				$valore = json_encode( $valore );
				
				break;
			}
			
			case 'iva':
			case 'assicurazione':
			case 'servizioContrassegno':
			case 'sosteOraNumero':{
				
				if ( $valore == 'true' ) {
					$valore = 1;
				}elseif ( $valore == 'false' ) {
					$valore = 0;
				}
				
				$valore = (int)$valore;
				
				break;
			}
			
			case 'totaleSpeseAccessorie':
			case 'sosteOraValore':
			case 'facchinaggio':
			case 'prezzoConcordato':
			case 'prezzo':
			case 'orariTassativi':
			case 'peso':{
				
				$valore = (float)$valore;
				
				break;
			}
			
		}
		
		$query = "
			UPDATE prospetti_trasporto
			SET {$key} = '{$valore}'
			WHERE id = {$this->get('id')}
		";
		$success = mysql_query($query);
		
		$this->info[$key] = $valore;
		
		return $success;
	}
		
	static function nuovo( $IDProspetto ){
		
		$query = "
					INSERT INTO prospetti_trasporto( IDProspetto, borderato )
					VALUES( {$IDProspetto}, 0 )
		";
		$success = mysql_query($query);
		
		if ( $success ) {
			return new ProspettoTrasporto( mysql_insert_id() );	
		}else{
			return false;
		}
		
	}
	
	public function elimina(){
		
		$success = true;
		
		mysql_query("START TRANSACTION");
		
		#elimino il prospetto
		$query = "
					DELETE FROM prospetti_trasporto
					WHERE id = {$this->get('id')}
		";
		$success = $success && mysql_query($query);
		
		if ( $success ) {
			mysql_query("COMMIT");
		}else{
			mysql_query("ROLLBACK");
		}
		
		return $success;
		
	}
	
	private function init( $id ){
		
		if ( is_null($id) ) {
			$this->info = array();
			$this->id = null;
		}else{
			
			#recupero le informazioni di questa news
			$query = "
						SELECT *, COUNT(id) AS counter
						FROM prospetti_trasporto
						WHERE id = {$id}
			";
			$this->risorse = mysql_query($query);
			$this->info = mysql_fetch_assoc($this->risorse);
			
			if ( $this->info['counter'] == 0 ) {
				return false;
			}
	
			$this->id = $id;
				
		}
		
	}
	
	public function IDCliente(){
		
		#recupero il prospetto a cui sono collegato
		$prospetto = new Prospetto( $this->get('IDProspetto'), null );
		return $prospetto->get( 'IDCliente', true );
		
	}
	
	public function cliente(){
		
		return new Cliente( $this->IDCliente() );
		
	}
	
	public function volume(){
		
		extract( $this->get('dimensioni') );
		
		$base = (float)$base;
		$altezza = (float)$altezza;
		$profondita = (float)$profondita;
		
		return $base * $altezza * $profondita;
		
	}
	
	static function pulsanti(){
		
		$html = '';
		
		$html = "
			
			<span class='glyphicon glyphicon-edit modificaProspettoTrasporto' aria-hidden='true' data-toggle='tooltip' title='Modifica trasporto'></span>
			<span class='glyphicon glyphicon-trash eliminaProspettoTrasporto' aria-hidden='true' data-toggle='tooltip' title='Elimina trasporto'></span>
			
		";
		
		return $html;
		
	}
	
	//CALCOLI sul singolo prospetto
	public function speseAccessorieProspetto(){
		
		#calcolo le spese accessorie
		$speseAccessorie = 0.0;
		
		#calcolo spese strumenti
		{
			$speseStrumenti = 0.0;
			#calcolo le spese degli strumenti selezionati
			foreach ( $this->get('strumenti') as $infoStrumento ) {
				extract( $infoStrumento );
				$speseStrumenti += floatval($costo);
			}	
		}
		$speseAccessorie += $speseStrumenti;
		
		#se c'è facchinaggio lo sommo
		$speseAccessorie += $this->get('facchinaggio');
		
		#numero soste
		$speseAccessorie += $this->get('sosteOraNumero') * $this->get('sosteOraValore');
		
		#ore tassative
		$speseAccessorie += $this->get('orariTassativi');
		
		#contrassegno
		$speseAccessorie += $this->get('servizioContrassegno');
		
		return (float)$speseAccessorie;
		
	}
	
	public function calcolaPrezzoProspetto( $key = null ){
		
		if ( $this->get( 'id', true ) == 0 ) return 0;
		
		$dimensioni = $this->get('dimensioni');
		
		$info = ProspettoTrasporto::calcolaPrezzo( $this->IDCliente(), $this->get( 'IDCittaA', true ), $this->get('peso'), $dimensioni['base'], $dimensioni['altezza'], $dimensioni['profondita'] );
		
		if ( is_null($key) ) {
			return $info;
		}else{
			return $info[$key];
		}
		
	}
	
	public function totaleProspetto(){
		if ( $this->get( 'id', true ) == 0 ) return 0;
		return ProspettoTrasporto::totale( $this->speseAccessorieProspetto(), $this->prezzoRealeProspetto() );
	}
	
	public function totaleProspettoConIva(){
		if ( $this->get( 'id', true ) == 0 ) return 0;
		return ProspettoTrasporto::totaleConIVA( $this->totaleProspetto(), $this->get('iva') );
	}
	
	public function calcoloAssicurazioneProspetto(){
		return ProspettoTrasporto::calcoloAssicurazione( $this->get('prezzo'), $this->get('assicurazione') );
	}
	
	public function prezzoRealeProspetto(){
		return ProspettoTrasporto::prezzoReale( $this->calcolaPrezzoProspetto('prezzo'), $this->get('prezzoConcordato') );
	}
	
	//CALCOLI generali
	static function calcolaPrezzo( $IDCliente, $IDCitta, $peso, $base, $altezza, $profondita ){
		
		if ( $IDCliente == 0 || ( $peso == 0 && $base == 0 ) ) {
			return array(
				'IDFornitori' => array(),
				'prezzo' => 0
			);
		}
		
		$cliente = new Cliente( $IDCliente );
		
		$peso = floatval($peso);
		$volume = floatval($base) * floatval($altezza) * floatval($profondita);
		
		#in teoria, se il peso non è nullo è perché devo fare il calcolo e quindi ho sicuramente anche base, altezza e profondità
		#recupero la tabella dei prezzi del cliente
		$citta = new Citta( $IDCitta );
		
		$IDFornitoriMigliori = array();
		
		#se questa città non ha la tratta allora il prezzo devo prenderlo dai fornbitori che servono quella regione
		if ( $citta->get('tratta') == 0 ) {
			
			#devo ciclare tutti i fornitori che hanno questa regione nella loro tabella prezzi
			#recupero la regione di questa citta
			$regione = $citta->get('regione');
			
			#recupero i fornitori che hanno questa regione nella tabella prezzi
			$fornitori = Fornitore::fornitoriPerRegione( $regione );
			
			$prezzoMigliore = 9999999999999999;
			#ciclo i fornitori e controllo i prezzi
			foreach ( $fornitori as $fornitore ) {
				
				$indicePeso = 0;
				$indiceVolume = 0;
					
				#recupero i prezzi di questo fornitore
				$prezzi = $fornitore->get('prezzi');
				
				#recupero i prezzi di questa regione
				$prezziRegione = $prezzi[$regione];
				
				#ciclo gli scaglioni della regione
				if ( count($prezziRegione) > 0 ) {

					foreach ( $prezziRegione as $indice => $scaglione ) {

						if ( $volume > floatval($scaglione['M3']) ) {
							$indiceVolume = $indice + 1;
						}

						if ( $peso > floatval($scaglione['KG']) ) {
							$indicePeso = $indice + 1;
						}
						
					}
				}
				
				#trovo l'indice più altro fra quello del volume e quello del peso
				$indicePrezzo = $indicePeso >= $indiceVolume ? $indicePeso : $indiceVolume;
				if ( $indicePrezzo >= count($prezziRegione) ) {
					$indicePrezzo = count($prezziRegione) - 1;
				}
				
				#ho trovato la posizione per il prezzo migliore per questa regione per questo fornitore
				$prezzoFornitore = floatval( $prezziRegione[$indicePrezzo]['euro'] );
				
				#lo confronto con il prezzo migliore
				if ( $prezzoFornitore < $prezzoMigliore ) {
					$prezzoMigliore = $prezzoFornitore;
					$IDFornitoriMigliori = array();
				}
				
				if ( $prezzoFornitore == $prezzoMigliore ){
					$IDFornitoriMigliori[] = $fornitore->get('id');
				}
				
			}
			
			#ho cercato nelle regioni di tutti i fornitori che avevano questa regione nei prezzi e a questo punto dovrei aver trovato il prezzo migliore
			
		}else{
			
			#trovo la zona della città
			$zona = $citta->get('zona');
			
			$prezzi = $cliente->get('prezzi');
			$prezzi = $prezzi[$zona];
				
			#scorro i prezzi
			$indicePeso = 0;
			$indiceVolume = 0;
			
			if ( count($prezzi) > 0 ) {
				foreach ( $prezzi as $indice => $info ) {
					if ( $volume > floatval($info['M3']) ) {
						$indiceVolume = $indice + 1;
					}
					if ( $peso > floatval($info['KG']) ) {
						$indicePeso = $indice + 1;
					}
				}	
			}
			
			#trovo l'indice più altro fra quello del volume e quello del peso
			$indicePrezzo = $indicePeso >= $indiceVolume ? $indicePeso : $indiceVolume;
			if ( $indicePrezzo >= count($prezzi) ) {
				$indicePrezzo = count($prezzi) - 1;
			}
			
			#dalla tabella recupero il prezzo di questo indice
			$prezzoMigliore = $prezzi[$indicePrezzo]['euro'];
			
		}
		
		return array(
			'IDFornitori' => $IDFornitoriMigliori,
			'prezzo' => $prezzoMigliore
		);
		
	}
	
	static function totaleSpeseAccessorie( $IDCliente, $strumenti, $facchinaggio, $numeroSoste, $oreTassative, $servizioContrassegno, $prezzoProspetto ){
		
		$speseAccessorie = 0.0;
		
		$cliente = new Cliente( $IDCliente );

		#calcolo spese strumenti
		{
			$speseStrumenti = 0.0;
			if ( !is_null($strumenti) ) {
				
				#calcolo le spese degli strumenti selezionati
				foreach ( $cliente->get('strumenti') as $infoStrumento ) {
					extract( $infoStrumento );
					#se uno strumento del cliente è compreso negli strumenti del proseptto allora prendo allora somma la cifra	
					if ( in_array($strumento, $strumenti) ) {
						$speseStrumenti += floatval($cifra);
					}
				}
					
			}	
		}
		
		$speseAccessorie += $speseStrumenti;
		
		#se c'è facchinaggio lo sommo
		if ( $facchinaggio != 'false' ) {
			$speseAccessorie += $cliente->get('facchinaggio');
		}
		
		#numero soste
		$speseSoste = intval($numeroSoste) * $cliente->get('sosteOra');
		$speseAccessorie += $speseSoste;
		
		#ore tassative
		if ( $oreTassative != 'false' ) {
			$speseAccessorie += $cliente->get('orariTassativi');
		}
		
		#contrassegno
		{
			$spesaContrassegno = 0.0;
			if ( $servizioContrassegno != 'false' ) {
				$spesaContrassegno = ProspettoTrasporto::calcolaProvvigioneConstrassegno( $cliente->get('id'), $prezzoServizioContrassegno, $prezzoProspetto );
			}
		}
		$speseAccessorie += $spesaContrassegno;
		
		return $speseAccessorie;
	}
	
	static function totale( $speseAccessorie, $prezzoReale ){
		
		$totaleProspetto = $speseAccessorie + $prezzoReale;
		
		return $totaleProspetto;
		
	}
	
	static function totaleIVA( $totaleProspetto, $iva ){
		
		$iva = floatval($iva);
		
		return ( $totaleProspetto * $iva / 100 );
			
	}
	
	static function totaleConIVA( $totaleProspetto, $iva ){
		
		$round = round( $totaleProspetto + ProspettoTrasporto::totaleIVA( $totaleProspetto, $iva ), 2 );
		
		return $round;
		
	}
	
	static function calcolaProvvigioneConstrassegno( $IDCliente, $prezzoServizioContrassegno, $prezzo ){
		
		#calcolo tutto questo sul prezzo, quindi il prezzo da peso/dimensioni o da prezzo concordato
		
		$cliente = new Cliente( $IDCliente );
			
		#se c'è il recapito contrassegno uso la percentuale che recupero dal cliente
		extract( $cliente->get('provvigioneServizioContrassegno') );
		
		#calcolo il valore con la percentuale dal cliente
		$valoreDaPercentuale = ( $percentuale / 100 ) * $prezzo;
		
		#faccio il confronto e prendo il maggiore dei due valori
		$spesaContrassegno = $valoreDaPercentuale > $cifra ? $valoreDaPercentuale : $cifra;
		
		return $spesaContrassegno;
		
	}
	
	static function calcoloAssicurazione( $prezzo, $assicurazione ){
		
		$sovraprezzoAssicurazione = 0;
		
		if ( $assicurazione ) {
			$sovraprezzoAssicurazione = $prezzo * (2 / 100);
		}
		
		return $sovraprezzoAssicurazione;
		
	}
	
	static function prezzoReale( $prezzoCalcolato, $prezzoConcordato ){
		
		$prezzoCalcolato = (float)$prezzoCalcolato;
		$prezzoConcordato = (float)$prezzoConcordato;
		
		$prezzoReale = $prezzoConcordato != 0 ? $prezzoConcordato : $prezzoCalcolato;
		
		return $prezzoReale;
		
	}
	
}












