/*
   -------------------------------------------------------------------------
   Module name:         ts_api.c
   Date of last delta:  3/30/00
   Release Number:      3.1
   Remarks:             Transoft wrapper functions for X/Open ISAM compliant
			file handler application program interface.

			This file defines the interface between the DSD and
			the ISAM file handler/ts_isam.c.
			DO NOT CHANGE!
   Copyright:           Copyright (c) Transoft Ltd. 1995-1999, all rights
			reserved.  This source code is Transoft proprietary
			information and is copyright protected. 

			Copying or transfer of this source code is forbidden
			without the express written consent of Transoft Ltd.
   -------------------------------------------------------------------------
*/

#ifdef U_SCCS
static const char _sccs_ident[]="@(#) ts_api.c 3.1 - 3/30/00";
#endif

#define TS_API_C
#include <string.h>
#include <stdlib.h>       
#include <stdio.h>
#include <malloc.h>

#include "ts_isam.h"
#include "ts_api.h"

void  tslogError(char* funcName, char * parameter);

#ifdef TS_DEBUG

#define TS_ASSERT(x,y,z)	(((x) == 0) ?	\
    tslogError((char *)y, (char *)z) : ((void)0))
#else
#define TS_ASSERT(x,y,z)

#endif /* TS_DEBUG */


/* ------------------------------------------------------------------
 * X/Open standard compliant functions
 * ----------------------------------------------------------------*/

/*-------------------------------------------------------------------
 *  wrap_tsopen
 *  Open an ISAM file
 *
 *  Parameters:
 *  Input: 
 *	filename		the name of the file
 *	mode			locking mode in which to open the file	
 *  Output:
 *	None
 *  Return value:
 *	file descriptor upon successful completion, otherwise -1
 *	and wrap_tserrno will return the error number
 *-------------------------------------------------------------------*/

DLLEXPORT int SQL_API
wrap_tsopen(char *filename,int mode)
{
	int ret;
#ifdef TS_DEBUG
	int mode_ = mode;
  	char * filename_ = malloc(strlen(filename)+1);
	if(filename_ != NULL)
	strcpy(filename_, filename);
#endif
	ret = tsopen(filename, mode);      

#ifdef TS_DEBUG
	TS_ASSERT(mode_ == mode, "tsopen", "mode" );
	TS_ASSERT(memcmp(filename_, filename, strlen(filename)) == 0, "tsopen", "filename"); 

	if(filename_ != NULL)
		free(filename_);
#endif

  	return ret;
}							/* wrap_tsopen() */

/*-------------------------------------------------------------------
 *  wrap_tsindexinfo
 *  Obtain file information
 *
 *  Parameters:
 *  Input: 
 *	isfd		file descriptor returned by wrap_tsopen
 *	buffer		Native keydesc or dictinfo buffer in which
 *			to return data.
 *	number		index number or zero to return general file
 *			information into a buffer of type dictinfo
 *  Output:
 *		None
 *  Return value:
 *	0 if successful otherwise -1 and wrap_tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

DLLEXPORT int SQL_API
wrap_tsindexinfo(int isfd, void *buffer,int number)
{
#ifdef TS_DEBUG
	int isfd_ = isfd;
	int number_ = number;
#endif
	
	int ret = tsindexinfo(isfd, (struct keydesc *)buffer, number);

#ifdef TS_DEBUG
	TS_ASSERT(isfd_ == isfd, "tsindexinfo", "isfd" );
	TS_ASSERT(number_ == number,"tsindexinfo", "number"); 
#endif

  	return ret;
}							/* wrap_tsindexinfo() */

/*-------------------------------------------------------------------
 *  wrap_tsclose
 *  Close an ISAM file
 *
 *  Parameters:
 *  Input: 
 *	isfd		file descriptor returned by wrap_tsopen
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and wrap_tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

DLLEXPORT int SQL_API
wrap_tsclose(int isfd)
{
	
#ifdef TS_DEBUG
	int isfd_ = isfd;
#endif

   	int ret = tsclose(isfd);
	
#ifdef TS_DEBUG
	TS_ASSERT(isfd_ == isfd, "tsclose", "isfd" );
#endif

	return ret;
}
#ifdef TS_DEBUG
#define DSD_KEY_PARTS	64  /* Internal DSD Key parts. DO NOT CHANGE! */

static int CalcKeyDescSize()
{
	return sizeof(short)*2 +
		(sizeof(short) * (sizeof(struct keypart) * DSD_KEY_PARTS));
}
							/* wrap_tsclose() */
#endif

/*-------------------------------------------------------------------
 *  wrap_tsstart
 *  Select an index and the subsequent starting point for reads
 *
 *  Parameters:
 *  Input: 
 *	isfd		file descriptor returned by wrap_tsopen
 *	keydesc		pointer to a native key description
 *			structure
 *	length		the part of the key which is significant
 *			for the search
 *	record		the key value sought
 *	mode		search mode
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and wrap_tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

DLLEXPORT int SQL_API
wrap_tsstart(int isfd, void *keydesc,int length,char *record,int mode) 
{
	int ret;

#ifdef TS_DEBUG
	int isfd_ = isfd;
	int length_ = length;
	int mode_ = mode;

	char * record_ = malloc(strlen(record)+1);
	void * keydesc_ = malloc(CalcKeyDescSize());

	if(record_ != NULL)
		strcpy(record_,record);
	if(keydesc_ !=NULL)
		memcpy(keydesc_, keydesc, CalcKeyDescSize());
#endif

    	ret = tsstart(isfd, (struct keydesc *)keydesc, length, record, mode);

#ifdef TS_DEBUG

	TS_ASSERT(isfd_ == isfd, "tsstart", "isfd");
	TS_ASSERT(length_ == length, "tsstart", "length");
	TS_ASSERT(memcmp(record_, record, strlen(record)) == 0, "tsstart", 
		  "record"); 
	TS_ASSERT(memcmp(keydesc_, keydesc, CalcKeyDescSize()) == 0, 
		  "tsstart", "keydesc"); 
	 
	 if(record_ != NULL)
		free(record_);
	 if(keydesc_ != NULL)
		free(keydesc_);
#endif

	 return ret;
}							/* wrap_tsstart() */

/*-------------------------------------------------------------------
 *  wrap_tsread
 *  Read a record
 *
 *  Parameters:
 *  Input: 
 *	isfd		file descriptor returned by wrap_tsopen
 *	record		key value sought and returned record
 *	mode		search mode + locking mode
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and wrap_tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

DLLEXPORT int SQL_API
wrap_tsread(int isfd,char *record,int mode)
{
	
#ifdef TS_DEBUG
	int isfd_=isfd;
	int mode_=mode;
#endif
 
  	int ret = tsread(isfd,record,mode);

#ifdef TS_DEBUG
	TS_ASSERT(isfd_ == isfd, "tsread", "isfd" );
	TS_ASSERT(mode_ == mode,"tsread", "mode");
#endif

	return ret;
}							/* wrap_tsread() */

/*-------------------------------------------------------------------
 *  wrap_tsrelease
 *  unlock records
 *
 *  Parameters:
 *  Input: 
 *	isfd		file descriptor returned by wrap_tsopen
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and wrap_tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

DLLEXPORT int SQL_API
wrap_tsrelease(int isfd)
{
#ifdef TS_DEBUG
	int isfd_ = isfd;
#endif

        int ret = tsrelease(isfd);

#ifdef TS_DEBUG
	TS_ASSERT(isfd_ == isfd, "tsrelease", "isfd" );
#endif
	
	return ret;
}							/* wrap_tsrelease() */

/*-------------------------------------------------------------------
 *  wrap_tswrite
 *  Write record
 *
 *  Parameters:
 *  Input: 
 *	isfd		file descriptor returned by wrap_tsopen
 *	record		record to be written
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and wrap_tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

DLLEXPORT int SQL_API
wrap_tswrite(int isfd,char *record)
{
	int ret;
#ifdef TS_DEBUG
	int isfd_= isfd;

	char * record_ = malloc(strlen(record)+1);

	if(record_ != NULL)
		strcpy(record_,record);
#endif

        ret = tswrite(isfd, record);

#ifdef TS_DEBUG
	TS_ASSERT(isfd_ == isfd, "tswrite", "isfd");
	TS_ASSERT(memcmp(record_, record,strlen(record)) == 0, "tswrite", "record"); 

	if(record_ != NULL)
          free(record_);
	
#endif
	return ret;
}							/* wrap_tswrite() */

/*-------------------------------------------------------------------
 *  wrap_tsrewcurr
 *  Rewrite current record
 *
 *  Parameters:
 *  Input: 
 *	isfd		file descriptor returned by wrap_tsopen
 *	record		record buffer with which to overwrite 
 *			current record
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and wrap_tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

DLLEXPORT int SQL_API
wrap_tsrewcurr(int isfd,char *record)
{
	int ret;

#ifdef TS_DEBUG
	int isfd_ = isfd;
	char * record_ = malloc(strlen(record)+1);

	if(record_ != NULL)
	  strcpy(record_,record);
#endif

        ret = tsrewcurr(isfd, record);

#ifdef TS_DEBUG
	TS_ASSERT(isfd_ == isfd, "tsrewcurr", "isfd");
	TS_ASSERT(memcmp(record_, record, strlen(record)) == 0, "tsrewcurr", "record"); 

	if(record_ != NULL)
		free(record_);
	
#endif

	return ret;
}							/* wrap_tsrewcurr() */

/*-------------------------------------------------------------------
 *  wrap_tsdelcurr
 *  Delete current record
 *
 *  Parameters:
 *  Input: 
 *	isfd		file descriptor returned by wrap_tsopen
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and wrap_tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

DLLEXPORT int SQL_API
wrap_tsdelcurr(int isfd)
{
#ifdef TS_DEBUG
	int isfd_ = isfd;
#endif

        int ret = tsdelcurr(isfd);

#ifdef TS_DEBUG
	TS_ASSERT(isfd_ == isfd, "tsdelcurr", "isfd");
#endif

	return ret;
}							/* wrap_tsdelcurr() */


/* ------------------------------------------------------------------
 * The following functions are not X/Open standard API functions 
 * ------------------------------------------------------------------*/

/*-------------------------------------------------------------------
 *  wrap_tspartsperkey
 *  Returns the maximum number of key parts supported by the file
 *  handler
 *
 *  Parameters:
 *  Input: 
 *	None
 *  Output:
 *	None
 *  Return value:
 *	Number of parts per key
 *-------------------------------------------------------------------*/

DLLEXPORT int SQL_API      
wrap_tspartsperkey()
{
    return tspartsperkey();
}

/*-------------------------------------------------------------------
 *  wrap_tserrno
 *  Returns the last error number associated with a file handle
 *
 *  Parameters:
 *  Input: 
 *	isfd		File descriptor returned by wrap_tsopen
 *  Output:
 *	None
 *  Return value:
 *	error code
 *-------------------------------------------------------------------*/

DLLEXPORT int SQL_API      
wrap_tserrno(int isfd)
{
#ifdef TS_DEBUG
	int isfd_ = isfd;
#endif

        int ret = tserrno(isfd);

#ifdef TS_DEBUG
	TS_ASSERT(isfd_ == isfd, "tserrno", "isfd");
#endif
	
	return ret;
}


/*-------------------------------------------------------------------
 *  wrap_tsversnumber
 *  Returns the file handler version number
 *
 *  Parameters:
 *  Input: 
 *	None
 *  Output:
 *	None
 *  Return value:
 *	Pointer to a string containing the version number
 *-------------------------------------------------------------------*/

DLLEXPORT char *  SQL_API
wrap_tsversnumber(void)
{
    return tsversnumber();
}


/* ------------------------------------------------------------------
 * The following functions are not core functions and are not
 * required for a basic configuration
 * ------------------------------------------------------------------*/

/*-------------------------------------------------------------------
 *  wrap_tsbegin
 *  Defines the beginning of a transaction
 *
 *  Parameters:
 *  Input: 
 *	None
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and wrap_tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

DLLEXPORT int SQL_API
wrap_tsbegin(void)
{
    return tsbegin();
}							/* wrap_tsbegin() */

/*-------------------------------------------------------------------
 *  wrap_tscommit
 *  End a transaction and release all locks
 *
 *  Parameters:
 *  Input: 
 *	None
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and wrap_tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

DLLEXPORT int SQL_API
wrap_tscommit(void)
{
    return tscommit();
}							/* wrap_tscommit() */

/*-------------------------------------------------------------------
 *  wrap_tsrollback
 *  Undo calls made since the last call to wrap_tsbegin
 *
 *  Parameters:
 *  Input: 
 *	None
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and wrap_tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

DLLEXPORT int SQL_API
wrap_tsrollback(void)
{
    return tsrollback();
}							/* wrap_tsrollback() */


/*-------------------------------------------------------------------
 *  wrap_tslogopen
 *  Opens the transaction log file
 *
 *  Parameters:
 *  Input: 
 *	logname			pointer to filename
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and wrap_tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

DLLEXPORT int SQL_API
wrap_tslogopen(char *logname)
{
	int ret;

#ifdef TS_DEBUG
	char * logname_ = malloc(strlen(logname)+1);

	if(logname_ != NULL)
		strcpy(logname_, logname);
#endif

   	ret = tslogopen(logname);

#ifdef TS_DEBUG
	TS_ASSERT(memcmp(logname_, logname, strlen(logname)) == 0,
		 "tslogopen", "logname"); 

	if(logname_ != NULL)
		free(logname_);
#endif

  	return ret;
}							/* wrap_tslogopen() */

/*-------------------------------------------------------------------
 *  wrap_tslogclose
 *  Close the transaction log file
 *
 *  Parameters:
 *  Input: 
 *	None
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and wrap_tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

DLLEXPORT int SQL_API
wrap_tslogclose(void)
{
    return tslogclose();
}							/* wrap_tslogclose() */

/*-------------------------------------------------------------------
 *  wrap_tsreclen
 *  Return the current record length
 *  (Multi threaded implementation of isreclen)
 *
 *  Parameters:
 *  Input: 
 *	isfd		file descriptor returned by wrap_tsopen
 *  Output:
 *	None
 *  Return value:
 *	Record length or -1 on error
 *-------------------------------------------------------------------*/

DLLEXPORT int SQL_API      
wrap_tsreclen(int isfd)
{
    return tsreclen(isfd);
}

/*-------------------------------------------------------------------
 *  wrap_tssetreclen
 *  Set the current record length
 *  (Multi threaded implementation of isreclen)
 *
 *  Parameters:
 *  Input: 
 *	isfd		file descriptor returned by wrap_tsopen
 *	len		record length
 *  Output:
 *	None
 *  Return value:
 *	0 if successful or -1 on error
 *-------------------------------------------------------------------*/

DLLEXPORT int SQL_API      
wrap_tssetreclen(int isfd, int len)
{
#ifdef TS_DEBUG
	int isfd_ = isfd;
	int len_ = len;
#endif

	int ret = tssetreclen(isfd, len);

#ifdef TS_DEBUG
	TS_ASSERT(isfd_ == isfd, "tssetreclen", "isfd");
	TS_ASSERT(len_ == len, "tssetreclen", "len");
#endif

	return ret;
}

/*-------------------------------------------------------------------
 *  wrap_tsrecnum
 *  Return the current record number
 *  (Multi threaded implementation of isrecnum)
 *
 *  Parameters:
 *  Input: 
 *		isfd		file descriptor returned by wrap_tsopen
 *  Output:
 *		None
 *  Return value:
 *		Record number or -1 on error
 *-------------------------------------------------------------------*/

DLLEXPORT int SQL_API      
wrap_tsrecnum(int isfd)
{
#ifdef TS_DEBUG
    int isfd_ = isfd;
#endif

    int ret = tsrecnum(isfd);

#ifdef TS_DEBUG
    TS_ASSERT(isfd_ == isfd, "tsrecnum", "isfd" );
#endif

    return ret;
}

/*-------------------------------------------------------------------
 *  wrap_tssetrecnum
 *  Set the current record number
 *  (Multi threaded implementation of isrecnum)
 *
 *  Parameters:
 *  Input: 
 *	isfd		file descriptor returned by wrap_tsopen
 *	rec		record number
 *  Output:
 *	None
 *  Return value:
 *	0 if successful or -1 on error
 *-------------------------------------------------------------------*/

DLLEXPORT int SQL_API      
wrap_tssetrecnum(int isfd, int rec)
{
#ifdef TS_DEBUG
    int isfd_ = isfd;
    int rec_ = rec;
#endif

    int ret = tssetrecnum(isfd, rec);
 
#ifdef TS_DEBUG
    TS_ASSERT(isfd_ == isfd, "tssetrecnum", "isfd" );
    TS_ASSERT(rec_ == rec, "tssetrecnum", "rec" );
#endif

    return ret;
}

/* ------------------------------------------------------------------
 * The following data type conversion functions are necessary for
 * some of the types built into the Transoft C-ISAM DSD.
 * If it is necessary to use any of the C-ISAM types that rely on
 * these functions then the code must be supplied by the user.
 * More information regarding these functions can be found in the 
 * Informix C-ISAM programmers manual.
 * -----------------------------------------------------------------*/

/*-------------------------------------------------------------------
 *  wrap_tsstdecimal
 *  Store a DECIMALTYPE into a C-ISAM record in packed format
 *
 *  Parameters:
 *  Input: 
 *	dp			dec_t structure containing the decimal data
 *	cp			data record pointer
 *	len			length of the decimal data in data record
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and wrap_tserrno will return
 *	the error number
 *
 *  C-ISAM data type(s) requiring this function:
 *	date(jd_31dec1799)
 *	decimal
 *-------------------------------------------------------------------*/

DLLEXPORT int SQL_API     
wrap_tsstdecimal(dec_t *dp,unsigned char *cp,int len)
{
    return tsstdecimal(dp,cp,len);
}

/*-------------------------------------------------------------------
 *  wrap_tsdeccvint
 *  Convert a C type short into a DECIMALTYPE
 *
 *  Parameters:
 *  Input: 
 *	i		integer to convert
 *  Output:
 *	dp		dec_t structure to receive decimal data
 *  Return value:
 *	0 if successful otherwise -1 and wrap_tserrno will return
 *	the error number
 *
 *  C-ISAM data type(s) requiring this function:
 *	decimal
 *-------------------------------------------------------------------*/
                       
DLLEXPORT int SQL_API     
wrap_tsdeccvint(int i,dec_t *dp)
{
    return tsdeccvint(i,dp);
}

/*-------------------------------------------------------------------
 *  wrap_tsdectolong
 *  Convert a DECIMALTYPE into a C type long
 *
 *  Parameters:
 *  Input: 
 *	dp		pointer to a decimal structure
 *  Output:
 *	ip		pointer to a long to receive result
 *  Return value:
 *	0 if successful otherwise -1 and wrap_tserrno will return
 *	the error number
 *
 *  C-ISAM data type(s) requiring this function:
 *	jd_31dec1799
 *-------------------------------------------------------------------*/

DLLEXPORT int SQL_API     
wrap_tsdectolong(dec_t *dp,long *ip)
{
    return tsdectolong(dp, ip);
}

/*-------------------------------------------------------------------
 *  wrap_tsdeccvlong
 *  Convert a C type long to DECIMALTYPE
 *
 *  Parameters:
 *  Input: 
 *	i		pointer to a long
 *  Output:
 *	dp		pointer to a dec_t structure to receive result
 *  Return value:
 *	-1200	DECIMALTYPE number greater than 2,147,483,647
 *	   -1	Error. wrap_tserrno returns error code
 *	    0	Success		
 *
 *  C-ISAM data type(s) requiring this function:
 *	jd_31dec1799
 *-------------------------------------------------------------------*/

DLLEXPORT int SQL_API     
wrap_tsdeccvlong(long i,register dec_t *dp)
{
    return tsdeccvlong(i,dp);
}

/*-------------------------------------------------------------------
 *  wrap_tsdectoasc
 *  Convert DECIMALTYPE to string
 *
 *  Parameters:
 *  Input: 
 *	np		pointer to a decimal structure
 *	ln		maximum length of string buffer in bytes
 *	dg		number of decimal places
 *  Output:
 *	cp		pointer to character buffer
 *  Return value:
 *	0 if successful otherwise -1 and wrap_tserrno will return
 *	the error number
 *
 *  C-ISAM data type(s) requiring this function:
 *	decimal
 *-------------------------------------------------------------------*/

DLLEXPORT int SQL_API     
wrap_tsdectoasc(dec_t *np,char *cp,int ln,int dg)
{
    return tsdectoasc(np,cp,ln,dg);
}

/*-------------------------------------------------------------------
 *  wrap_tslddecimal
 *  Convert a C-ISAM record to a DECIMALTYPE
 *
 *  Parameters:
 *  Input: 
 *	cp		record pointer
 *	len		decimal data length
 *  Output:
 *	dp		pointer to a dec_t structure to receive data
 *  Return value:
 *	-1201	Underflow error
 *	-1200	Overflow error
 *	    0	Successful
 *
 *  C-ISAM data type(s) requiring this function:
 *	decimal
 *	date(j4H_31dec1899)
 *-------------------------------------------------------------------*/

DLLEXPORT int SQL_API     
wrap_tslddecimal(unsigned char *cp,int len,dec_t *dp)
{
    return tslddecimal(cp,len,dp);
}

/*-------------------------------------------------------------------
 *  wrap_tsdeccvasc
 *  Convert a C char type string to a DECIMALTYPE number
 *
 *  Parameters:
 *  Input: 
 *	cp		string value
 *	ln		string length
 *  Output:
 *	rp		pointer to dec_t structure to receive result
 *  Return value:
 *	-1216		Bad exponent
 *	-1213		Non-numeric chars in string
 *	-1201		Underflow
 *	-1200		Overflow
 *	   -1		Error. wrap_tserrno returns error code
 *	    0		Success
 *
 *  C-ISAM data type(s) requiring this function:
 *	decimal
 *-------------------------------------------------------------------*/

DLLEXPORT int SQL_API     
wrap_tsdeccvasc(char *cp,int ln,dec_t *rp)
{
    return tsdeccvasc(cp,ln,rp);
}

void 
tslogError(char * funcName, char * parameter)
{
   FILE* pFile;
   if (pFile = fopen("tserror.log", "a"))
   {
       fprintf(pFile, "Error in function %s - parameter '%s' has changed \n", funcName, parameter);
#ifdef U_UNIX
       fprintf(stderr,"\nAssertion failure!\nError in function %s - parameter '%s' has changed\n\n", funcName, parameter);
#endif
       fclose(pFile);
   }
}

/* return the dsd name - only used by transoft ? */
DLLEXPORT char * SQL_API     
wrap_tsdsdname()
{
	return tsdsdname();
}

/* return the dsd version - only used by transoft ? */
DLLEXPORT char * SQL_API     
wrap_tsdsdversion()
{
	return tsdsdversion();
}
