/*
   -------------------------------------------------------------------------
   Module name:         ts_api.h
   Date of last delta:  3/30/00
   Release Number:      3.1
   Remarks:             Header file defining Transoft wrapper functions for 
			X/Open ISAM compliant file handler application program
			interface.
   Copyright:           Copyright (c) Transoft Ltd. 1995-1999, all rights
			reserved.  This source code is Transoft proprietary
			information and is copyright protected. 

			Copying or transfer of this source code is forbidden
			without the express written consent of Transoft Ltd.
   -------------------------------------------------------------------------
*/

#ifndef DLLEXPORT
#ifdef WIN32
#define DLLEXPORT __declspec(dllexport)
#else
#define DLLEXPORT
#endif 
#endif

#ifndef SQL_API
#ifdef U_16BIT
#define SQL_API _pascal _far _loadds
#else
#define SQL_API
#endif
#endif

#undef EXTERN
#ifndef TS_API_C
#define EXTERN extern
#else
#define EXTERN
#endif

EXTERN DLLEXPORT	int SQL_API  wrap_tsopen(char *,int);
EXTERN DLLEXPORT	int SQL_API  wrap_tsindexinfo(int,void *,int);
EXTERN DLLEXPORT	int SQL_API  wrap_tsclose(int);
EXTERN DLLEXPORT	int SQL_API  wrap_tsstart(int, void *,int,char *,int);
EXTERN DLLEXPORT	int SQL_API  wrap_tsread(int,char *,int);
EXTERN DLLEXPORT	int SQL_API  wrap_tsrelease(int);
EXTERN DLLEXPORT	int SQL_API  wrap_tswrite(int,char *);
EXTERN DLLEXPORT	int SQL_API  wrap_tsrewcurr(int,char *);
EXTERN DLLEXPORT	int SQL_API  wrap_tsdelcurr(int);
EXTERN DLLEXPORT	int SQL_API  wrap_tspartsperkey(void);
EXTERN DLLEXPORT	int SQL_API  wrap_tserrno(int);
EXTERN DLLEXPORT	char * SQL_API wrap_tsversnumber(void);
EXTERN DLLEXPORT	int SQL_API  wrap_tsbegin(void);
EXTERN DLLEXPORT	int SQL_API  wrap_tscommit(void);
EXTERN DLLEXPORT	int SQL_API  wrap_tsrollback(void);
EXTERN DLLEXPORT	int SQL_API  wrap_tslogopen(char *);
EXTERN DLLEXPORT	int SQL_API  wrap_tslogclose(void);
EXTERN DLLEXPORT	int SQL_API  wrap_tsreclen(int);
EXTERN DLLEXPORT	int SQL_API  wrap_tssetreclen(int,int);
EXTERN DLLEXPORT	int SQL_API  wrap_tsrecnum(int );
EXTERN DLLEXPORT	int SQL_API  wrap_tssetrecnum(int,int);
EXTERN DLLEXPORT	int SQL_API  wrap_tsstdecimal(dec_t *,unsigned char *,int);
EXTERN DLLEXPORT	int SQL_API  wrap_tsdeccvint(int ,dec_t *);
EXTERN DLLEXPORT	int SQL_API  wrap_tsdectolong(dec_t *,long *);
EXTERN DLLEXPORT	int SQL_API  wrap_tsdeccvlong(long,register dec_t *);
EXTERN DLLEXPORT	int SQL_API  wrap_tsdectoasc(dec_t *,char *,int,int);
EXTERN DLLEXPORT	int SQL_API  wrap_tslddecimal(unsigned char *,int,dec_t *);
EXTERN DLLEXPORT	int SQL_API  wrap_tsdeccvasc(char *,int,dec_t *);
EXTERN DLLEXPORT	char * SQL_API wrap_tsdsdname(void);
EXTERN DLLEXPORT	char * SQL_API wrap_tsdsdversion(void);

#undef EXTERN
#ifndef IN_TSDEF
#define EXTERN extern
#else
#define EXTERN
#endif

EXTERN int   tsopen(char *,int);
EXTERN int   tsindexinfo(int,void *,int);
EXTERN int   tsclose(int);
EXTERN int   tsstart(int, void *,int,char *,int);
EXTERN int   tsread(int,char *,int);
EXTERN int   tsrelease(int);
EXTERN int   tswrite(int,char *);
EXTERN int   tsrewcurr(int,char *);
EXTERN int   tsdelcurr(int);
EXTERN int   tspartsperkey(void);
EXTERN int   tserrno(int);
EXTERN char *tsversnumber(void);
EXTERN int   tsbegin(void);
EXTERN int   tscommit(void);
EXTERN int   tsrollback(void);
EXTERN int   tslogopen(char *);
EXTERN int   tslogclose(void);
EXTERN int   tsreclen(int);
EXTERN int   tssetreclen(int,int);
EXTERN int   tsrecnum(int );
EXTERN int   tssetrecnum(int,int);
EXTERN int   tsstdecimal(dec_t *,unsigned char *,int);
EXTERN int   tsdeccvint(int ,dec_t *);
EXTERN int   tsdectolong(dec_t *,long *);
EXTERN int   tsdeccvlong(long,register dec_t *);
EXTERN int   tsdectoasc(dec_t *,char *,int,int);
EXTERN int   tslddecimal(unsigned char *,int,dec_t *);
EXTERN int   tsdeccvasc(char *,int,dec_t *);
EXTERN char * tsdsdname( void );
EXTERN char * tsdsdversion( void );
