/*
   -------------------------------------------------------------------------
   Module name:         usr_type.c
   Date of last delta:  2/1/99
   Release Number:      1.9
   Remarks:             Transoft wrapper functions for user data types.
   Copyright:           Copyright (c) Transoft Ltd. 1995-1999, all rights
			reserved.  This source code is Transoft proprietary
			information and is copyright protected.

			Copying or transfer of this source code is forbidden    
			without the express written consent of Transoft Ltd
   -------------------------------------------------------------------------
*/

#ifdef U_SCCS
static const char _sccs_ident[]="@(#) usr_type.c 1.9 - 2/1/99";
#endif

#ifdef WIN32
#define EXPORT __declspec(dllexport) 
#else
#define EXPORT
#endif

#ifdef U_16BIT
#define SQL_API _pascal _far _loadds
#else
#define SQL_API
#endif


/*-------------------------------------------------------------------
 *  ld_usr_char
 *  Convert user type to usr_char
 *
 *  Parameters:
 *  Input: 
 *		type_index		Type index - specifies which instance 
 *					of this Transoft type is being used.
 *					The first user type based on this 
 *					Transoft type will be index 1, the
 *					second 2 etc.
 *		from			Field buffer in user format
 *		len			Field buffer length in bytes
 *  Output:
 *		to_str		Data in usr_char format
 *  Return value:
 *		None
 *-----------------------------------------------------------------*/

EXPORT	void	SQL_API	ld_usr_char(int type_index,char *from,int len, char *to_str)
{
	/* User code goes here */
}


/*-------------------------------------------------------------------
 *  st_usr_char
 *  Convert usr_char to user type
 *
 *  Parameters:
 *  Input: 
 *		type_index		See ld_usr_char function
 *		from_str		Data in usr_char format
 *		len			Field buffer length in bytes
 *  Output:
 *		to			Field buffer in user format
 *  Return value:
 *		None
 *-----------------------------------------------------------------*/

EXPORT	void	SQL_API	st_usr_char(int type_index,char *from_str,int len, char *to)
{
	/* User code goes here */
}

/*-------------------------------------------------------------------
 *  ld_usr_int
 *  Convert user type to usr_int
 *
 *  Parameters:
 *  Input: 
 *		type_index		See ld_usr_char function
 *		from			Field buffer in user format
 *		len			Field buffer length in bytes
 *  Output:
 *		to			Field buffer in usr_int format
 *  Return value:
 *		None 
 *-----------------------------------------------------------------*/

EXPORT	void	SQL_API ld_usr_int(int type_index, unsigned char *from, int len, unsigned char * to)
{
	/* User code goes here */
}


/*-------------------------------------------------------------------
 *  st_usr_int
 *  Convert usr_int to user type
 *
 *  Parameters:
 *  Input: 
 *		type_index		See ld_usr_char function
 *		from			Data in usr_int format
 *		len			Field buffer length in bytes
 *  Output:
 *		to			Field buffer in user format
 *  Return value:
 *		None
 *-----------------------------------------------------------------*/

EXPORT	void	SQL_API	st_usr_int(int type_index, unsigned char * from, int len, unsigned char *to)
{
	/* User code goes here */
}


/*-------------------------------------------------------------------
 *  ld_usr_uint
 *  Convert user type to usr_uint
 *
 *  Parameters:
 *  Input: 
 *		type_index		See ld_usr_char function
 *		from			Field buffer in user format
 *		len			Field buffer length in bytes
 *  Output:
 *		to			Field buffer in usr_uint format
 *  Return value:
 *		None
 *-----------------------------------------------------------------*/

EXPORT	void 	SQL_API ld_usr_uint(int type_index, unsigned char *from, int len, unsigned char *to)
{
	/* User code goes here */
}


/*-------------------------------------------------------------------
 *  st_usr_uint
 *  Convert usr_uint to user type
 *
 *  Parameters:
 *  Input: 
 *		type_index		See ld_usr_char function
 *		from			Data in usr_uint format
 *		len			Field buffer length in bytes
 *  Output:
 *		to			Field buffer in user format
 *  Return value:
 *		None
 *-----------------------------------------------------------------*/

EXPORT	void	SQL_API	st_usr_uint(int type_index, unsigned char * from, int len, unsigned char *to)
{
	/* User code goes here */
}


/*-------------------------------------------------------------------
 *  ld_usr_long
 *  Convert user type to usr_long
 *
 *  Parameters:
 *  Input: 
 *		type_index		See ld_usr_char function
 *		from			Field buffer in user format
 *		len			Field buffer length in bytes
 *  Output:
 *		to			Field buffer in usr_long format
 *  Return value:
 *		None
 *-----------------------------------------------------------------*/

EXPORT	void	SQL_API ld_usr_long(int type_index, unsigned char *from, int len,unsigned char * to)
{
	/* User code goes here */
}


/*-------------------------------------------------------------------
 *  st_usr_long
 *  Convert usr_long to user type
 *
 *  Parameters:
 *  Input: 
 *		type_index		See ld_usr_char function
 *		from			Data in usr_long format
 *		len			Field buffer length in bytes
 *  Output:
 *		to			Field buffer in user format
 *  Return value:
 *		None
 *-----------------------------------------------------------------*/

EXPORT	void	SQL_API	st_usr_long(int type_index,unsigned char * from,int len,unsigned char *to)
{
	/* User code goes here */
}


/*-------------------------------------------------------------------
 *  ld_usr_ulong
 *  Convert user type to usr_ulong
 *
 *  Parameters:
 *  Input: 
 *		type_index		See ld_usr_char function
 *		from			Field buffer in user format
 *		len			Field buffer length in bytes
 *  Output:
 *		to			Field buffer in usr_ulong format
 *  Return value:
 *		None
 *-----------------------------------------------------------------*/

EXPORT	void  SQL_API ld_usr_ulong(int type_index, unsigned char *from, int len, unsigned char * to)
{
	/* User code goes here */
}

/*-------------------------------------------------------------------
 *  st_usr_ulong
 *  Convert usr_ulong to user type
 *
 *  Parameters:
 *  Input: 
 *		type_index		See ld_usr_char function
 *		from			Data in usr_ulong format
 *		len			Field buffer length in bytes
 *  Output:
 *		to			Field buffer in user format
 *  Return value:
 *		None
 *-----------------------------------------------------------------*/

EXPORT	void	SQL_API	st_usr_ulong(int type_index, unsigned char * from, int len, unsigned char *to)
{
	/* User code goes here */
}


/*-------------------------------------------------------------------
 *  ld_usr_float
 *  Convert user type to usr_float
 *
 *  Parameters:
 *  Input: 
 *		type_index		See ld_usr_char function
 *		from			Field buffer in user format
 *		len			Field buffer length in bytes
 *  Output:
 *		to			Field buffer in usr_float format
 *  Return value:
 *		None
 *-----------------------------------------------------------------*/

EXPORT	void	SQL_API ld_usr_float(int type_index, unsigned char *from, int len, unsigned char * to)
{
	/* User code goes here */
}

/*-------------------------------------------------------------------
 *  st_usr_float
 *  Convert usr_float to user type
 *
 *  Parameters:
 *  Input: 
 *		type_index		See ld_usr_char function
 *		from			Data in usr_float format
 *		len			Field buffer length in bytes
 *  Output:
 *		to			Field buffer in user format
 *  Return value:
 *		None
 *-----------------------------------------------------------------*/

EXPORT	void	SQL_API	st_usr_float(int type_index,unsigned char* from,int len,unsigned char *to)
{
	/* User code goes here */
}


/*-------------------------------------------------------------------
 *  ld_usr_dbl
 *  Convert user type to usr_dbl
 *
 *  Parameters:
 *  Input: 
 *		type_index		See ld_usr_char function
 *		from			Field buffer in user format
 *		len			Field buffer length in bytes
 *		ndec			Number of decimal places
 *					specifed in ndec column of UFD
 *  Output:
 *		to			Field buffer in usr_dbl format
 *  Return value:
 *		None
 *-----------------------------------------------------------------*/

EXPORT	void	SQL_API	ld_usr_dbl(int type_index, unsigned char *from, int len, int ndec, unsigned char *to)
{
	/* User code goes here */
}


/*-------------------------------------------------------------------
 *  st_usr_dbl
 *  Convert usr_dbl to user type
 *
 *  Parameters:
 *  Input: 
 *		type_index		See ld_usr_char function
 *		from			Data in usr_dbl format
 *		len			Field buffer length in bytes
 * 		ndec			Number of decimal places as
 *					spcified in ndec column of UFD
 *  Output:
 *		to			Field buffer in user format
 *  Return value:
 *		None
 *-----------------------------------------------------------------*/

EXPORT	void	SQL_API	st_usr_dbl(int type_index, unsigned char* from, int len, unsigned char *to, int ndec)
{
	/* User code goes here */
}


/*-------------------------------------------------------------------
 *  ld_usr_num
 *  Convert user type to usr_numeric
 *
 *  Parameters:
 *  Input: 
 *		type_index		See ld_usr_char function
 *		from			Field buffer in user format
 *		len			Field buffer length in bytes
 *		ndec			Number of decimal places as specified
 *					in the ndec column of the UFD file.
 *  Output:
 *		to_str			Data in usr_numeric format
 *  Return value:
 *		None
 *-----------------------------------------------------------------*/

EXPORT	void	SQL_API	ld_usr_num(int type_index, char *from, int len, int ndec, char *to_str)
{
	/* User code goes here */
}


/*-------------------------------------------------------------------
 *  st_usr_num
 *  Convert usr_numeric to user type
 *
 *  Parameters:
 *  Input: 
 *		type_index		See ld_usr_char function
 *		from_str		Data in usr_numeric format
 *		len			Field buffer length in bytes
 *		ndec			Number of decimal places as specified
 *					in the ndec	column of the UFD file.
 *  Output:
 *		to				Field buffer in user format
 *  Return values:
 *		None
 *-----------------------------------------------------------------*/

EXPORT	void	SQL_API	st_usr_num(int type_index, char *from_str, int len, int ndec, char *to)
{
	/* User code goes here */
}

 
/*-------------------------------------------------------------------
 *  ld_usr_date
 *  Convert user type to usr_date
 *
 *  Parameters:
 *  Input: 
 *		type_index		See ld_usr_char function
 *		from			Field buffer in user format
 *		len			Field buffer length in bytes
 *  Output:
 *		to			Field buffer in usr_date format
 *  Return value:
 *		None
 *-----------------------------------------------------------------*/

EXPORT	void	SQL_API ld_usr_date(int type_index, unsigned char *from, int len, unsigned char * to)
{
	/* User code goes here */
}


/*-------------------------------------------------------------------
 *  st_usr_date
 *  Convert usr_date to user type
 *
 *  Parameters:
 *  Input: 
 *		type_index		See ld_usr_char function
 *		from			Data in usr_date format
 *		len			Field buffer length in bytes
 *  Output:
 *		to			Field buffer in user format
 *  Return value:
 *		None
 *-----------------------------------------------------------------*/

EXPORT	void	SQL_API	st_usr_date(int type_index,unsigned char * from,int len,unsigned char *to)
{
	/* User code goes here */
}


/*-------------------------------------------------------------------
 *  ld_usr_time
 *  Convert user type to usr_time
 *
 *  Parameters:
 *  Input: 
 *		type_index		See ld_usr_char function
 *		from			Field buffer in user format
 *		len			Field buffer length in bytes
 *  Output:
 *		to 			Field buffer in usr_time format
 *  Return value:
 *		None
 *-----------------------------------------------------------------*/

EXPORT	void	SQL_API ld_usr_time(int type_index, unsigned char *from, int len,unsigned char * to)
{
	/* User code goes here */
}


/*-------------------------------------------------------------------
 *  st_usr_time
 *  Convert usr_time to user type
 *
 *  Parameters:
 *  Input: 
 *		type_index		See ld_usr_char function
 *		from			Data in usr_time format
 *		len			Field buffer length in bytes
 *  Output:
 *		to			Field buffer in user format
 *  Return value:
 *		None
 *-----------------------------------------------------------------*/

EXPORT	void	SQL_API	st_usr_time(int type_index,unsigned char * from,int len,unsigned char *to)
{
	/* User code goes here */
}


/*-------------------------------------------------------------------
 *  ld_usr_tstamp
 *  Convert user type to usr_tstamp
 *
 *  Parameters:
 *  Input: 
 *		type_index		See ld_usr_char function
 *		from			Field buffer in user format
 *		len			Field buffer length in bytes
 *  Output:
 *		to			Pointer to usr_tstamp value
 *  Return value:
 *		None
 *-----------------------------------------------------------------*/

EXPORT	void	SQL_API	ld_usr_tstamp(int type_index, unsigned char *from, int len, unsigned char *to)
{
	/* User code goes here */
}

/*-------------------------------------------------------------------
 *  st_usr_tstamp
 *  Convert usr_tstamp to user type
 *
 *  Parameters:
 *  Input: 
 *		type_index		See ld_usr_char function
 *		from			Pointer to usr_tstamp value
 *		len			Field buffer length in bytes
 *  Output:
 *		to			Field buffer in user format
 *  Return value:
 *		None
 *-----------------------------------------------------------------*/

EXPORT	void	SQL_API	st_usr_tstamp(int type_index, unsigned char *from, int len, unsigned char *to)
{
	/* User code goes here */
}
