/*
   -------------------------------------------------------------------------
   Module name:         usrfnc.h
   Date of last delta:  12/3/99
   Release Number:      1.11
   Remarks:             User function dispatch table: header file.
   Copyright:           Copyright (c) Transoft Ltd. 1995-2001, all rights
			reserved.  This source code is Transoft proprietary
			information and is copyright protected.                 

			Copying or transfer of this source code is forbidden
			without the express written consent of Transoft Ltd
   -------------------------------------------------------------------------
*/

#define USR_CREATE_DICTIONARY   1
#define USR_CONNECT             2
#define USR_DISCONNECT          3
#define USR_VALIDATE_USER       4
#define USR_CREATE_STATEMENT    5
#define USR_FREE_STATEMENT      6
#define USR_INIT_TABLE          7
#define USR_OPEN_TABLE          8
#define USR_CLOSE_TABLE         9
#define USR_READ_TABLE          10
#define USR_SPECIFY_INDEX       11
#define USR_VALID_TABLE         12
#define USR_FNC_SUBSTITUTE      13
#define USR_EVAL_FUNCTION       14
#define USR_WRITE_TABLE         15
#define USR_EVAL_RECORD         16
#define USR_SUBSTITUTE_FILENAME 17
#define CLUSR_CONNECT			18


#define MAX_NUM_ARGS            20
#define RTN_VAL_SZ              100


typedef struct
{
    int         action;
    int         (*func)();
} USR_FUNCTION;


typedef struct
{
    char        *fnc_name;
    int         num_args;
    char        *args[MAX_NUM_ARGS];
    char        return_val[RTN_VAL_SZ + 1];
} USR_FNC_ARGS;

