/*
   -------------------------------------------------------------------------
   Module name:         ts_isam.c
   Date of last delta:  1/4/99
   Release Number:      1.8
   Remarks:             Transoft wrapper functions for X/Open ISAM compliant
			file handler application program interface.

			For distribution with linkable DSD version.
   Copyright:           Copyright (c) Transoft Ltd. 1995-1999, all rights
			reserved.  This source code is Transoft proprietary     
			information and is copyright protected.                 

			Copying or transfer of this source code is forbidden    
			without the express written consent of Transoft Ltd.   
   -------------------------------------------------------------------------
*/

#ifdef U_SCCS
static const char _sccs_ident[]="@(#) ts_isam.c 1.8 - 1/4/99";
#endif

#include <stdio.h>

#define IN_TSDEF 1
#include "ts_isam.h"
#include "ts_api.h"

/* ------------------------------------------------------------------
 * X/Open standard compliant functions
 * ----------------------------------------------------------------*/

/*-------------------------------------------------------------------
 *  tsopen
 *  Open an ISAM file
 *
 *  Parameters:
 *  Input: 
 *	filename		the name of the file
 *	mode			locking mode in which to open the file	
 *  Output:
 *	None
 *  Return value:
 *	file descriptor upon successful completion, otherwise -1
 *	and tserrno will return the error number
 *-------------------------------------------------------------------*/

int
tsopen(char *filename,int mode)
{
	/* User code goes here */
	return -1;
}							/* tsopen() */

/*-------------------------------------------------------------------
 *  tsindexinfo
 *  Obtain file information
 *
 *  Parameters:
 *  Input: 
 *	isfd		file descriptor returned by tsopen
 *	buffer		Native keydesc or dictinfo buffer in which
 *			to return data.
 *	number		index number or zero to return general file
 *			information into a buffer of type dictinfo
 *  Output:
 *		None
 *  Return value:
 *	0 if successful otherwise -1 and tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

int
tsindexinfo(int isfd, void *buffer,int number)
{
	/* User code goes here */
	return -1;
}							/* tsindexinfo() */

/*-------------------------------------------------------------------
 *  tsclose
 *  Close an ISAM file
 *
 *  Parameters:
 *  Input: 
 *	isfd		file descriptor returned by tsopen
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

int
tsclose(int isfd)
{
	/* User code goes here */
	return -1;
}							/* tsclose() */

/*-------------------------------------------------------------------
 *  tsstart
 *  Select an index and the subsequent starting point for reads
 *
 *  Parameters:
 *  Input: 
 *	isfd		file descriptor returned by tsopen
 *	keydesc		pointer to a native key description
 *			structure
 *	length		the part of the key which is significant
 *			for the search
 *	record		the key value sought
 *	mode		search mode
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

int
tsstart(int isfd, void *keydesc,int length,char *record,int mode) 
{
	/* User code goes here */
	return -1;
}							/* tsstart() */

/*-------------------------------------------------------------------
 *  tsread
 *  Read a record
 *
 *  Parameters:
 *  Input: 
 *	isfd		file descriptor returned by tsopen
 *	record		key value sought and returned record
 *	mode		search mode + locking mode
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

int
tsread(int isfd,char *record,int mode)
{
	/* User code goes here */
	return -1;
}							/* tsread() */

/*-------------------------------------------------------------------
 *  tsrelease
 *  unlock records
 *
 *  Parameters:
 *  Input: 
 *	isfd		file descriptor returned by tsopen
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

int
tsrelease(int isfd)
{
	/* User code goes here */
	return -1;
}							/* tsrelease() */

/*-------------------------------------------------------------------
 *  tswrite
 *  Write record
 *
 *  Parameters:
 *  Input: 
 *	isfd		file descriptor returned by tsopen
 *	record		record to be written
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

int
tswrite(int isfd,char *record)
{
	/* User code goes here */
	return -1;
}							/* tswrite() */

/*-------------------------------------------------------------------
 *  tsrewcurr
 *  Rewrite current record
 *
 *  Parameters:
 *  Input: 
 *	isfd		file descriptor returned by tsopen
 *	record		record buffer with which to overwrite 
 *			current record
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

int
tsrewcurr(int isfd,char *record)
{
	/* User code goes here */
	return -1;
}							/* tsrewcurr() */

/*-------------------------------------------------------------------
 *  tsdelcurr
 *  Delete current record
 *
 *  Parameters:
 *  Input: 
 *	isfd		file descriptor returned by tsopen
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

int
tsdelcurr(int isfd)
{
	/* User code goes here */
	return -1;
}							/* tsdelcurr() */


/* ------------------------------------------------------------------
 * The following functions are not X/Open standard API functions 
 * ------------------------------------------------------------------*/

/*-------------------------------------------------------------------
 *  tspartsperkey
 *  Returns the maximum number of key parts supported by the file
 *  handler
 *
 *  Parameters:
 *  Input: 
 *	None
 *  Output:
 *	None
 *  Return value:
 *	Number of parts per key
 *-------------------------------------------------------------------*/

int      
tspartsperkey()
{
    return NPARTS;
}

/*-------------------------------------------------------------------
 *  tserrno
 *  Returns the last error number associated with a file handle
 *
 *  Parameters:
 *  Input: 
 *	isfd		File descriptor returned by tsopen
 *  Output:
 *	None
 *  Return value:
 *	error code
 *-------------------------------------------------------------------*/

int      
tserrno(int isfd)
{
	/* User code goes here */
	return -1;
}


/*-------------------------------------------------------------------
 *  tsversnumber
 *  Returns the file handler version number
 *
 *  Parameters:
 *  Input: 
 *	None
 *  Output:
 *	None
 *  Return value:
 *	Pointer to a string containing the version number
 *-------------------------------------------------------------------*/

char * 
tsversnumber(void)
{
	/* User code goes here */
	return "";
}


/* ------------------------------------------------------------------
 * The following functions are not core functions and are not
 * required for a basic configuration
 * ------------------------------------------------------------------*/

/*-------------------------------------------------------------------
 *  tsbegin
 *  Defines the beginning of a transaction
 *
 *  Parameters:
 *  Input: 
 *	None
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

int
tsbegin(void)
{
	/* User code goes here */
	return -1;
}							/* tsbegin() */

/*-------------------------------------------------------------------
 *  tscommit
 *  End a transaction and release all locks
 *
 *  Parameters:
 *  Input: 
 *	None
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

int
tscommit(void)
{
	/* User code goes here */
	return -1;
}							/* tscommit() */

/*-------------------------------------------------------------------
 *  tsrollback
 *  Undo calls made since the last call to tsbegin
 *
 *  Parameters:
 *  Input: 
 *	None
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

int
tsrollback(void)
{
	/* User code goes here */
	return -1;
}							/* tsrollback() */


/*-------------------------------------------------------------------
 *  tslogopen
 *  Opens the transaction log file
 *
 *  Parameters:
 *  Input: 
 *	logname			pointer to filename
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

int
tslogopen(char *logname)
{
	/* User code goes here */
	return -1;
}							/* tslogopen() */

/*-------------------------------------------------------------------
 *  tslogclose
 *  Close the transaction log file
 *
 *  Parameters:
 *  Input: 
 *	None
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

int
tslogclose(void)
{
	/* User code goes here */
	return -1;
}							/* tslogclose() */

/*-------------------------------------------------------------------
 *  tsreclen
 *  Return the current record length
 *  (Multi threaded implementation of isreclen)
 *
 *  Parameters:
 *  Input: 
 *	isfd		file descriptor returned by tsopen
 *  Output:
 *	None
 *  Return value:
 *	Record length or -1 on error
 *-------------------------------------------------------------------*/

int      
tsreclen(int isfd)
{
	/* User code goes here */
	return -1;
}

/*-------------------------------------------------------------------
 *  tssetreclen
 *  Set the current record length
 *  (Multi threaded implementation of isreclen)
 *
 *  Parameters:
 *  Input: 
 *	isfd		file descriptor returned by tsopen
 *	len		record length
 *  Output:
 *	None
 *  Return value:
 *	0 if successful or -1 on error
 *-------------------------------------------------------------------*/

int      
tssetreclen(int isfd, int len)
{
	/* User code goes here */
	return -1;
}

/*-------------------------------------------------------------------
 *  tsrecnum
 *  Return the current record number
 *  (Multi threaded implementation of isrecnum)
 *
 *  Parameters:
 *  Input: 
 *		isfd		file descriptor returned by tsopen
 *  Output:
 *		None
 *  Return value:
 *		Record number or -1 on error
 *-------------------------------------------------------------------*/

int      
tsrecnum(int isfd)
{
	/* User code goes here */
	return -1;
}

/*-------------------------------------------------------------------
 *  tssetrecnum
 *  Set the current record number
 *  (Multi threaded implementation of isrecnum)
 *
 *  Parameters:
 *  Input: 
 *	isfd		file descriptor returned by tsopen
 *	rec		record number
 *  Output:
 *	None
 *  Return value:
 *	0 if successful or -1 on error
 *-------------------------------------------------------------------*/

int      
tssetrecnum(int isfd, int rec)
{
	/* User code goes here */
	return -1;
}

/* ------------------------------------------------------------------
 * The following data type conversion functions are necessary for
 * some of the Informix types built into the Transoft C-ISAM DSD.
 * If it is necessary to use any of the C-ISAM types that rely on
 * these functions then the code must be supplied by the user.
 * More information regarding these functions can be found in the 
 * Informix C-ISAM programmers manual.
 * -----------------------------------------------------------------*/

/*-------------------------------------------------------------------
 *  tsstdecimal
 *  Store a DECIMALTYPE into a C-ISAM record in packed format
 *
 *  Parameters:
 *  Input: 
 *	dp			dec_t structure containing the decimal data
 *	cp			data record pointer
 *	len			length of the decimal data in data record
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and tserrno will return
 *	the error number
 *
 *  C-ISAM data type(s) requiring this function:
 *	date(jd_31dec1799)
 *	decimal
 *-------------------------------------------------------------------*/

int     
tsstdecimal(dec_t *dp,unsigned char *cp,int len)
{
	/* User code goes here */
	return -1;
}

/*-------------------------------------------------------------------
 *  tsdeccvint
 *  Convert a C type short into a DECIMALTYPE
 *
 *  Parameters:
 *  Input: 
 *	i		integer to convert
 *  Output:
 *	dp		dec_t structure to receive decimal data
 *  Return value:
 *	0 if successful otherwise -1 and tserrno will return
 *	the error number
 *
 *  C-ISAM data type(s) requiring this function:
 *	decimal
 *-------------------------------------------------------------------*/
                       
int     
tsdeccvint(int i,dec_t *dp)
{
	/* User code goes here */
	return -1;
}

/*-------------------------------------------------------------------
 *  tsdectolong
 *  Convert a DECIMALTYPE into a C type long
 *
 *  Parameters:
 *  Input: 
 *	dp		pointer to a decimal structure
 *  Output:
 *	ip		pointer to a long to receive result
 *  Return value:
 *	0 if successful otherwise -1 and tserrno will return
 *	the error number
 *
 *  C-ISAM data type(s) requiring this function:
 *	jd_31dec1799
 *-------------------------------------------------------------------*/

int     
tsdectolong(dec_t *dp,long *ip)
{
	/* User code goes here */
	return -1;
}

/*-------------------------------------------------------------------
 *  tsdeccvlong
 *  Convert a C type long to DECIMALTYPE
 *
 *  Parameters:
 *  Input: 
 *	i		pointer to a long
 *  Output:
 *	dp		pointer to a dec_t structure to receive result
 *  Return value:
 *	-1200	DECIMALTYPE number greater than 2,147,483,647
 *	   -1	Error. tserrno returns error code
 *	    0	Success		
 *
 *  C-ISAM data type(s) requiring this function:
 *	jd_31dec1799
 *-------------------------------------------------------------------*/

int     
tsdeccvlong(long i,register dec_t *dp)
{
	/* User code goes here */
	return -1;
}

/*-------------------------------------------------------------------
 *  tsdectoasc
 *  Convert DECIMALTYPE to string
 *
 *  Parameters:
 *  Input: 
 *	np		pointer to a decimal structure
 *	ln		maximum length of string buffer in bytes
 *	dg		number of decimal places
 *  Output:
 *	cp		pointer to character buffer
 *  Return value:
 *	0 if successful otherwise -1 and tserrno will return
 *	the error number
 *
 *  C-ISAM data type(s) requiring this function:
 *	decimal
 *-------------------------------------------------------------------*/

int     
tsdectoasc(dec_t *np,char *cp,int ln,int dg)
{
	/* User code goes here */
	return -1;
}

/*-------------------------------------------------------------------
 *  tslddecimal
 *  Convert a C-ISAM record to a DECIMALTYPE
 *
 *  Parameters:
 *  Input: 
 *	cp		record pointer
 *	len		decimal data length
 *  Output:
 *	dp		pointer to a dec_t structure to receive data
 *  Return value:
 *	-1201	Underflow error
 *	-1200	Overflow error
 *	    0	Successful
 *
 *  C-ISAM data type(s) requiring this function:
 *	decimal
 *	date(j4H_31dec1899)
 *-------------------------------------------------------------------*/

int     
tslddecimal(unsigned char *cp,int len,dec_t *dp)
{
	/* User code goes here */
	return -1;
}

/*-------------------------------------------------------------------
 *  tsdeccvasc
 *  Convert a C char type string to a DECIMALTYPE number
 *
 *  Parameters:
 *  Input: 
 *	cp		string value
 *	ln		string length
 *  Output:
 *	rp		pointer to dec_t structure to receive result
 *  Return value:
 *	-1216		Bad exponent
 *	-1213		Non-numeric chars in string
 *	-1201		Underflow
 *	-1200		Overflow
 *	   -1		Error. tserrno returns error code
 *	    0		Success
 *
 *  C-ISAM data type(s) requiring this function:
 *	decimal
 *-------------------------------------------------------------------*/

int     
tsdeccvasc(char *cp,int ln,dec_t *rp)
{
	/* User code goes here */
	return -1;
}

/* for use by Transoft Only */
char *
tsdsdname()
{
	return "TSISAM";
}

/* for use by Transoft Only */
char *
tsdsdversion()
{
	return NULL;
}
