/* 
   -------------------------------------------------------------------------
   Module name:		disam_fh.c
   Date of last delta:	2/7/01
   Release Number:	3.4
   Remarks:             D-ISAM File Handler Functions.
   Copyright:           Copyright (c) Transoft Ltd. 1995-2001, all rights
			reserved.  This source code is Transoft proprietary
			information and is copyright protected. 

			Copying or transfer of this source code is forbidden
			without the express written consent of Transoft Ltd.
   -------------------------------------------------------------------------
*/

#ifdef U_SCCS
static const char _sccs_ident[]="@(#) disam_fh.c 3.4 - 2/7/01";
#endif

#define DISAM_FH_C


#include <stdio.h>

#define IN_TSDEF 1

#include "ts_isam.h"
#include "ts_api.h"

extern int SQL_API     isopen(char *filename,int mode);
extern int SQL_API     isindexinfo(int isfd,struct keydesc *buffer,int number);
extern int SQL_API     isclose(int isfd);
extern int SQL_API     isstart(int isfd,struct keydesc *keydesc,int length,
							char *record,int mode);
extern int SQL_API     isread(int isfd,char *record,int mode);
extern int SQL_API     isrelease(int isfd);
extern int SQL_API     iswrite(int isfd,char *record);
extern int SQL_API     isrewcurr(int isfd,char *record);
extern int SQL_API	   isdelcurr(int isfd);
extern int SQL_API     isbegin(void);
extern int SQL_API     iscommit(void);
extern int SQL_API     isrollback(void);
extern int SQL_API     islogopen(char *logname);
extern int SQL_API     islogclose(void);
extern int * SQL_API   is_errno (int isfd);
extern int * SQL_API	is_reclen (int isfd);
extern long * SQL_API  is_recnum (int isfd);
extern int SQL_API lddecimal(unsigned char *cp,int len,dec_t *dp);
extern int SQL_API dectoasc(dec_t *np,char *cp,int ln,int dg);
extern int SQL_API deccvlong(long i,register dec_t *dp);
extern int SQL_API dectolong(dec_t *dp,long *ip);
extern int SQL_API deccvasc(char *cp,int ln,dec_t *rp);
extern int SQL_API stdecimal(dec_t *dp,unsigned char *cp,int len);
extern int SQL_API deccvint(int i,dec_t *dp);
extern int SQL_API isrewrec(int isfd,long recno,char *record);
extern int SQL_API istxninit(short (*)(void));

extern long isrecnum;

/* ------------------------------------------------------------------
 * X/Open standard compliant functions
 * ----------------------------------------------------------------*/

/*-------------------------------------------------------------------
 *  tsopen
 *  Open an ISAM file
 *
 *  Parameters:
 *  Input: 
 *	filename		the name of the file
 *	mode			locking mode in which to open the file	
 *  Output:
 *	None
 *  Return value:
 *	file descriptor upon successful completion, otherwise -1
 *	and tserrno will return the error number
 *-------------------------------------------------------------------*/

int
tsopen(char *filename,int mode)
{
    return isopen(filename,mode);
}							/* tsopen() */

/*-------------------------------------------------------------------
 *  tsindexinfo
 *  Obtain file information
 *
 *  Parameters:
 *  Input: 
 *	isfd		file descriptor returned by tsopen
 *	buffer		Native keydesc or dictinfo buffer in which
 *			to return data.
 *	number		index number or zero to return general file
 *			information into a buffer of type dictinfo
 *  Output:
 *		None
 *  Return value:
 *	0 if successful otherwise -1 and tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

int
tsindexinfo(int isfd, void *buffer,int number)
{
	return isindexinfo(isfd, (struct keydesc *)buffer, number);
}							/* tsindexinfo() */

/*-------------------------------------------------------------------
 *  tsclose
 *  Close an ISAM file
 *
 *  Parameters:
 *  Input: 
 *	isfd		file descriptor returned by tsopen
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

int
tsclose(int isfd)
{
    return isclose(isfd);
}							/* tsclose() */

/*-------------------------------------------------------------------
 *  tsstart
 *  Select an index and the subsequent starting point for reads
 *
 *  Parameters:
 *  Input: 
 *	isfd		file descriptor returned by tsopen
 *	keydesc		pointer to a native key description
 *			structure
 *	length		the part of the key which is significant
 *			for the search
 *	record		the key value sought
 *	mode		search mode
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

int
tsstart(int isfd, void *keydesc,int length,char *record,int mode) 
{
    return isstart(isfd,(struct keydesc *)keydesc, length, record,mode);
}							/* tsstart() */

/*-------------------------------------------------------------------
 *  tsread
 *  Read a record
 *
 *  Parameters:
 *  Input: 
 *	isfd		file descriptor returned by tsopen
 *	record		key value sought and returned record
 *	mode		search mode + locking mode
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

int
tsread(int isfd,char *record,int mode)
{
    return isread(isfd,record,mode);
}							/* tsread() */

/*-------------------------------------------------------------------
 *  tsrelease
 *  unlock records
 *
 *  Parameters:
 *  Input: 
 *	isfd		file descriptor returned by tsopen
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

int
tsrelease(int isfd)
{
    return isrelease(isfd);
}							/* tsrelease() */

/*-------------------------------------------------------------------
 *  tswrite
 *  Write record
 *
 *  Parameters:
 *  Input: 
 *	isfd		file descriptor returned by tsopen
 *	record		record to be written
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

int
tswrite(int isfd,char *record)
{
    return iswrite(isfd,record);
}							/* tswrite() */

/*-------------------------------------------------------------------
 *  tsrewcurr
 *  Rewrite current record
 *
 *  Parameters:
 *  Input: 
 *	isfd		file descriptor returned by tsopen
 *	record		record buffer with which to overwrite 
 *			current record
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

int
tsrewcurr(int isfd,char *record)
{
    return isrewrec(isfd,*is_recnum(isfd),record);
}							/* tsrewcurr() */

/*-------------------------------------------------------------------
 *  tsdelcurr
 *  Delete current record
 *
 *  Parameters:
 *  Input: 
 *	isfd		file descriptor returned by tsopen
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

int
tsdelcurr(int isfd)
{
    return isdelcurr(isfd);
}							/* tsdelcurr() */


/* ------------------------------------------------------------------
 * The following functions are not X/Open standard API functions 
 * ------------------------------------------------------------------*/

/*-------------------------------------------------------------------
 *  tspartsperkey
 *  Returns the maximum number of key parts supported by the file
 *  handler
 *
 *  Parameters:
 *  Input: 
 *	None
 *  Output:
 *	None
 *  Return value:
 *	Number of parts per key
 *-------------------------------------------------------------------*/

int      
tspartsperkey()
{
    return NPARTS;
}

/*-------------------------------------------------------------------
 *  tserrno
 *  Returns the last error number associated with a file handle
 *
 *  Parameters:
 *  Input: 
 *	isfd		File descriptor returned by tsopen
 *  Output:
 *	None
 *  Return value:
 *	error code
 *-------------------------------------------------------------------*/

int      
tserrno(int isfd)
{
        return (*is_errno(isfd));
}

#ifdef WIN32
long __stdcall GetCurrentThreadId(void);
/*-------------------------------------------------------------------
 * ShortThreadID
 * Returns the thread id as a short value for use with Transaction
 * pprocessing.
 *-------------------------------------------------------------------*/
static short ShortThreadID(void)
{
	return(short)GetCurrentThreadId();
}
#endif


/*-------------------------------------------------------------------
 *  tsversnumber
 *  Returns the file handler version number
 *
 *  Parameters:
 *  Input: 
 *	None
 *  Output:
 *	None
 *  Return value:
 *	Pointer to a string containing the version number
 *-------------------------------------------------------------------*/

char * 
tsversnumber(void)
{
	static char version[50];
#ifdef WIN32
	istxninit(ShortThreadID);
#endif
	sprintf(version, "%s (FH 1.4)", "6.12");
	return version;
}


/* ------------------------------------------------------------------
 * The following functions are not core functions and are not
 * required for a basic configuration
 * ------------------------------------------------------------------*/

/*-------------------------------------------------------------------
 *  tsbegin
 *  Defines the beginning of a transaction
 *
 *  Parameters:
 *  Input: 
 *	None
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

int
tsbegin(void)
{
    return isbegin();
}							/* tsbegin() */

/*-------------------------------------------------------------------
 *  tscommit
 *  End a transaction and release all locks
 *
 *  Parameters:
 *  Input: 
 *	None
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

int
tscommit(void)
{
    return iscommit();
}							/* tscommit() */

/*-------------------------------------------------------------------
 *  tsrollback
 *  Undo calls made since the last call to tsbegin
 *
 *  Parameters:
 *  Input: 
 *	None
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

int
tsrollback(void)
{
    return isrollback();
}							/* tsrollback() */


/*-------------------------------------------------------------------
 *  tslogopen
 *  Opens the transaction log file
 *
 *  Parameters:
 *  Input: 
 *	logname			pointer to filename
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

int
tslogopen(char *logname)
{
    return islogopen(logname);
}							/* tslogopen() */

/*-------------------------------------------------------------------
 *  tslogclose
 *  Close the transaction log file
 *
 *  Parameters:
 *  Input: 
 *	None
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and tserrno will return
 *	the error number
 *-------------------------------------------------------------------*/

int
tslogclose(void)
{
    return islogclose();
}							/* tslogclose() */

/*-------------------------------------------------------------------
 *  tsreclen
 *  Return the current record length
 *  (Multi threaded implementation of isreclen)
 *
 *  Parameters:
 *  Input: 
 *	isfd		file descriptor returned by tsopen
 *  Output:
 *	None
 *  Return value:
 *	Record length or -1 on error
 *-------------------------------------------------------------------*/

int      
tsreclen(int isfd)
{
    return *(is_reclen(isfd));
}

/*-------------------------------------------------------------------
 *  tssetreclen
 *  Set the current record length
 *  (Multi threaded implementation of isreclen)
 *
 *  Parameters:
 *  Input: 
 *	isfd		file descriptor returned by tsopen
 *	len		record length
 *  Output:
 *	None
 *  Return value:
 *	0 if successful or -1 on error
 *-------------------------------------------------------------------*/

int      
tssetreclen(int isfd, int len)
{
	*is_reclen(isfd) = len;
	return 0;
}

/*-------------------------------------------------------------------
 *  tsrecnum
 *  Return the current record number
 *  (Multi threaded implementation of isrecnum)
 *
 *  Parameters:
 *  Input: 
 *		isfd		file descriptor returned by tsopen
 *  Output:
 *		None
 *  Return value:
 *		Record number or -1 on error
 *-------------------------------------------------------------------*/

int      
tsrecnum(int isfd)
{
#if defined __MSVC
	return (*is_recnum(isfd));
#else
	return isrecnum;
#endif
}

/*-------------------------------------------------------------------
 *  tssetrecnum
 *  Set the current record number
 *  (Multi threaded implementation of isrecnum)
 *
 *  Parameters:
 *  Input: 
 *	isfd		file descriptor returned by tsopen
 *	rec		record number
 *  Output:
 *	None
 *  Return value:
 *	0 if successful or -1 on error
 *-------------------------------------------------------------------*/

int      
tssetrecnum(int isfd, int rec)
{
#if defined __MSVC
	*is_recnum(isfd) = rec;
#else
	isrecnum=rec;
#endif
	return 0;
}

/* ------------------------------------------------------------------
 * The following data type conversion functions are necessary for
 * some of the types built into the Transoft C-ISAM DSD.
 * If it is necessary to use any of the C-ISAM types that rely on
 * these functions then the code must be supplied by the user.
 * More information regarding these functions can be found in the 
 * Informix C-ISAM programmers manual.
 * -----------------------------------------------------------------*/

/*-------------------------------------------------------------------
 *  tsstdecimal
 *  Store a DECIMALTYPE into a C-ISAM record in packed format
 *
 *  Parameters:
 *  Input: 
 *	dp			dec_t structure containing the decimal data
 *	cp			data record pointer
 *	len			length of the decimal data in data record
 *  Output:
 *	None
 *  Return value:
 *	0 if successful otherwise -1 and tserrno will return
 *	the error number
 *
 *  C-ISAM data type(s) requiring this function:
 *	date(jd_31dec1799)
 *	decimal
 *-------------------------------------------------------------------*/

int     
tsstdecimal(dec_t *dp,unsigned char *cp,int len)
{
    return stdecimal(dp,cp,len);
}

/*-------------------------------------------------------------------
 *  tsdeccvint
 *  Convert a C type short into a DECIMALTYPE
 *
 *  Parameters:
 *  Input: 
 *	i		integer to convert
 *  Output:
 *	dp		dec_t structure to receive decimal data
 *  Return value:
 *	0 if successful otherwise -1 and tserrno will return
 *	the error number
 *
 *  C-ISAM data type(s) requiring this function:
 *	decimal
 *-------------------------------------------------------------------*/
                       
int     
tsdeccvint(int i,dec_t *dp)
{
    return deccvint(i,dp);
}

/*-------------------------------------------------------------------
 *  tsdectolong
 *  Convert a DECIMALTYPE into a C type long
 *
 *  Parameters:
 *  Input: 
 *	dp		pointer to a decimal structure
 *  Output:
 *	ip		pointer to a long to receive result
 *  Return value:
 *	0 if successful otherwise -1 and tserrno will return
 *	the error number
 *
 *  C-ISAM data type(s) requiring this function:
 *	jd_31dec1799
 *-------------------------------------------------------------------*/

int     
tsdectolong(dec_t *dp,long *ip)
{
    return dectolong(dp, ip);
}

/*-------------------------------------------------------------------
 *  tsdeccvlong
 *  Convert a C type long to DECIMALTYPE
 *
 *  Parameters:
 *  Input: 
 *	i		pointer to a long
 *  Output:
 *	dp		pointer to a dec_t structure to receive result
 *  Return value:
 *	-1200	DECIMALTYPE number greater than 2,147,483,647
 *	   -1	Error. tserrno returns error code
 *	    0	Success		
 *
 *  C-ISAM data type(s) requiring this function:
 *	jd_31dec1799
 *-------------------------------------------------------------------*/

int     
tsdeccvlong(long i,register dec_t *dp)
{
    return deccvlong(i,dp);
}

/*-------------------------------------------------------------------
 *  tsdectoasc
 *  Convert DECIMALTYPE to string
 *
 *  Parameters:
 *  Input: 
 *	np		pointer to a decimal structure
 *	ln		maximum length of string buffer in bytes
 *	dg		number of decimal places
 *  Output:
 *	cp		pointer to character buffer
 *  Return value:
 *	0 if successful otherwise -1 and tserrno will return
 *	the error number
 *
 *  C-ISAM data type(s) requiring this function:
 *	decimal
 *-------------------------------------------------------------------*/

int     
tsdectoasc(dec_t *np,char *cp,int ln,int dg)
{
    return dectoasc(np,cp,ln,dg);
}

/*-------------------------------------------------------------------
 *  tslddecimal
 *  Convert a C-ISAM record to a DECIMALTYPE
 *
 *  Parameters:
 *  Input: 
 *	cp		record pointer
 *	len		decimal data length
 *  Output:
 *	dp		pointer to a dec_t structure to receive data
 *  Return value:
 *	-1201	Underflow error
 *	-1200	Overflow error
 *	    0	Successful
 *
 *  C-ISAM data type(s) requiring this function:
 *	decimal
 *	date(j4H_31dec1899)
 *-------------------------------------------------------------------*/

int     
tslddecimal(unsigned char *cp,int len,dec_t *dp)
{
    return lddecimal(cp,len,dp);
}

/*-------------------------------------------------------------------
 *  tsdeccvasc
 *  Convert a C char type string to a DECIMALTYPE number
 *
 *  Parameters:
 *  Input: 
 *	cp		string value
 *	ln		string length
 *  Output:
 *	rp		pointer to dec_t structure to receive result
 *  Return value:
 *	-1216		Bad exponent
 *	-1213		Non-numeric chars in string
 *	-1201		Underflow
 *	-1200		Overflow
 *	   -1		Error. tserrno returns error code
 *	    0		Success
 *
 *  C-ISAM data type(s) requiring this function:
 *	decimal
 *-------------------------------------------------------------------*/

int     
tsdeccvasc(char *cp,int ln,dec_t *rp)
{
    return deccvasc(cp,ln,rp);
}


char *
tsdsdname()
{
	return "D-ISAM";
}

char *
tsdsdversion()
{
	return NULL;
}
