/*
   -------------------------------------------------------------------------
   Module name:         ts_isam.h
   Date of last delta:  3/30/00
   Release Number:      3.1
   Remarks:             Header file defining required ISAM API structures
			and error codes.
   Copyright:           Copyright (c) Transoft Ltd. 1995-1999, all rights
			reserved.  This source code is Transoft proprietary
			information and is copyright protected.

			Copying or transfer of this source code is forbidden
			without the express written consent of Transoft Ltd.
   -------------------------------------------------------------------------
*/

#ifndef TS_ISAM_H
#define TS_ISAM_H

#ifndef NPARTS
/* have to define a dummy value in the 'xopen' directory */
#define NPARTS 8
#endif

struct keypart
    {
    short kp_start;		/* starting byte of key part	*/
    short kp_leng;		/* length in bytes		*/
    short kp_type;		/* type of key part		*/
    };

struct keydesc
    {
    short k_flags;		/* flags			*/
    short k_nparts;		/* number of parts in key	*/
    struct keypart
	k_part[NPARTS];		/* each key part		*/
		    /* the following is for internal use only	*/
    short k_len;		/* length of whole key		*/
    long k_rootnode;		/* pointer to rootnode		*/
    };

struct dictinfo
    {
    short di_nkeys;		/* number of keys defined (msb set for VARLEN)*/
    short di_recsize;		/* (maximum) data record size	*/
    short di_idxsize;		/* index record size		*/
    long di_nrecords;		/* number of records in file	*/
    };

#define EDUPL	  100		/* duplicate record	*/
#define ENOTOPEN  101		/* file not open	*/
#define EBADARG   102		/* illegal argument	*/
#define EBADKEY   103		/* illegal key desc	*/
#define ETOOMANY  104		/* too many files open	*/
#define EBADFILE  105		/* bad isam file format	*/
#define ENOTEXCL  106		/* non-exclusive access	*/
#define ELOCKED   107		/* record locked	*/
#define EKEXISTS  108		/* key already exists	*/
#define EPRIMKEY  109		/* is primary key	*/
#define EENDFILE  110		/* end/begin of file	*/
#define ENOREC    111		/* no record found	*/
#define ENOCURR   112		/* no current record	*/
#define EFLOCKED  113		/* file locked		*/
#define EFNAME    114		/* file name too long	*/
#define ENOLOK    115		/* can't create lock file */
#define EBADMEM   116		/* can't alloc memory	*/
#define EBADCOLL  117		/* bad custom collating	*/
#define ELOGREAD  118		/* cannot read log rec  */
#define EBADLOG   119		/* bad log record	*/
#define ELOGOPEN  120		/* cannot open log file	*/
#define ELOGWRIT  121		/* cannot write log rec */
#define ENOTRANS  122		/* no transaction	*/
#define ENOSHMEM  123		/* no shared memory	*/
#define ENOBEGIN  124		/* no begin work yet	*/
#define ENONFS    125		/* can't use nfs 	*/
#define EBADROWID 126		/* reserved for future use */
#define ENOPRIM   127		/* no primary key	*/
#define ENOLOG    128		/* no logging		*/
#define EUSER     129		/* reserved for future use */
#define ENODBS    130		/* reserved for future use */
#define ENOFREE   131		/* no free disk space	*/
#define EROWSIZE  132		/* row size too big	*/
#define EAUDIT	  133		/* audit trail exists   */
#define ENOLOCKS  134		/* no more locks	*/
#define ENOPARTN  135		/* reserved for future use */
#define ENOEXTN   136		/* reserved for future use */
#define EOVCHUNK  137		/* reserved for future use */
#define EOVDBS    138		/* reserved for future use */
#define EOVLOG    139		/* reserved for future use */
#define EGBLSECT  140		/* global section disallowing access - VMS */
#define EOVPARTN  141		/* reserved for future use */
#define EOVPPAGE  142		/* reserved for future use */
#define EDEADLOK  143		/* reserved for future use */
#define EKLOCKED  144		/* reserved for future use */
#define ENOMIRROR 145           /* reserved for future use */
#define EDISKMODE 146           /* reserved for future use */
#define EARCHIVE  147		/* reserved for future use */
#define ENEMPTY	  148		/* reserved for future use */
#define EDEADDEM  149		/* reserved for future use */
#define EDEMO	  150		/* demo limits have been exceeded */
#define EBADVCLEN 151		/* reserved for future use */
#define EBADRMSG  152		/* reserved for future use */
#define ENOMANU   153		/* must be in ISMANULOCK mode */
#define EDEADTIME 154		/* reserved for future use */
#define EPMCHKBAD 155           /* reserved for future use */
#define EB_BUSY	  160		/* reserved for future use */
#define EB_NOOPEN 161		/* reserved for future use */
#define EB_NOBS	  162		/* reserved for future use */
#define EB_PAGE	  163		/* reserved for future use */
#define EB_STAMP  164		/* reserved for future use */
#define EB_NOCOL  165		/* reserved for future use */
#define EB_FULL   166		/* reserved for future use */
#define EB_PSIZE  167		/* reserved for future use */
#define EB_ARCH   168		/* reserved for future use */
#define EB_CHKNLOG 169		/* reserved for future use */
#define EB_IUBS	  170		/* reserved for future use */
#define EBADFORMAT 171		/* locking or NODESIZE change */

/* isopen, isbuild file types */
#define ISINPUT         0       /* open for input only          */
#define ISOUTPUT        1       /* open for output only         */
#define ISINOUT         2       /* open for input and output    */
#define ISTRANS		4	/* open for transaction proc	*/
#define ISNOLOG		8	/* no loggin for this file	*/
#define ISVARLEN	0x10	/* variable length records	*/
#define ISFIXLEN	0x0	/* (non-flag) fixed length records only	*/

/* isopen, isbuild lock modes */
#define ISAUTOLOCK	0x200	/* automatic record lock	*/
#define ISMANULOCK	0x400	/* manual record lock		*/
#define ISEXCLLOCK	0x800	/* exclusive isam file lock	*/

#define ISFIRST         0       /* position to first record     */
#define ISLAST          1       /* position to last record      */
#define ISNEXT          2       /* position to next record      */
#define ISPREV          3       /* position to previous record  */
#define ISCURR          4       /* position to current record   */
#define ISEQUAL         5       /* position to equal value      */
#define ISGREAT         6       /* position to greater value    */
#define ISGTEQ          7       /* position to >= value         */

#define ISLOCK     	0x100	/* record lock			*/

#define ISNODUPS  000           /* no duplicates allowed        */
#define ISDUPS    001           /* duplicates allowed           */

#define CHARTYPE        0
#define DECIMALTYPE     0
#define CHARSIZE        1

#define INTTYPE         1
#define INTSIZE         2

#define LONGTYPE        2
#define LONGSIZE        4

#define DOUBLETYPE      3
#define DOUBLESIZE      (sizeof(double))
                                                           
#define FLOATTYPE       4
#define FLOATSIZE       (sizeof(float))


#define BYTEMASK  0xFF		/* mask for one byte		*/
#define BYTESHFT  8		/* shift for one byte		*/

#ifndef	ldint
#define ldint(p)	((short)(((p)[0]<<BYTESHFT)+((p)[1]&BYTEMASK)))
#define stint(i,p)	((p)[0]=(i)>>BYTESHFT,(p)[1]=(i))
#endif	


#define DECSIZE 16


struct decimal
    {
    short dec_exp;		/* exponent base 100		*/
    short dec_pos;		/* sign: 1=pos, 0=neg, -1=null	*/
    short dec_ndgts;		/* number of significant digits	*/
    char  dec_dgts[DECSIZE];	/* actual digits base 100	*/
    };
typedef struct decimal dec_t;

#endif
